/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccSkuListInfoQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccCheckSkuParamsBO;
import com.tydic.commodity.common.ability.bo.UccCheckSkuPicBO;
import com.tydic.commodity.common.ability.bo.UccSkuListInfoQryAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuListInfoQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListInfoQryAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPoExt;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuSpecPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuListInfoQryAbilityService"})
public class UccSkuListInfoQryAbilityServiceImpl
implements UccSkuListInfoQryAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;

    @PostMapping(value={"qryCheckSkuList"})
    public UccSkuListInfoQryAbilityRspBO qryCheckSkuList(@RequestBody UccSkuListInfoQryAbilityReqBO reqBO) {
        UccSkuListInfoQryAbilityRspBO rspBO = new UccSkuListInfoQryAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("skuIds\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getType()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("type\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<UccSkuListInfoQryAbilityBO> rows = new ArrayList<UccSkuListInfoQryAbilityBO>();
        if (UccConstants.SyncPriceType.SYNC_COMMERCE_MESSAGE_CHANGE == reqBO.getType() || UccConstants.SyncPriceType.SYNC_MESSAGE_MODIFY == reqBO.getType()) {
            List uccSkuPoExts = this.uccSkuMapper.qryCheckSkuListBySkuIds(reqBO.getSkuIds());
            List uccSkuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuIdList(reqBO.getSkuIds());
            Map<Long, List<UccSkuPicPo>> picMap = uccSkuPicPos.stream().collect(Collectors.groupingBy(UccSkuPicPo::getSkuId));
            List uccSkuSpecPos = this.uccSkuSpecMapper.qryBatchBySkus(reqBO.getSkuIds());
            Map<Long, List<UccSkuSpecPo>> specMap = uccSkuSpecPos.stream().collect(Collectors.groupingBy(UccSkuSpecPo::getSkuId));
            for (UccSkuPoExt uccSkuPoExt : uccSkuPoExts) {
                String json = JSONObject.toJSONString((Object)uccSkuPoExt);
                UccSkuListInfoQryAbilityBO bo = (UccSkuListInfoQryAbilityBO)JSONObject.parseObject((String)json, UccSkuListInfoQryAbilityBO.class);
                if (null != bo.getInquiryPrice()) {
                    bo.setIsInquiry("1");
                } else {
                    bo.setIsInquiry("0");
                }
                List<UccSkuPicPo> picList = picMap.get(bo.getSkuId());
                ArrayList<UccCheckSkuPicBO> pics = new ArrayList<UccCheckSkuPicBO>();
                for (UccSkuPicPo uccSkuPicPo : picList) {
                    UccCheckSkuPicBO picBO = new UccCheckSkuPicBO();
                    picBO.setPicId(uccSkuPicPo.getSkuPicId());
                    picBO.setPicType(uccSkuPicPo.getCommodityPicType());
                    picBO.setPicUrl(uccSkuPicPo.getSkuPicUrl());
                    pics.add(picBO);
                }
                bo.setSkuPicList(pics);
                List<UccSkuSpecPo> specList = specMap.get(bo.getSkuId());
                ArrayList<UccCheckSkuParamsBO> skuParamList = new ArrayList<UccCheckSkuParamsBO>();
                for (UccSkuSpecPo uccSkuSpecPo : specList) {
                    UccCheckSkuParamsBO paramsBO = new UccCheckSkuParamsBO();
                    paramsBO.setPropName(uccSkuSpecPo.getPropName());
                    paramsBO.setPropValue(uccSkuSpecPo.getPropValue());
                    skuParamList.add(paramsBO);
                }
                bo.setSkuParamList(skuParamList);
                rows.add(bo);
            }
        } else if (UccConstants.SyncPriceType.SYNC_MESSAGE_PRICE == reqBO.getType() || UccConstants.SyncPriceType.SYNC_MESSAGE_SHELF == reqBO.getType()) {
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuIds());
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                String json = JSONObject.toJSONString((Object)uccSkuPo);
                UccSkuListInfoQryAbilityBO bo = (UccSkuListInfoQryAbilityBO)JSONObject.parseObject((String)json, UccSkuListInfoQryAbilityBO.class);
                rows.add(bo);
            }
            List uccSkuPricePos = this.uccSkuPriceMapper.qryPriceBySkuIds(reqBO.getSkuIds());
            Map<Long, List<UccSkuPricePo>> PriceMap = uccSkuPricePos.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSkuId));
            for (UccSkuListInfoQryAbilityBO row : rows) {
                List<UccSkuPricePo> uccSkuPricePos1 = PriceMap.get(row.getSkuId());
                row.setAgreementPrice(uccSkuPricePos1.get(0).getAgreementPrice());
                row.setSalePrice(uccSkuPricePos1.get(0).getSalePrice());
                row.setMarketPrice(uccSkuPricePos1.get(0).getMarketPrice());
            }
        }
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

