/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.SkuInfoConstant;
import com.tydic.commodity.common.ability.api.UccSkuModifyInfoAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuModifyInfoAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuModifyInfoAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSkuModifyInfoBusiService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuModifyInfoAbilityService"})
public class UccSkuModifyInfoAbilityServiceImpl
implements UccSkuModifyInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuModifyInfoAbilityServiceImpl.class);
    @Autowired
    private UccSkuModifyInfoBusiService uccSkuModifyInfoBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Value(value="${MONITOR_PRICE_SYNC_TOPIC}")
    private String monitorPriceSyncTopic;
    @Value(value="${MONITOR_PRICE_SYNC_TAG}")
    private String monitorPriceSyncTag;
    @Resource(name="monitorPriceServiceProvider")
    private ProxyMessageProducer monitorPriceServiceProvider;

    @PostMapping(value={"modifySkuInfo"})
    public UccSkuModifyInfoAbilityRspBO modifySkuInfo(@RequestBody UccSkuModifyInfoAbilityReqBO reqBO) {
        UccSkuModifyInfoAbilityRspBO rspBO = new UccSkuModifyInfoAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getResultSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u68c0\u6d4b\u5355\u54c1\u96c6\u5408\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = this.uccSkuModifyInfoBusiService.modifySkuInfo(reqBO);
        List<Long> skuIdList = reqBO.getResultSkuList().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
        List skuPoList = this.uccSkuMapper.qeryBatchSkus(skuIdList);
        Map<Long, List<UccSkuPo>> shopIdAllSkuPoMap = skuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long supplierShopId : shopIdAllSkuPoMap.keySet()) {
            List skuIds = shopIdAllSkuPoMap.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u5355\u54c1ID\u540c\u6b65ES\u6570\u636e MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25" + e.getMessage());
            }
        }
        if (SkuInfoConstant.PRICE_CHECK == reqBO.getBusinessType()) {
            this.syncMonitorPrice(skuIdList);
        }
        return rspBO;
    }

    private void syncMonitorPrice(List<Long> skuIds) {
        JSONObject object = new JSONObject();
        object.put("syncType", (Object)4);
        object.put("poolName", (Object)"supermarket");
        object.put("skuIds", skuIds);
        log.info("\u63a8\u9001\u4ef7\u683c\u68c0\u6d4b\u72b6\u6001\u540c\u6b65\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)object));
        this.monitorPriceServiceProvider.send(new ProxyMessage(this.monitorPriceSyncTopic, this.monitorPriceSyncTag, JSON.toJSONString((Object)object)));
    }
}

