/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.enumType.UccJnSupplierTypeEnum;
import com.tydic.commodity.common.ability.api.UccSkuPoolVendorListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuPoolVendorListQryAbilityBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolVendorListQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolVendorListQryAbilityRspBo;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPoolVendorListQryAbilityService"})
public class UccSkuPoolVendorListQryAbilityServiceImpl
implements UccSkuPoolVendorListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPoolVendorListQryAbilityServiceImpl.class);
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;

    @PostMapping(value={"qrySkuPoolVendorList"})
    public UccSkuPoolVendorListQryAbilityRspBo qrySkuPoolVendorList(@RequestBody UccSkuPoolVendorListQryAbilityReqBo reqBo) {
        List vendorIds;
        List cnncUccVendorPOS;
        UccSkuPoolVendorListQryAbilityRspBo rspBo = new UccSkuPoolVendorListQryAbilityRspBo();
        try {
            ValidatorUtil.validator((Object)reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(e.getMessage());
            return rspBo;
        }
        ArrayList uccSkuPoolVendorListQryAbilityBos = new ArrayList();
        Page page = new Page();
        if (reqBo.getSearchType() == 0) {
            List cnncUccVendorPOS2;
            page.setPageNo(-1);
            UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
            cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
            cnncRelPoolCommodityPo.setPoolRelated(Integer.valueOf(3));
            cnncRelPoolCommodityPo.setTabSuffix(reqBo.getTabSuffix());
            List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
            List<Object> vendorIds2 = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos)) {
                vendorIds2 = cnncRelPoolCommodityPos.stream().map(a -> a.getSource()).collect(Collectors.toList());
            }
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
            List supplierTypes = new ArrayList();
            if (reqBo.getPurchaseFlag() != null) {
                supplierTypes = UccJnSupplierTypeEnum.getSupplierTypesByPurchaseFlag((Integer)reqBo.getPurchaseFlag());
            }
            if (!CollectionUtils.isEmpty((Collection)(cnncUccVendorPOS2 = this.uccVendorMapper.qryNotInPoolVendor(page, vendorIds2, reqBo.getVendorId(), reqBo.getVendorName(), supplierTypes)))) {
                cnncUccVendorPOS2.forEach(each -> {
                    UccSkuPoolVendorListQryAbilityBo uccSkuPoolVendorListQryAbilityBo = new UccSkuPoolVendorListQryAbilityBo();
                    uccSkuPoolVendorListQryAbilityBo.setVendorId(each.getVendorId());
                    uccSkuPoolVendorListQryAbilityBo.setVendorName(each.getVendorName());
                    uccSkuPoolVendorListQryAbilityBos.add(uccSkuPoolVendorListQryAbilityBo);
                });
            }
        } else {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
            List uccSkuPoolVendorListQryAbilityBoList = new ArrayList();
            List poolVendorListQryAbilityPOS = this.uccRelPoolCommodityMapper.getVendorListByPool(page, reqBo.getPoolId(), reqBo.getVendorId(), reqBo.getVendorName());
            if (!CollectionUtils.isEmpty((Collection)poolVendorListQryAbilityPOS)) {
                uccSkuPoolVendorListQryAbilityBoList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)poolVendorListQryAbilityPOS), UccSkuPoolVendorListQryAbilityBo.class);
                uccSkuPoolVendorListQryAbilityBos.addAll(uccSkuPoolVendorListQryAbilityBoList);
            }
        }
        if (!CollectionUtils.isEmpty(uccSkuPoolVendorListQryAbilityBos) && !CollectionUtils.isEmpty((Collection)(cnncUccVendorPOS = this.uccVendorMapper.getSkuNumByVendor(vendorIds = uccSkuPoolVendorListQryAbilityBos.stream().map(a -> a.getVendorId()).collect(Collectors.toList()))))) {
            Map<Long, Long> vendorConnt = cnncUccVendorPOS.stream().collect(Collectors.toMap(a -> a.getVendorId(), b -> b.getSkuNum()));
            Map<Long, Long> vendorSpuConnt = cnncUccVendorPOS.stream().collect(Collectors.toMap(a -> a.getVendorId(), b -> b.getSpuNum()));
            uccSkuPoolVendorListQryAbilityBos.forEach(each -> {
                each.setSkuNum((Long)vendorConnt.get(each.getVendorId()));
                each.setSpuNum((Long)vendorSpuConnt.get(each.getVendorId()));
            });
        }
        rspBo.setRows(uccSkuPoolVendorListQryAbilityBos);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

