/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccSkuPriceAbnormalRemovalBo;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.busi.bo.UccSkuPriceAbnormalRemovalBusiReqBo;
import com.tydic.commodity.busibase.busi.bo.UccSkuPriceAbnormalRemovalBusiRspBo;
import com.tydic.commodity.common.ability.api.UccSkuPriceAbnormalRemovalAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuListBo;
import com.tydic.commodity.common.ability.bo.UccSkuPriceAbnormalRemovalAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPriceAbnormalRemovalAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccSkuPriceSyncDataBo;
import com.tydic.commodity.common.ability.bo.UccSkuPriceSyncReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPriceSyncResultBo;
import com.tydic.commodity.common.ability.bo.UccSkuPriceSyncResultRspBo;
import com.tydic.commodity.common.busi.api.UccSkuPriceAbnormalRemovalBusiService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPriceAbnormalRemovalAbilityService"})
public class UccSkuPriceAbnormalRemovalAbilityServiceImpl
implements UccSkuPriceAbnormalRemovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPriceAbnormalRemovalAbilityServiceImpl.class);
    @Autowired
    private UccSkuPriceAbnormalRemovalBusiService uccSkuPriceAbnormalRemovalBusiService;
    @Value(value="${ucc.sku.price.sync.url:iio2/046564/tydicApi/skuPriceSyncResult}")
    private String skuPriceSyncUrl;
    public static final String NORMAL = "1";
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private static final String SUPERMARKET = "supermarket";
    private static final String EMPLOYEE_MARKET = "employeeMarket";
    private static final String EMPLOYEE = "1";
    private static final String COMPANY = "2";

    @PostMapping(value={"dealPriceAbnormal"})
    public UccSkuPriceAbnormalRemovalAbilityRspBo dealPriceAbnormal(@RequestBody UccSkuPriceAbnormalRemovalAbilityReqBo reqBo) {
        UccSkuPriceAbnormalRemovalAbilityServiceImpl.val(reqBo);
        UccSkuPriceSyncReqBo uccSkuPriceSyncReqBo = new UccSkuPriceSyncReqBo();
        uccSkuPriceSyncReqBo.setSerialNo(Convert.toStr((Object)Sequence.getInstance().nextId()));
        if ("1".equals(reqBo.getSpDesc())) {
            uccSkuPriceSyncReqBo.setPoolName(EMPLOYEE_MARKET);
        } else if (COMPANY.equals(reqBo.getSpDesc())) {
            uccSkuPriceSyncReqBo.setPoolName(SUPERMARKET);
        } else {
            throw new BaseBusinessException("8888", "\u672a\u77e5\u5546\u54c1\u6765\u6e90");
        }
        ArrayList<UccSkuListBo> skuList = new ArrayList<UccSkuListBo>();
        for (UccSkuPriceAbnormalRemovalBo uccSkuPriceAbnormalRemovalBo : reqBo.getUccSkuPriceAbnormalRemovalBoList()) {
            UccSkuListBo uccSkuListBo = new UccSkuListBo();
            uccSkuListBo.setCheckPrice(uccSkuPriceAbnormalRemovalBo.getPrice());
            uccSkuListBo.setSkuId(Convert.toStr((Object)uccSkuPriceAbnormalRemovalBo.getSkuId()));
            uccSkuListBo.setPriceType("sales");
            skuList.add(uccSkuListBo);
        }
        UccSkuPriceSyncDataBo data = new UccSkuPriceSyncDataBo();
        data.setSkuList(skuList);
        uccSkuPriceSyncReqBo.setData(data);
        String reqJson = JSON.toJSONString((Object)uccSkuPriceSyncReqBo);
        log.debug("\u8bf7\u6c42\u5546\u54c1\u4ef7\u683c\u68c0\u6d4bURL:{} , \u5165\u53c2:{}", (Object)this.skuPriceSyncUrl, (Object)reqJson);
        String result = HttpUtil.post((String)this.skuPriceSyncUrl, (String)reqJson);
        log.debug("\u8bf7\u6c42\u5546\u54c1\u4ef7\u683c\u68c0\u6d4b\u51fa\u53c2:{}", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new BaseBusinessException("8888", "\u8bf7\u6c42\u5546\u54c1\u4ef7\u683c\u68c0\u6d4b\u51fa\u53c2\u4e3a\u7a7a");
        }
        UccSkuPriceSyncResultRspBo uccSkuPriceSyncResultRspBo = (UccSkuPriceSyncResultRspBo)JUtil.jss((String)result, UccSkuPriceSyncResultRspBo.class);
        if (null == uccSkuPriceSyncResultRspBo.getResult()) {
            throw new BaseBusinessException("8888", "\u8bf7\u6c42\u5546\u54c1\u4ef7\u683c\u68c0\u6d4b\u8fd4\u56de\u53c2\u6570result\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)uccSkuPriceSyncResultRspBo.getResult().getSkuResultList())) {
            throw new BaseBusinessException("8888", "\u8bf7\u6c42\u5546\u54c1\u4ef7\u683c\u68c0\u6d4b\u8fd4\u56de\u53c2\u6570skuResultList\u4e3a\u7a7a");
        }
        Map<String, UccSkuPriceSyncResultBo> skuResultMap = uccSkuPriceSyncResultRspBo.getResult().getSkuResultList().stream().collect(Collectors.toMap(UccSkuPriceSyncResultBo::getSkuId, o -> o, (o1, o2) -> o1));
        ArrayList<UccSkuPriceAbnormalRemovalBo> abnormalBoList = new ArrayList<UccSkuPriceAbnormalRemovalBo>();
        for (UccSkuPriceAbnormalRemovalBo uccSkuPriceAbnormalRemovalBo : reqBo.getUccSkuPriceAbnormalRemovalBoList()) {
            UccSkuPriceSyncResultBo uccSkuPriceSyncResultBo = skuResultMap.get(uccSkuPriceAbnormalRemovalBo.getSkuId().toString());
            if (null == uccSkuPriceSyncResultBo) continue;
            if (null != uccSkuPriceSyncResultBo.getUpDownType()) {
                uccSkuPriceAbnormalRemovalBo.setDownFLag(uccSkuPriceSyncResultBo.getUpDownType());
            }
            uccSkuPriceAbnormalRemovalBo.setIsAnomalousPrice(Convert.toInt((Object)uccSkuPriceSyncResultBo.getResultType()));
            abnormalBoList.add(uccSkuPriceAbnormalRemovalBo);
        }
        UccSkuPriceAbnormalRemovalAbilityRspBo rspBo = new UccSkuPriceAbnormalRemovalAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty(abnormalBoList)) {
            UccSkuPriceAbnormalRemovalBusiReqBo uccSkuPriceAbnormalRemovalBusiReqBo = new UccSkuPriceAbnormalRemovalBusiReqBo();
            uccSkuPriceAbnormalRemovalBusiReqBo.setUccSkuPriceAbnormalRemovalBoList(abnormalBoList);
            UccSkuPriceAbnormalRemovalBusiRspBo uccSkuPriceAbnormalRemovalBusiRspBo = this.uccSkuPriceAbnormalRemovalBusiService.dealPriceAbnormal(uccSkuPriceAbnormalRemovalBusiReqBo);
            if (!"0000".equals(uccSkuPriceAbnormalRemovalBusiRspBo.getRespCode())) {
                throw new BaseBusinessException(uccSkuPriceAbnormalRemovalBusiRspBo.getRespCode(), uccSkuPriceAbnormalRemovalBusiRspBo.getRespDesc());
            }
            List downSkuList = abnormalBoList.stream().filter(UccSkuPriceAbnormalRemovalBo::getDownFLag).collect(Collectors.toList());
            rspBo.setUccSkuPriceAbnormalRemovalBoList(downSkuList);
            this.syncEs(abnormalBoList);
        }
        return rspBo;
    }

    private void syncEs(List<UccSkuPriceAbnormalRemovalBo> abnormalBoList) {
        List skuIds = abnormalBoList.stream().map(UccSkuPriceAbnormalRemovalBo::getSkuId).collect(Collectors.toList());
        List skuPoList = this.uccSkuMapper.getSkuSupplierList(skuIds);
        if (!CollectionUtils.isEmpty((Collection)skuPoList)) {
            Map<Long, List<UccSkuPo>> supSkuMap = skuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            supSkuMap.forEach((supplierShopId, uccSkuPos) -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                ArrayList<Long> delObjIdList = new ArrayList<Long>();
                for (UccSkuPo skuPo : uccSkuPos) {
                    delObjIdList.add(skuPo.getSkuId());
                }
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setSkuIds(delObjIdList);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            });
        }
    }

    private static void val(UccSkuPriceAbnormalRemovalAbilityReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getSpDesc())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u6765\u6e90\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUccSkuPriceAbnormalRemovalBoList())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5355\u54c1ID\u4e3a\u7a7a");
        }
        for (UccSkuPriceAbnormalRemovalBo uccSkuPriceAbnormalRemovalBo : reqBo.getUccSkuPriceAbnormalRemovalBoList()) {
            if (null == uccSkuPriceAbnormalRemovalBo.getSkuId()) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5355\u54c1ID\u4e3a\u7a7a");
            }
            if (null != uccSkuPriceAbnormalRemovalBo.getPrice()) continue;
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5355\u54c1ID\u4e3a\u7a7a");
        }
    }
}

