/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.CommdPropDefBO;
import com.tydic.commodity.common.ability.api.UccSpuAttributeListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSpuAttributeListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuAttributeListQryAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuAttributeListQryAbilityService"})
public class UccSpuAttributeListQryAbilityServiceImpl
implements UccSpuAttributeListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuAttributeListQryAbilityServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;

    @PostMapping(value={"getAttributeListQry"})
    public UccSpuAttributeListQryAbilityRspBO getAttributeListQry(@RequestBody UccSpuAttributeListQryAbilityReqBO reqBO) {
        UccSpuAttributeListQryAbilityRspBO rspBO = new UccSpuAttributeListQryAbilityRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        String json = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        log.error("\u5165\u53c2json" + json);
        UccCommdPropDefPo uccCommdPropDefPo = (UccCommdPropDefPo)JSON.parseObject((String)json, UccCommdPropDefPo.class);
        log.error("\u5165\u53c2po" + uccCommdPropDefPo.toString());
        List uccCommdPropDefPos = null;
        log.error("queryListPage" + uccCommdPropDefPo.toString());
        uccCommdPropDefPos = this.uccCommodityPropDefMapper.queryListPage(page, uccCommdPropDefPo);
        ArrayList<CommdPropDefBO> list = new ArrayList<CommdPropDefBO>();
        if (!CollectionUtils.isEmpty((Collection)uccCommdPropDefPos)) {
            List uccCommodityMeasurePo = this.uccCommodityMeasureMapper.queryMeasureByIdList(uccCommdPropDefPos.stream().map(UccCommdPropDefPo::getMeasureId).collect(Collectors.toList()));
            Map<Long, String> measureMap = uccCommodityMeasurePo.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, UccCommodityMeasurePo::getMeasureName));
            Map<String, Map<String, String>> dicMap = this.uccDictionaryAtomService.queryBypCodeListBackMap(Arrays.asList("COMMODITY_PROP_DEF_PROP_TYPE", "COMMODITY_PROP_DEF_PROP_TAG", "COMMODITY_PROP_DEF_INPUT_TYPE", "COMMODITY_PROP_DEF_FILTER_FLAG", "COMMODITY_PROP_DEF_REQUIRED_FLAG", "COMMODITY_PROP_DEF_MULTI_FLAG", "COMMODITY_PROP_DEF_PROPERTY_LINK", "PROP_SCOPE", "PROP_SOURCE", "OOOC_CLEAN"));
            Map<String, String> commodityPropDefPropTypeMap = this.get(dicMap, "COMMODITY_PROP_DEF_PROP_TYPE");
            Map<String, String> commodityPropDefPropTagMap = this.get(dicMap, "COMMODITY_PROP_DEF_PROP_TAG");
            Map<String, String> propDefInputTypeMap = this.get(dicMap, "COMMODITY_PROP_DEF_INPUT_TYPE");
            Map<String, String> propDefFilterFlagMap = this.get(dicMap, "COMMODITY_PROP_DEF_FILTER_FLAG");
            Map<String, String> propDefRequiredFlagMap = this.get(dicMap, "COMMODITY_PROP_DEF_REQUIRED_FLAG");
            Map<String, String> propDefMultiFlagMap = this.get(dicMap, "COMMODITY_PROP_DEF_MULTI_FLAG");
            Map<String, String> propDefPropertyLinkMap = this.get(dicMap, "COMMODITY_PROP_DEF_PROPERTY_LINK");
            Map<String, String> propScopeMap = this.get(dicMap, "PROP_SCOPE");
            Map<String, String> propSourceMap = this.get(dicMap, "PROP_SOURCE");
            Map<String, String> ooocCleanMap = this.get(dicMap, "OOOC_CLEAN");
            for (UccCommdPropDefPo po : uccCommdPropDefPos) {
                String boJson = JSONObject.toJSONString((Object)po, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                CommdPropDefBO bo = (CommdPropDefBO)JSON.parseObject((String)boJson, CommdPropDefBO.class);
                if (bo.getMeasureId() != null) {
                    bo.setMeasureName(measureMap.get(bo.getMeasureId()));
                }
                if (po.getPropType() != null) {
                    bo.setPropTypeTranslation(commodityPropDefPropTypeMap.get(Convert.toStr((Object)po.getPropType())));
                }
                if (po.getPropTag() != null) {
                    bo.setPropTagTranslation(commodityPropDefPropTagMap.get(Convert.toStr((Object)po.getPropTag())));
                }
                if (po.getInputType() != null) {
                    bo.setInputTypeTranslation(propDefInputTypeMap.get(Convert.toStr((Object)po.getInputType())));
                }
                if (po.getFilterFlag() != null) {
                    bo.setFilterFlagTranslation(propDefFilterFlagMap.get(Convert.toStr((Object)po.getFilterFlag())));
                }
                if (po.getRequiredFlag() != null) {
                    bo.setRequiredFlagTranslation(propDefRequiredFlagMap.get(Convert.toStr((Object)po.getRequiredFlag())));
                }
                if (po.getMultiFlag() != null) {
                    bo.setMultiFlagTranslation(propDefMultiFlagMap.get(Convert.toStr((Object)po.getMultiFlag())));
                }
                if (po.getPropertyLink() != null) {
                    bo.setPropertyLinkTranslation(propDefPropertyLinkMap.get(Convert.toStr((Object)po.getPropertyLink())));
                }
                if (po.getPropScope() != null) {
                    bo.setPropScopeTranslation(propScopeMap.get(Convert.toStr((Object)po.getPropScope())));
                }
                if (po.getPropSource() != null) {
                    bo.setPropSourceDesc(propSourceMap.get(Convert.toStr((Object)po.getPropSource())));
                }
                if (po.getOoocClean() != null) {
                    bo.setOoocCleanDesc(ooocCleanMap.get(Convert.toStr((Object)po.getOoocClean())));
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (po.getCreateTime() != null) {
                    String dateString = formatter.format(po.getCreateTime());
                    bo.setCreateTime(dateString);
                }
                if (po.getUpdateTime() != null) {
                    String dateString2 = formatter.format(po.getUpdateTime());
                    bo.setUpdateTime(dateString2);
                }
                list.add(bo);
            }
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<String, String> get(Map<String, Map<String, String>> dicMap, String pCode) {
        Map<String, String> map = dicMap.get(pCode);
        if (null == map) {
            return new HashMap<String, String>();
        }
        return map;
    }
}

