/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.api.UccSpuIdListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSpuIdListQryAbilityServiceRspBo;
import com.tydic.commodity.common.ability.bo.UccSpuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccQrySkuBatchDealRecordByPageBusiService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuIdListQryAbilityService"})
public class UccSpuIdListQryAbilityServiceImpl
implements UccSpuIdListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuIdListQryAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    private Long userId;
    @Autowired
    private UccQrySkuBatchDealRecordByPageBusiService uccQrySkuBatchDealRecordByPageBusiService;

    @PostMapping(value={"getSpuManagementListQry"})
    public UccSpuIdListQryAbilityServiceRspBo getSpuManagementListQry(@RequestBody UccSpuManagementListQryAbilityReqBO reqBO) {
        this.userId = reqBO.getUserId();
        UccSpuIdListQryAbilityServiceRspBo rspBo = new UccSpuIdListQryAbilityServiceRspBo();
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setRespCode("0000");
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSpuIdListQryAbilityServiceRspBo dealSearchData(String result, UccSpuManagementListQryAbilityReqBO reqBo) {
        UccSpuIdListQryAbilityServiceRspBo rspBo = new UccSpuIdListQryAbilityServiceRspBo();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        ArrayList<Long> commodityModels = new ArrayList<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                commodityModels.add(data.getLong("commodity_id"));
            }
        }
        rspBo.setCommodityIds(commodityModels);
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSpuManagementListQryAbilityReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"spu_approval_status", (Object)reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityTypeId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (String)reqBo.getCommodityId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExportCommodityIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (Collection)reqBo.getExportCommodityIds()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"L4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        ArrayList proNotExtOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getProNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getPurNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getSupNotExtendOrgIds());
        }
        ArrayList extOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getProExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getPurExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getSupExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty(proNotExtOrgIdList) || !CollectionUtils.isEmpty(extOrgIdList)) {
            BoolQueryBuilder orgQueryBuilder = QueryBuilders.boolQuery();
            if (!CollectionUtils.isEmpty(proNotExtOrgIdList)) {
                List collect = proNotExtOrgIdList.stream().distinct().collect(Collectors.toList());
                orgQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_org_id", collect));
            }
            if (!CollectionUtils.isEmpty(extOrgIdList)) {
                List extOrgIds = extOrgIdList.stream().distinct().collect(Collectors.toList());
                for (Long extOrgId : extOrgIds) {
                    orgQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"supplier_org_path.keyword", (String)("*" + extOrgId + "*")));
                }
            }
            boolQueryBuilder.must((QueryBuilder)orgQueryBuilder);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operOrgIds", (Collection)reqBo.getOperOrgIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperRoleIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operRoleIds", (Collection)reqBo.getOperRoleIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperStationCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operStationCodes", (Collection)reqBo.getOperStationCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getLimitOrderList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"limit_order", (Collection)reqBo.getLimitOrderList()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", (Collection)reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSpuManagementListQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("_source", (Object)"commodity_id");
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"create_time").order(SortOrder.DESC);
        queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        JSONObject collapse = new JSONObject();
        collapse.put("field", (Object)"commodity_id");
        queryJson.put("collapse", (Object)collapse);
        JSONObject aggs = new JSONObject();
        if (reqBo.isCollapse()) {
            JSONObject total = new JSONObject();
            JSONObject cardinality = new JSONObject();
            total.put("field", (Object)"commodity_id");
            total.put("precision_threshold", (Object)40000);
            cardinality.put("cardinality", (Object)total);
            aggs.put("books_count", (Object)cardinality);
        }
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }
}

