/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSyncSceneCommodityToEsAbilityService;
import com.tydic.commodity.common.ability.bo.SyncAllCommodityToEsReqBO;
import com.tydic.commodity.common.busi.api.SyncSceneCommodityToEsBusiService;
import com.tydic.commodity.common.busi.bo.SynEsInfoThreadBo;
import com.tydic.commodity.common.busi.impl.SynEsInfoThread;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSyncSceneCommodityToEsAbilityService"})
public class UccSyncSceneCommodityToEsAbilityServiceImpl
implements UccSyncSceneCommodityToEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncSceneCommodityToEsAbilityServiceImpl.class);
    @Autowired
    private SyncSceneCommodityToEsBusiService syncSceneCommodityToEsBusiService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    private ExecutorService fixedThreadPool = null;
    private Integer syncSpuSize = 100;
    @Value(value="${allSnycType:0}")
    private String allSnycType;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;

    @PostMapping(value={"syncSceneCommodityToEs"})
    public SyncSceneCommodityToEsRspBO syncSceneCommodityToEs(@RequestBody SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        return this.syncSceneCommodityToEsBusiService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
    }

    @PostMapping(value={"syncAlllCommodityToEs"})
    public SyncSceneCommodityToEsRspBO syncAlllCommodityToEs(@RequestBody SyncAllCommodityToEsReqBO reqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        long star = System.currentTimeMillis();
        if (reqBO.getSupplierId() != null) {
            this.synMq(reqBO);
        } else {
            List countShopIds = this.uccCommodityMapper.countShopIds();
            for (Long each : countShopIds) {
                reqBO.setSupplierId(each);
                this.synMq(reqBO);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a " + (System.currentTimeMillis() - star));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private SyncSceneCommodityToEsRspBO synMq(SyncAllCommodityToEsReqBO reqBO) {
        Integer skuCount = this.uccSkuMapper.countSkuByShopId(reqBO.getSupplierId());
        Integer size = 200;
        Integer cylc = skuCount % size == 0 ? skuCount / size : skuCount / size + 1;
        Page page = new Page();
        for (int i = 0; i < cylc; ++i) {
            page.setPageSize(size.intValue());
            page.setPageNo(i + 1);
            List skuList = this.uccSkuMapper.pageQryByShopId(page, reqBO.getSupplierId());
            if (CollectionUtils.isEmpty((Collection)skuList)) continue;
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skuList);
            syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierId());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            syncSceneCommodityToEsReqBO.setSysSearchFlag(Boolean.valueOf(true));
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                continue;
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
        log.info("\u5546\u54c1\u6570\u636e\u5904\u7406\u5b8c\u6210\uff1a supplierId =" + reqBO.getSupplierId());
        return null;
    }

    private SyncSceneCommodityToEsRspBO syncToEsImpl(SyncAllCommodityToEsReqBO reqBO) {
        int cycle;
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        int total = this.uccCommodityMapper.countCommodity(reqBO.getSupplierId());
        if (total == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5e97\u94fa\u4e0b\u65e0\u540c\u6b65\u6570\u636e");
            return rspBO;
        }
        int n = cycle = total % this.syncSpuSize == 0 ? total / this.syncSpuSize : total / this.syncSpuSize + 1;
        if (cycle > 100) {
            reqBO.setTotal(total);
            this.run(reqBO);
        } else {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = null;
            UccCommodityPo po = new UccCommodityPo();
            po.setSupplierShopId(reqBO.getSupplierId());
            Page page = new Page();
            for (int i = 1; i < cycle + 1; ++i) {
                page.setPageNo(i);
                page.setPageSize(reqBO.getSize());
                List comds = this.uccCommodityMapper.queryCommodityList(po, page);
                if (CollectionUtils.isEmpty((Collection)comds)) continue;
                syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(comds);
                syncSceneCommodityToEsReqBO.setSyncType(Integer.valueOf(0));
                syncSceneCommodityToEsReqBO.setOperType(Integer.valueOf(0));
                syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierId());
                rspBO = this.syncSceneCommodityToEsBusiService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                if ("0000".equals(rspBO.getRespCode())) continue;
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private SyncSceneCommodityToEsRspBO run(SyncAllCommodityToEsReqBO reqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        if (this.fixedThreadPool == null) {
            ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
            this.fixedThreadPool = new ThreadPoolExecutor(10, 50, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        }
        if (log.isDebugEnabled()) {
            log.debug(reqBO.getSupplierId() + "\u5546\u54c1\u540c\u6b65es\u5f00\u59cb");
        }
        long start = System.currentTimeMillis();
        int cycle = reqBO.getTotal() % this.syncSpuSize == 0 ? reqBO.getTotal() / this.syncSpuSize : reqBO.getTotal() / this.syncSpuSize + 1;
        for (int i = 0; i < cycle; ++i) {
            SynEsInfoThreadBo synEsInfoThreadBo = new SynEsInfoThreadBo();
            synEsInfoThreadBo.setSupplierId(reqBO.getSupplierId());
            synEsInfoThreadBo.setStar(i * this.syncSpuSize);
            synEsInfoThreadBo.setEnd((i + 1) * this.syncSpuSize);
            synEsInfoThreadBo.setTotal(this.syncSpuSize);
            synEsInfoThreadBo.setSize(reqBO.getSize());
            synEsInfoThreadBo.setSize(this.syncSpuSize);
            if (synEsInfoThreadBo.getStar() > reqBO.getTotal()) continue;
            SynEsInfoThread synInfoThread = new SynEsInfoThread();
            synInfoThread.setUccCommodityMapper(this.uccCommodityMapper);
            synInfoThread.setSyncSceneCommodityToEsBusiService(this.syncSceneCommodityToEsBusiService);
            synInfoThread.setSynEsInfoThreadBo(synEsInfoThreadBo);
            this.fixedThreadPool.submit(synInfoThread);
        }
        this.fixedThreadPool.shutdown();
        while (true) {
            if (this.fixedThreadPool.isTerminated()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f");
        long end = System.currentTimeMillis();
        long l = (end - start) / 1000L;
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f\u8017\u65f6\uff1a " + l);
        }
        return rspBO;
    }
}

