/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.atom.api.UccSyncMaterialCallBackAtomService;
import com.tydic.commodity.common.atom.bo.UccSyncMaterialCallBackAtomBO;
import com.tydic.commodity.common.atom.bo.UccSyncMaterialCallBackAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccSyncMaterialCallBackAtomRspBO;
import com.tydic.commodity.utils.SSLClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccSyncMaterialCallBackAtomServiceImpl
implements UccSyncMaterialCallBackAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncMaterialCallBackAtomServiceImpl.class);
    @Value(value="${syncMaterialCallBack.userName:JN_PO_JNEG}")
    private String poUserName;
    @Value(value="${syncMaterialCallBack.passWord:Init1234}")
    private String poPassWord;
    @Value(value="${syncMaterialCallBack.backUrl:${ESB_ACCESS_IP}/OSN/api/syncMaterialCallBack/v1}")
    private String backUrl;

    @Override
    public UccSyncMaterialCallBackAtomRspBO syncMaterialCallBack(UccSyncMaterialCallBackAtomReqBO reqBO) {
        JSONObject jsonObject;
        Object success;
        UccSyncMaterialCallBackAtomRspBO rspBO = new UccSyncMaterialCallBackAtomRspBO();
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter YMD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String YMDDate = currentDate.format(YMD);
        LocalTime YMDHMSDate = LocalTime.now();
        JSONObject messageHeader = new JSONObject();
        messageHeader.put("Sender", (Object)reqBO.getReceiver());
        messageHeader.put("Receiver", (Object)reqBO.getSender());
        messageHeader.put("SendDate", (Object)YMDDate);
        messageHeader.put("SendTime", (Object)YMDHMSDate);
        JSONObject Header = new JSONObject();
        Header.put("PUUID", (Object)reqBO.getPUUID());
        JSONArray rows = new JSONArray();
        for (UccSyncMaterialCallBackAtomBO each : reqBO.getRows()) {
            JSONObject temp = new JSONObject();
            temp.put("CODE", (Object)each.getCODE());
            temp.put("UUID", (Object)each.getUUID());
            temp.put("SYNSTATUS", (Object)each.getSYNSTATUS());
            temp.put("SYNRESULT", (Object)each.getSYNRESULT());
            rows.add((Object)temp);
        }
        Header.put("Rows", (Object)rows);
        JSONObject Tables = new JSONObject();
        Tables.put("Header", (Object)Header);
        List successList = reqBO.getRows().stream().filter(e -> "0".equals(e.getSYNSTATUS())).collect(Collectors.toList());
        JSONObject Returns = new JSONObject();
        Returns.put("RESULT", (Object)(reqBO.getRows().size() == successList.size() ? "S" : "E"));
        Returns.put("Tables", (Object)Tables);
        JSONObject reqJSON = new JSONObject();
        reqJSON.put("Returns", (Object)Returns);
        reqJSON.put("MessageHeader", (Object)messageHeader);
        String auth = this.poUserName + ":" + this.poPassWord;
        String encodeAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeader = "Basic " + encodeAuth;
        log.info("\u7269\u6599\u5904\u7406\u7ed3\u679c\u56de\u4f20\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqJSON));
        String rspStr = SSLClient.doPost((String)this.backUrl, (String)JSON.toJSONString((Object)reqJSON), (String)"ESB-Authorization", (String)authHeader);
        log.info("\u7269\u6599\u5904\u7406\u7ed3\u679c\u56de\u4f20\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspStr));
        if (!StringUtils.isEmpty((Object)rspStr) && rspStr.startsWith("{") && (success = (jsonObject = JSON.parseObject((String)rspStr)).get((Object)"success")) != null && "false".equals(success.toString())) {
            throw new BaseBusinessException("8888", "\u80fd\u529b\u5e73\u53f0\u62a5\u9519\uff1a" + jsonObject.get((Object)"resultMessage").toString());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

