/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccCatalogDeleteReqBO;
import com.tydic.commodity.common.ability.bo.UccCatalogDeleteRspBO;
import com.tydic.commodity.common.busi.api.UccCatalogDeleteBusiService;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccGuideCatalogMaterialRelMapper;
import com.tydic.commodity.po.UccCatalogConnectCommdTypeDealPO;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccGuideCatalogMaterialRelPO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCatalogDeleteBusiServiceImpl
implements UccCatalogDeleteBusiService {
    @Autowired
    private UccCatalogDealMapper mapper;
    @Autowired
    private UccGuideCatalogMaterialRelMapper uccGuideCatalogMaterialRelMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    UccCatalogDeleteRspBO rspBO = new UccCatalogDeleteRspBO();

    @Override
    public UccCatalogDeleteRspBO deleteCatalog(UccCatalogDeleteReqBO reqBO) {
        int result;
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccCatalogDealPO tempPO = new UccCatalogDealPO();
        tempPO.setGuideCatalogId(reqBO.getGuideCatalogId());
        UccCatalogDealPO guideCatalogInfo = this.mapper.selectCatalogById(tempPO);
        if (guideCatalogInfo == null) {
            throw new BaseBusinessException("8888", "\u7c7b\u76eeID\u4e0d\u5b58\u5728");
        }
        Integer count = this.mapper.selectCountById(reqBO.getGuideCatalogId());
        if (0 != count) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u6b64\u7c7b\u76ee\u5b58\u5728\u5b50\u7c7b\u76ee\uff0c\u65e0\u6cd5\u5220\u9664");
            return this.rspBO;
        }
        if (guideCatalogInfo.getCatalogLevel() == 2) {
            UccGuideCatalogMaterialRelPO qryPO = new UccGuideCatalogMaterialRelPO();
            qryPO.setCatalogId(guideCatalogInfo.getGuideCatalogId());
            List list = this.uccGuideCatalogMaterialRelMapper.getList(qryPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                throw new BaseBusinessException("8888", "\u8be5\u4e8c\u7ea7\u524d\u53f0\u7c7b\u76ee\u5b58\u5728\u7269\u6599\u5173\u7cfb,\u4e0d\u80fd\u5220\u9664");
            }
        }
        if (guideCatalogInfo.getCatalogLevel() == 3) {
            List commodityTypeIds = this.uccCatRCommdTypeMapper.qryCommodityTypeIds(reqBO.getGuideCatalogId());
            if (CollectionUtils.isEmpty((Collection)commodityTypeIds)) {
                throw new BaseBusinessException("8888", "\u5185\u7f6e\u914d\u7f6e\u6570\u636e\u51fa\u9519\uff0c\u5546\u54c1\u7c7b\u578b\u5173\u8054\u4e0d\u5b58\u5728");
            }
            HashSet commodityTypeIdSet = new HashSet(commodityTypeIds);
            if (commodityTypeIdSet.size() != 1) {
                throw new BaseBusinessException("8888", "\u5185\u7f6e\u914d\u7f6e\u6570\u636e\u51fa\u9519\uff0c\u524d\u53f0\u7c7b\u76ee\u548c\u5546\u54c1\u7c7b\u578b\u4e0d\u662f1\u5bf91\u5173\u7cfb");
            }
            List commodityTypePos = this.uccCommodityTypeMapper.getCatalogByCommodityType(commodityTypeIds);
            if (!CollectionUtils.isEmpty((Collection)commodityTypePos)) {
                if (((UccCommodityTypePo)commodityTypePos.get(0)).getCatalogId() != null) {
                    throw new BaseBusinessException("8888", "\u6b64\u7c7b\u76ee\u5df2\u5173\u8054\u7269\u6599\u7c7b\u578b\uff0c\u65e0\u6cd5\u5220\u9664");
                }
            } else {
                throw new BaseBusinessException("8888", "\u5185\u7f6e\u914d\u7f6e\u6570\u636e\u51fa\u9519\uff0c\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            UccCommodityTypePo deletePO = new UccCommodityTypePo();
            deletePO.setCommodityTypeId((Long)commodityTypeIds.get(0));
            this.uccCommodityTypeMapper.deleteCommdType(deletePO);
            UccCatalogConnectCommdTypeDealPO relDeletePO = new UccCatalogConnectCommdTypeDealPO();
            relDeletePO.setGuideCatalogId(reqBO.getGuideCatalogId());
            this.uccCatRCommdTypeMapper.deleteData(relDeletePO);
        }
        UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
        uccCatalogDealPO.setGuideCatalogId(reqBO.getGuideCatalogId());
        try {
            result = this.mapper.deleteCatalog(uccCatalogDealPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u5220\u9664\u5bfc\u8d2d\u7c7b\u76ee\u5f02\u5e38");
        }
        if (result <= 0) {
            throw new BusinessException("8888", "\u5220\u9664\u7c7b\u76ee\u5931\u8d25");
        }
        this.rspBO.setRespCode("0000");
        this.rspBO.setRespDesc("\u5220\u9664\u7c7b\u76ee\u6210\u529f");
        return this.rspBO;
    }

    public boolean judge(UccCatalogDeleteReqBO reqBO) {
        if (reqBO.getGuideCatalogId() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }
}

