/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.enumType.GuideCatalogEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccReadRedisCatalogAbilityService;
import com.tydic.commodity.common.ability.bo.UccCatalogUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccCatalogUpdateRspBO;
import com.tydic.commodity.common.ability.bo.UccReadRdisCategoryQryReqBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccCatalogUpdateBusiService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccCatalogUpdateBusiServiceImpl
implements UccCatalogUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCatalogUpdateBusiServiceImpl.class);
    @Autowired
    private UccCatalogDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogUpdateBusiServiceImpl.class);
    UccCatalogUpdateRspBO rspBO = new UccCatalogUpdateRspBO();
    @Autowired
    private UccReadRedisCatalogAbilityService uccReadRedisCatalogAbilityService;

    @Override
    public UccCatalogUpdateRspBO updateCatalog(UccCatalogUpdateReqBO reqBO) {
        ArrayList<Long> catalogIds = new ArrayList<Long>();
        if (!this.judge(reqBO, catalogIds)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        if (reqBO.getMobileFlag() != null) {
            this.mobileViewOrder(reqBO);
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u4fee\u6539\u7c7b\u76ee\u6392\u5e8f\u6210\u529f");
            return this.rspBO;
        }
        if (reqBO.getViewOrder() != null) {
            this.modifyOrder(reqBO);
        }
        this.rspBO = new UccCatalogUpdateRspBO();
        UccCatalogDealPO catalogDealPO = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)catalogDealPO);
        int result = 0;
        try {
            List channelByCatalogId;
            catalogDealPO.setUpdateOperId(reqBO.getName());
            result = this.mapper.updateCatalog(catalogDealPO);
            if (!CollectionUtils.isEmpty(catalogIds) && !CollectionUtils.isEmpty((Collection)(channelByCatalogId = this.mapper.queryChannelByCatalogId(catalogIds)))) {
                for (Long channelId : channelByCatalogId) {
                    UccReadRdisCategoryQryReqBO uccReadRdisCategoryQryReqBO = new UccReadRdisCategoryQryReqBO();
                    uccReadRdisCategoryQryReqBO.setRedisKey(channelId.toString());
                    this.uccReadRedisCatalogAbilityService.clearCatagoryRedis(uccReadRdisCategoryQryReqBO);
                    this.uccReadRedisCatalogAbilityService.readRedisCatalog(uccReadRdisCategoryQryReqBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u524d\u53f0\u7c7b\u76ee\u62a5\u9519\uff1a", (Throwable)e);
            throw new BusinessException("8888", "\u4fee\u6539\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (result > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u4fee\u6539\u7c7b\u76ee\u6210\u529f");
            if (reqBO.getUpperCatalogId() != null && reqBO.getUpperCatalogId() != 0L) {
                UccCatalogDealPO qryPO = new UccCatalogDealPO();
                qryPO.setGuideCatalogId(reqBO.getUpperCatalogId());
                UccCatalogDealPO upperPO = this.mapper.selectCatalogById(qryPO);
                if (upperPO == null) {
                    throw new BusinessException("8888", "\u7236\u7c7b\u76ee\u4e0d\u5b58\u5728");
                }
                UccCatalogDealPO qryPO2 = new UccCatalogDealPO();
                qryPO2.setGuideCatalogId(reqBO.getGuideCatalogId());
                UccCatalogDealPO nowPO = this.mapper.selectCatalogById(qryPO2);
                if (!upperPO.getZoneType().equals(nowPO.getZoneType())) {
                    UccCatalogDealPO updatePO = new UccCatalogDealPO();
                    updatePO.setGuideCatalogId(reqBO.getGuideCatalogId());
                    updatePO.setZoneType(upperPO.getZoneType());
                    this.mapper.updateCatalog(updatePO);
                    UccCatalogDealPO updatePO2 = new UccCatalogDealPO();
                    updatePO2.setUpperCatalogId(reqBO.getGuideCatalogId());
                    updatePO2.setZoneType(upperPO.getZoneType());
                    this.mapper.updateCatalogByUpperCatalogId(updatePO2);
                }
            }
        } else {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u4fee\u6539\u7c7b\u76ee\u5931\u8d25");
        }
        return this.rspBO;
    }

    private void mobileViewOrder(UccCatalogUpdateReqBO reqBO) {
        UccCatalogDealPO queryPO = new UccCatalogDealPO();
        queryPO.setUpperCatalogId(reqBO.getUpperCatalogId());
        queryPO.setOrderStr("VIEW_ORDER");
        List dealPOS = this.mapper.queryCatalog(queryPO);
        if (CollectionUtils.isNotEmpty((Collection)dealPOS)) {
            for (int i = 0; i < dealPOS.size(); ++i) {
                if (!reqBO.getGuideCatalogId().equals(((UccCatalogDealPO)dealPOS.get(i)).getGuideCatalogId())) continue;
                if (reqBO.getMobileFlag() == 1) {
                    if (i == 0) break;
                    UccCatalogDealPO mobilePO = new UccCatalogDealPO();
                    mobilePO.setUpperCatalogId(reqBO.getUpperCatalogId());
                    mobilePO.setGuideCatalogId(reqBO.getGuideCatalogId());
                    this.mapper.modifyOrderByViewOrder(null, ((UccCatalogDealPO)dealPOS.get(i - 1)).getViewOrder(), mobilePO);
                    mobilePO.setGuideCatalogId(((UccCatalogDealPO)dealPOS.get(i - 1)).getGuideCatalogId());
                    this.mapper.modifyOrderByViewOrder(null, ((UccCatalogDealPO)dealPOS.get(i)).getViewOrder(), mobilePO);
                    break;
                }
                if (reqBO.getMobileFlag() == 2) {
                    if (i == dealPOS.size() - 1) break;
                    UccCatalogDealPO mobilePO = new UccCatalogDealPO();
                    mobilePO.setUpperCatalogId(reqBO.getUpperCatalogId());
                    mobilePO.setGuideCatalogId(reqBO.getGuideCatalogId());
                    this.mapper.modifyOrderByViewOrder(null, ((UccCatalogDealPO)dealPOS.get(i + 1)).getViewOrder(), mobilePO);
                    mobilePO.setGuideCatalogId(((UccCatalogDealPO)dealPOS.get(i + 1)).getGuideCatalogId());
                    this.mapper.modifyOrderByViewOrder(null, ((UccCatalogDealPO)dealPOS.get(i)).getViewOrder(), mobilePO);
                    break;
                }
                throw new BusinessException("8888", "\u4fee\u6539\u6392\u5e8f\u5165\u53c2\u4e0d\u7b26\u5408\u6807\u51c6");
            }
        }
    }

    public boolean judge(UccCatalogUpdateReqBO reqBO, List<Long> catalogIds) {
        List uccCatalogDealPOS;
        Map<String, String> map = null;
        if (reqBO.getGuideCatalogId() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
            return false;
        }
        UccCatalogDealPO po = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        UccCatalogDealPO catalogDealPO = this.mapper.selectCatalogById(po);
        if (catalogDealPO == null) {
            this.rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
            return false;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCatalogName()) && !catalogDealPO.getCatalogName().equals(reqBO.getCatalogName()) && (uccCatalogDealPOS = this.mapper.queryByCatalogName2(reqBO.getCatalogName(), reqBO.getPurchaseFlag())).size() > 0) {
            this.rspBO.setRespDesc("\u60a8\u6240\u8f93\u5165\u7684\u5546\u54c1\u7c7b\u76ee\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
            return false;
        }
        if (reqBO.getCatalogStatus() != null) {
            map = this.uccDictionaryAtomService.queryBypCodeBackMap(GuideCatalogEnum.GUIDE_CATALOG_STATUS.toString());
            if (!map.containsKey(String.valueOf(reqBO.getCatalogStatus()))) {
                this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u72b6\u6001");
                return false;
            }
            if (reqBO.getCatalogStatus() == 0) {
                List upperIds = Stream.of(reqBO.getGuideCatalogId()).collect(Collectors.toList());
                catalogIds.addAll(upperIds);
                List uccCatalogDealPOS2 = this.mapper.queryCatalogByUpperId(upperIds);
                if (!CollectionUtils.isEmpty((Collection)uccCatalogDealPOS2)) {
                    List guideCatalogIdList1 = uccCatalogDealPOS2.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
                    catalogIds.addAll(guideCatalogIdList1);
                    List uccCatalogDealPOS1 = this.mapper.queryCatalogByUpperId(guideCatalogIdList1);
                    if (!CollectionUtils.isEmpty((Collection)uccCatalogDealPOS1)) {
                        List guideCatalogIdList2 = uccCatalogDealPOS1.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
                        catalogIds.addAll(guideCatalogIdList2);
                        guideCatalogIdList1.addAll(guideCatalogIdList2);
                        this.mapper.updateCatalogByUpperId(guideCatalogIdList1);
                    } else {
                        this.mapper.updateCatalogByUpperId(guideCatalogIdList1);
                    }
                }
            } else if (reqBO.getCatalogStatus() == 1) {
                catalogIds.add(reqBO.getGuideCatalogId());
                ArrayList<Long> catalogUpdateIds = new ArrayList<Long>();
                if (catalogDealPO.getUpperCatalogId() != 0L) {
                    catalogIds.add(catalogDealPO.getUpperCatalogId());
                    catalogUpdateIds.add(catalogDealPO.getUpperCatalogId());
                    UccCatalogDealPO po1 = new UccCatalogDealPO();
                    po1.setGuideCatalogId(catalogDealPO.getUpperCatalogId());
                    UccCatalogDealPO catalogDealPo1 = this.mapper.selectCatalogById(po1);
                    if (catalogDealPo1.getUpperCatalogId() != 0L) {
                        catalogIds.add(catalogDealPo1.getUpperCatalogId());
                        catalogUpdateIds.add(catalogDealPo1.getUpperCatalogId());
                    }
                    this.mapper.updateCatalogByCatalogId(catalogUpdateIds);
                }
            }
        }
        return true;
    }

    public void modifyOrder(UccCatalogUpdateReqBO reqBO) {
        try {
            UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
            uccCatalogDealPO.setGuideCatalogId(reqBO.getGuideCatalogId());
            uccCatalogDealPO = this.mapper.selectCatalogById(uccCatalogDealPO);
            if (uccCatalogDealPO != null) {
                Integer viewOrder = uccCatalogDealPO.getViewOrder();
                if (reqBO.getOrderConfSolution() != null) {
                    uccCatalogDealPO = new UccCatalogDealPO();
                    uccCatalogDealPO.setUpperCatalogId(reqBO.getUpperCatalogId());
                    uccCatalogDealPO.setViewOrder(reqBO.getViewOrder());
                    uccCatalogDealPO.setChannelId(reqBO.getChannelId());
                    if (reqBO.getOrderConfSolution() == 0) {
                        this.mapper.modifyOrder(uccCatalogDealPO);
                    } else if (reqBO.getOrderConfSolution() == 1) {
                        if (reqBO.getViewOrder() > 1) {
                            this.mapper.modifyOrderByViewOrder(reqBO.getViewOrder(), viewOrder, uccCatalogDealPO);
                        }
                    } else if (reqBO.getOrderConfSolution() == 2) {
                        UccCatalogDealPO updateViewOrderPo = new UccCatalogDealPO();
                        updateViewOrderPo.setUpperCatalogId(reqBO.getUpperCatalogId());
                        updateViewOrderPo.setChannelId(reqBO.getChannelId());
                        updateViewOrderPo.setViewOrder(reqBO.getViewOrder());
                        this.mapper.updateViewOrder(updateViewOrderPo);
                        reqBO.setViewOrder(Integer.valueOf(reqBO.getViewOrder() + 1));
                    } else {
                        reqBO.setViewOrder(Integer.valueOf(0));
                    }
                } else {
                    UccCatalogDealPO uccCatalogDealPO1 = new UccCatalogDealPO();
                    uccCatalogDealPO1.setCatalogLevel(uccCatalogDealPO.getCatalogLevel());
                    uccCatalogDealPO1.setChannelId(uccCatalogDealPO.getChannelId());
                    uccCatalogDealPO1.setOrderStr("VIEW_ORDER DESC");
                    List uccCatalogDealPOS = this.mapper.queryCatalog(uccCatalogDealPO1);
                    if (!CollectionUtils.isEmpty((Collection)uccCatalogDealPOS)) {
                        if (((UccCatalogDealPO)uccCatalogDealPOS.get(0)).getViewOrder() != null) {
                            reqBO.setViewOrder(Integer.valueOf(((UccCatalogDealPO)uccCatalogDealPOS.get(0)).getViewOrder() + 1));
                        } else {
                            reqBO.setViewOrder(Integer.valueOf(0));
                        }
                    } else {
                        reqBO.setViewOrder(Integer.valueOf(0));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }
}

