/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.common.ability.bo.UccRetryOutSystemAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccRetryOutSystemAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSynMaterialByOutSystemAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSynMaterialByOutSystemAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccSyncMaterialCallBackAtomService;
import com.tydic.commodity.common.atom.bo.UccSyncMaterialCallBackAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccSyncMaterialCallBackAtomRspBO;
import com.tydic.commodity.common.busi.api.UccRetryOutSystemBusiService;
import com.tydic.commodity.common.busi.api.UccSynMaterialByOutSystemBusiService;
import com.tydic.commodity.dao.UccExtSysFailLogMapper;
import com.tydic.commodity.po.UccExtSysFailLogPO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccRetryOutSystemBusiServiceImpl
implements UccRetryOutSystemBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccRetryOutSystemBusiServiceImpl.class);
    @Autowired
    private UccExtSysFailLogMapper uccExtSysFailLogMapper;
    @Autowired
    private UccSynMaterialByOutSystemBusiService uccSynMaterialByOutSystemBusiService;
    @Autowired
    private UccSyncMaterialCallBackAtomService uccSyncMaterialCallBackAtomService;

    @Override
    public UccRetryOutSystemAbilityRspBO retryOutSystem(UccRetryOutSystemAbilityReqBO reqBO) {
        if (reqBO.getRetryId() == null) {
            throw new BaseBusinessException("8888", "\u5165\u53c2retryId\u4e3a\u7a7a");
        }
        UccExtSysFailLogPO qryPO = new UccExtSysFailLogPO();
        qryPO.setRetryId(reqBO.getRetryId());
        UccExtSysFailLogPO modelBy = this.uccExtSysFailLogMapper.getModelBy(qryPO);
        if (modelBy == null) {
            throw new BaseBusinessException("8888", "\u5165\u53c2retryId\u4e0d\u5b58\u5728");
        }
        if (modelBy.getBusiType() == null) {
            throw new BaseBusinessException("8888", "\u6570\u636e\u5e93\u5931\u8d25\u8bb0\u5f55\u8868busiType\u4e3a\u7a7a");
        }
        boolean succeed = true;
        if (modelBy.getBusiType() == 1) {
            log.info("\u7269\u6599\u540c\u6b65busi\u5c42\u62a5\u9519\u91cd\u8bd5\u5f00\u59cb\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
            UccSynMaterialByOutSystemAbilityReqBO abilityReqBO = (UccSynMaterialByOutSystemAbilityReqBO)JSON.parseObject((String)modelBy.getReqJson(), UccSynMaterialByOutSystemAbilityReqBO.class);
            try {
                UccSynMaterialByOutSystemAbilityRspBO abilityRspBO = this.uccSynMaterialByOutSystemBusiService.synMaterialByOutSystem(abilityReqBO);
                if (!"0000".equals(abilityRspBO.getRespCode())) {
                    this.updateErrorLog(reqBO.getRetryId(), JSON.toJSONString((Object)abilityReqBO), JSON.toJSONString((Object)abilityRspBO), abilityRspBO.getRespDesc(), null);
                    succeed = false;
                }
            }
            catch (Exception e) {
                this.updateErrorLog(reqBO.getRetryId(), JSON.toJSONString((Object)abilityReqBO), null, null, e);
                succeed = false;
            }
        } else if (modelBy.getBusiType() == 2) {
            log.info("\u540c\u6b65\u4e3b\u6570\u636e\u7269\u6599\u56de\u8c03\u539f\u5b50\u670d\u52a1\u91cd\u8bd5\u5f00\u59cb\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
            UccSyncMaterialCallBackAtomReqBO atomReqBO = (UccSyncMaterialCallBackAtomReqBO)JSON.parseObject((String)modelBy.getReqJson(), UccSyncMaterialCallBackAtomReqBO.class);
            try {
                UccSyncMaterialCallBackAtomRspBO atomRspBO = this.uccSyncMaterialCallBackAtomService.syncMaterialCallBack(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    this.updateErrorLog(reqBO.getRetryId(), JSON.toJSONString((Object)atomReqBO), JSON.toJSONString((Object)((Object)atomRspBO)), atomRspBO.getRespDesc(), null);
                    succeed = false;
                }
            }
            catch (Exception e) {
                this.updateErrorLog(reqBO.getRetryId(), JSON.toJSONString((Object)atomReqBO), null, null, e);
                succeed = false;
            }
        }
        if (succeed) {
            UccExtSysFailLogPO deletePO = new UccExtSysFailLogPO();
            deletePO.setRetryId(reqBO.getRetryId());
            this.uccExtSysFailLogMapper.deleteBy(deletePO);
        }
        UccRetryOutSystemAbilityRspBO rspBO = new UccRetryOutSystemAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateErrorLog(Long retryId, String reqJson, String rspJson, String failDesc, Exception e) {
        UccExtSysFailLogPO updateLogPO = new UccExtSysFailLogPO();
        updateLogPO.setRetryId(retryId);
        updateLogPO.setReqJson(reqJson);
        updateLogPO.setRspJson(rspJson);
        if (e == null) {
            updateLogPO.setFailDesc(failDesc);
        } else {
            updateLogPO.setFailDesc(Arrays.toString(e.getStackTrace()));
        }
        this.uccExtSysFailLogMapper.updateById(updateLogPO);
    }
}

