/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.UccSynMaterialByOutSystemAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSynMaterialByOutSystemAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSynMaterialByOutSystemBO;
import com.tydic.commodity.common.atom.api.UccSyncMaterialCallBackAtomService;
import com.tydic.commodity.common.atom.bo.UccSyncMaterialCallBackAtomBO;
import com.tydic.commodity.common.atom.bo.UccSyncMaterialCallBackAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccSyncMaterialCallBackAtomRspBO;
import com.tydic.commodity.common.busi.api.UccSynMaterialByOutSystemBusiService;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccExtSysFailLogMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccExtSysFailLogPO;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSynMaterialByOutSystemBusiServiceImpl
implements UccSynMaterialByOutSystemBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSynMaterialByOutSystemBusiServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccSyncMaterialCallBackAtomService uccSyncMaterialCallBackAtomService;
    private final Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccExtSysFailLogMapper uccExtSysFailLogMapper;

    @Override
    public UccSynMaterialByOutSystemAbilityRspBO synMaterialByOutSystem(UccSynMaterialByOutSystemAbilityReqBO reqBO) {
        UccSynMaterialByOutSystemAbilityRspBO rspBO = new UccSynMaterialByOutSystemAbilityRspBO();
        ArrayList<UccSyncMaterialCallBackAtomBO> succeedList = new ArrayList<UccSyncMaterialCallBackAtomBO>();
        ArrayList<UccSyncMaterialCallBackAtomBO> failedList = new ArrayList<UccSyncMaterialCallBackAtomBO>();
        ArrayList<UccEMdmMaterialPO> materialPOList = new ArrayList<UccEMdmMaterialPO>();
        ArrayList<UccEMdmCatalogPO> catalogPOList = new ArrayList<UccEMdmCatalogPO>();
        this.judge(reqBO, materialPOList, catalogPOList, succeedList, failedList);
        this.addMaterialAndCatalog(materialPOList, catalogPOList, succeedList, failedList);
        this.syncMaterialCallBack(reqBO, succeedList, failedList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void judge(UccSynMaterialByOutSystemAbilityReqBO reqBO, List<UccEMdmMaterialPO> materialPOList, List<UccEMdmCatalogPO> catalogPOList, List<UccSyncMaterialCallBackAtomBO> succeedList, List<UccSyncMaterialCallBackAtomBO> failedList) {
        for (UccSynMaterialByOutSystemBO each : reqBO.getRows()) {
            if (ObjectUtils.isEmpty((Object)each.getCODE()) || ObjectUtils.isEmpty((Object)each.getUUID()) || ObjectUtils.isEmpty((Object)each.getDESC10()) || ObjectUtils.isEmpty((Object)each.getDESC7()) || ObjectUtils.isEmpty((Object)each.getDESC1()) || ObjectUtils.isEmpty((Object)each.getDESC36()) || ObjectUtils.isEmpty((Object)each.getDESC6())) {
                UccSyncMaterialCallBackAtomBO failed = new UccSyncMaterialCallBackAtomBO();
                failed.setCODE(each.getCODE());
                failed.setUUID(each.getUUID());
                failed.setSYNSTATUS("1");
                failed.setSYNRESULT("\u5fc5\u8981\u6570\u636e\u672a\u4f20");
                failedList.add(failed);
                continue;
            }
            UccEMdmMaterialPO materialPO = new UccEMdmMaterialPO();
            UccEMdmCatalogPO catalogPO = new UccEMdmCatalogPO();
            materialPO.setMaterialCode(each.getCODE());
            materialPO.setMaterialTypeName(each.getDESC1());
            catalogPO.setSecondCatalogName(each.getDESC10());
            materialPO.setMaterialName(each.getDESC11());
            materialPO.setSpec(each.getDESC12());
            materialPO.setModel(each.getDESC13());
            materialPO.setBrandModel(each.getDESC14());
            materialPO.setFigure(each.getDESC15());
            materialPO.setMainModel(each.getDESC16());
            materialPO.setGbModel(each.getDESC17());
            materialPO.setTexture(each.getDESC18());
            materialPO.setManufacturer(each.getDESC19());
            materialPO.setSapCode(each.getDESC23());
            materialPO.setTaxCatalogCode(each.getDESC24());
            materialPO.setBrandName(each.getDESC25());
            materialPO.setJcmenuCode(each.getDESC27());
            materialPO.setJcmenuCodeDesc(each.getDESC28());
            materialPO.setShortDesc(each.getDESC3());
            materialPO.setCatalogName(each.getDESC36());
            catalogPO.setCatalogName(each.getDESC36());
            materialPO.setTaxCatalogName(each.getDESC38());
            materialPO.setTaxCatalogDesc(each.getDESC39());
            materialPO.setLongDesc(each.getDESC4());
            materialPO.setMeasureCode(each.getDESC5());
            materialPO.setCatalogCode(each.getDESC6());
            catalogPO.setCatalogCode(each.getDESC6());
            materialPO.setZyCatalogCode(each.getDESC7());
            catalogPO.setFirstCatalogName(each.getDESC7());
            materialPO.setDlCatalogName(each.getDESC8());
            materialPO.setDlCatalogCode(each.getDESC9());
            materialPO.setFreezeCode(each.getDESC41());
            if (!StringUtils.isEmpty((Object)each.getDESC41())) {
                if (Arrays.asList("6", "7").contains(each.getDESC41())) {
                    materialPO.setFreezeFlag(Integer.valueOf(1));
                } else {
                    materialPO.setFreezeFlag(Integer.valueOf(0));
                }
            }
            materialPO.setFreezeDesc(each.getDESC42());
            materialPO.setIndustrySector(each.getDESC2());
            materialPO.setInterfaceUnitCode(each.getDESC22());
            materialPO.setInventoryFlag(each.getDESC26());
            materialPO.setJcmenuPreferredSequence(each.getDESC29());
            materialPO.setJcmenuSubcontractingSequence(each.getDESC30());
            materialPO.setColumn1(each.getDESC31());
            materialPO.setColumn2(each.getDESC32());
            materialPO.setColumn3(each.getDESC33());
            materialPO.setAdditionalName(each.getDESC34());
            materialPO.setComboName(each.getDESC35());
            materialPO.setMeasure(each.getDESC37());
            materialPO.setRangeDesc(each.getDESC40());
            materialPO.setRemark(each.getDESC43());
            materialPO.setMainEquipmentFlag(each.getDESC44());
            materialPO.setMainEquipmentCode(each.getDESC45());
            materialPO.setColumn4(each.getDESC46());
            materialPO.setColumn5(each.getDESC47());
            materialPO.setColumn6(each.getDESC48());
            materialPO.setUuid(each.getUUID());
            materialPO.setSource(Integer.valueOf(3));
            UccSyncMaterialCallBackAtomBO succeed = new UccSyncMaterialCallBackAtomBO();
            succeed.setCODE(each.getCODE());
            succeed.setUUID(each.getUUID());
            succeed.setSYNSTATUS("0");
            succeed.setSYNRESULT("\u6210\u529f");
            succeedList.add(succeed);
            materialPOList.add(materialPO);
            catalogPOList.add(catalogPO);
        }
    }

    private void addMaterialAndCatalog(List<UccEMdmMaterialPO> materialPOList, List<UccEMdmCatalogPO> catalogPOList, List<UccSyncMaterialCallBackAtomBO> succeedList, List<UccSyncMaterialCallBackAtomBO> failedList) {
        HashMap<String, UccEMdmCatalogPO> catalogCodeAndIdMap = new HashMap<String, UccEMdmCatalogPO>();
        Map catalogCodeMap = catalogPOList.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogCode, Function.identity(), (e1, e2) -> e2));
        UccEMdmCatalogPO qryCatalogPO = new UccEMdmCatalogPO();
        qryCatalogPO.setCatalogCodes(new ArrayList<String>(catalogCodeMap.keySet()));
        List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(qryCatalogPO);
        if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
            uccEMdmCatalogPOS.forEach(e -> catalogCodeAndIdMap.put(e.getCatalogCode(), (UccEMdmCatalogPO)e));
            List catalogCodes = uccEMdmCatalogPOS.stream().map(UccEMdmCatalogPO::getCatalogCode).collect(Collectors.toList());
            List updateCatalogPOList = catalogPOList.stream().filter(e -> catalogCodes.contains(e.getCatalogCode())).collect(Collectors.toList());
            this.uccEMdmCatalogMapper.batchUpdateCatalog(updateCatalogPOList);
            catalogPOList.removeIf(e -> catalogCodes.contains(e.getCatalogCode()));
        }
        if (!CollectionUtils.isEmpty(catalogPOList)) {
            for (UccEMdmCatalogPO each : catalogPOList) {
                each.setCatalogId(Long.valueOf(this.sequence.nextId()));
                each.setFreezeFlag(Integer.valueOf(0));
                each.setIsDelete(Integer.valueOf(0));
                each.setParentCatalogId(Long.valueOf(0L));
                each.setCatalogLevel(Integer.valueOf(1));
                each.setLastLevel(Integer.valueOf(1));
                catalogCodeAndIdMap.put(each.getCatalogCode(), each);
            }
            this.uccEMdmCatalogMapper.insertBatch(catalogPOList);
        }
        Map materialCodeMap = materialPOList.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialCode, Function.identity(), (e1, e2) -> e2));
        UccEMdmMaterialPO qryMaterialPO = new UccEMdmMaterialPO();
        qryMaterialPO.setMaterialCodes(new ArrayList<String>(materialCodeMap.keySet()));
        List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.selectMaterial(qryMaterialPO);
        if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialPOS)) {
            List materialCodes = uccEMdmMaterialPOS.stream().map(UccEMdmMaterialPO::getMaterialCode).collect(Collectors.toList());
            List<UccEMdmMaterialPO> updateMaterialPOList = materialPOList.stream().filter(e -> materialCodes.contains(e.getMaterialCode())).collect(Collectors.toList());
            updateMaterialPOList.forEach(e -> {
                e.setZyCatalogCode(null);
                e.setCatalogCode(null);
                e.setCatalogName(null);
            });
            this.uccEMdmMaterialMapper.batchUpdateMaterial(updateMaterialPOList);
            materialPOList.removeIf(e -> materialCodes.contains(e.getMaterialCode()));
        }
        if (!CollectionUtils.isEmpty(materialPOList)) {
            materialPOList.forEach(e -> {
                e.setMaterialId(Long.valueOf(this.sequence.nextId()));
                e.setCatalogId(((UccEMdmCatalogPO)catalogCodeAndIdMap.get(e.getCatalogCode())).getCatalogId());
                e.setCatalogName(((UccEMdmCatalogPO)catalogCodeAndIdMap.get(e.getCatalogCode())).getCatalogName());
            });
            this.uccEMdmMaterialMapper.batchInsert(materialPOList);
        }
    }

    private void syncMaterialCallBack(UccSynMaterialByOutSystemAbilityReqBO reqBO, List<UccSyncMaterialCallBackAtomBO> succeedList, List<UccSyncMaterialCallBackAtomBO> failedList) {
        UccSyncMaterialCallBackAtomReqBO atomReqBO = (UccSyncMaterialCallBackAtomReqBO)JUtil.js((Object)reqBO, UccSyncMaterialCallBackAtomReqBO.class);
        ArrayList<UccSyncMaterialCallBackAtomBO> rows = new ArrayList<UccSyncMaterialCallBackAtomBO>();
        rows.addAll(succeedList);
        rows.addAll(failedList);
        atomReqBO.setRows(rows);
        UccSyncMaterialCallBackAtomRspBO atomRspBO = null;
        try {
            atomRspBO = this.uccSyncMaterialCallBackAtomService.syncMaterialCallBack(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                this.insertErrorLog(atomReqBO, atomRspBO, null);
            }
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u4e3b\u6570\u636e\u7269\u6599\u56de\u8c03\u539f\u5b50\u670d\u52a1\u62a5\u9519\uff1a", (Throwable)e);
            this.insertErrorLog(atomReqBO, atomRspBO, e);
        }
    }

    private void insertErrorLog(UccSyncMaterialCallBackAtomReqBO atomReqBO, UccSyncMaterialCallBackAtomRspBO atomRspBO, Exception e) {
        UccExtSysFailLogPO insertLogPO = new UccExtSysFailLogPO();
        insertLogPO.setRetryId(Long.valueOf(this.sequence.nextId()));
        insertLogPO.setReqJson(JSON.toJSONString((Object)atomReqBO));
        insertLogPO.setRspJson(null);
        if (e == null) {
            insertLogPO.setFailDesc(atomRspBO.getRespDesc());
        } else {
            insertLogPO.setFailDesc(Arrays.toString(e.getStackTrace()));
        }
        insertLogPO.setFailTime(new Date(System.currentTimeMillis()));
        insertLogPO.setBusiType(Integer.valueOf(2));
        insertLogPO.setProcessingFrequency(Integer.valueOf(0));
        this.uccExtSysFailLogMapper.insert(insertLogPO);
    }
}

