/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStandardRelationMapper;
import com.tydic.commodity.estore.ability.api.UccStandardSkuMaterialConfirmAbilityService;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuMaterialConfirmAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuMaterialConfirmAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccStandardSkuMaterialConfirmBusiService;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccStandardSkuMaterialConfirmAbilityService"})
public class UccStandardSkuMaterialConfirmAbilityServiceImpl
implements UccStandardSkuMaterialConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardSkuMaterialConfirmAbilityServiceImpl.class);
    @Autowired
    private UccStandardSkuMaterialConfirmBusiService uccStandardSkuMaterialConfirmBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStandardRelationMapper uccSkuStandardRelationMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealStandardSkuMaterialConfirm"})
    public UccStandardSkuMaterialConfirmAbilityRspBO dealStandardSkuMaterialConfirm(@RequestBody UccStandardSkuMaterialConfirmAbilityReqBO reqBo) {
        UccStandardSkuMaterialConfirmAbilityRspBO rspBO = new UccStandardSkuMaterialConfirmAbilityRspBO();
        List skuIdList = reqBo.getStdSkuIds();
        if (CollectionUtil.isEmpty((Collection)skuIdList)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5fc5\u586b\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        ArrayList<Long> stdSkuIds = new ArrayList<Long>();
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIdList);
        if (!CollectionUtil.isEmpty((Collection)uccSkuPos)) {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                if (uccSkuPo.getSkuType() != 1 || uccSkuPo.getRelStatus() != 2) continue;
                stdSkuIds.add(uccSkuPo.getSkuId());
            }
        } else {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5b57\u6bb5\u6709\u8bef!");
            return rspBO;
        }
        if (CollectionUtil.isEmpty(stdSkuIds)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5b57\u6bb5\u6709\u8bef!");
            return rspBO;
        }
        reqBo.setStdSkuIds(stdSkuIds);
        UccStandardSkuMaterialConfirmAbilityRspBO result = this.uccStandardSkuMaterialConfirmBusiService.dealStandardSkuMaterialConfirm(reqBo);
        if (result.getRespCode() != "0000") {
            BeanUtil.copyProperties((Object)result, (Object)rspBO, (String[])new String[0]);
            return rspBO;
        }
        List relSkuIds = this.uccSkuStandardRelationMapper.qryskuIdsByStdSkuIds(stdSkuIds);
        ArrayList allSkuList = new ArrayList();
        if (!CollectionUtil.isEmpty((Collection)relSkuIds)) {
            List skuPoList = this.uccSkuMapper.qeryBatchSkus(relSkuIds);
            allSkuList.addAll(skuPoList);
        }
        allSkuList.addAll(uccSkuPos);
        Map<Long, List<UccSkuPo>> shopIdAllSkuPoMap = allSkuList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long supplierShopId : shopIdAllSkuPoMap.keySet()) {
            List skuIds = shopIdAllSkuPoMap.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u5355\u54c1ID\u540c\u6b65ES\u6570\u636e MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25" + e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

