/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.enumType.YesNoEnum;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccAssignCodeApplyDetailMapper;
import com.tydic.commodity.dao.UccSkuStandardRelationMapper;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuUnBindAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccStandardSkuUnBindAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccStandardSkuUnBindBusiService;
import com.tydic.commodity.po.UccAssignCodeApplyDetailPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccStandardSkuUnBindBusiServiceImpl
implements UccStandardSkuUnBindBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardSkuUnBindBusiServiceImpl.class);
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuStandardRelationMapper uccSkuStandardRelationMapper;
    @Autowired
    private UccAssignCodeApplyDetailMapper uccAssignCodeApplyDetailMapper;

    @Override
    public UccStandardSkuUnBindAbilityRspBO dealStandardSkuUnBind(UccStandardSkuUnBindAbilityReqBO reqBO, List<UccSkuPo> uccSkuPoList, Map<Long, List<UccSkuPo>> shopIdUccSkuMap) {
        UccStandardSkuUnBindAbilityRspBO rspBO = new UccStandardSkuUnBindAbilityRspBO();
        List skuIdList = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        try {
            this.uccSkuStandardRelationMapper.updateBatchBySkuIdList(YesNoEnum.NO.getType(), skuIdList);
        }
        catch (Exception e2) {
            log.error("\u6807\u54c1\u89e3\u7ed1\u5931\u8d25: {}", (Object)e2.getMessage());
            throw new ZTBusinessException(e2.getMessage());
        }
        Integer unBindMaterial = reqBO.getUnBindMaterial();
        if (YesNoEnum.IS.getType().equals(unBindMaterial)) {
            for (Long skuId : reqBO.getSkuIds()) {
                UccAssignCodeApplyDetailPO uccAssignCodeApplyDetailPO = new UccAssignCodeApplyDetailPO();
                uccAssignCodeApplyDetailPO.setSkuId(skuId);
                this.uccAssignCodeApplyDetailMapper.deleteBy(uccAssignCodeApplyDetailPO);
            }
            for (Long supplierShopId : shopIdUccSkuMap.keySet()) {
                List<UccSkuPo> skuPos = shopIdUccSkuMap.get(supplierShopId);
                UccStatusChangeUpdateSpuAtomReqBO bo = new UccStatusChangeUpdateSpuAtomReqBO();
                bo.setSupplierShopId(supplierShopId);
                bo.setUserId(reqBO.getUserId());
                List skuStatusList = skuPos.stream().map(e -> {
                    UccSkuUpdateStatusBO uccSkuUpdateStatusBO = new UccSkuUpdateStatusBO();
                    uccSkuUpdateStatusBO.setSkuStatus(SkuStatusEnum.PENDING_APPROVAL_STATUS.getStatus());
                    uccSkuUpdateStatusBO.setSkuId(e.getSkuId());
                    uccSkuUpdateStatusBO.setMaterialId("");
                    uccSkuUpdateStatusBO.setMaterialName("");
                    return uccSkuUpdateStatusBO;
                }).collect(Collectors.toList());
                bo.setSkuStatusList(skuStatusList);
                UccStatusChangeUpdateSpuAtomRspBO result = this.uccSkuStatusUpdatesAtomService.delaStatusChange(bo);
                if ("0000".equals(result.getRespCode())) continue;
                rspBO.setRespCode(result.getRespCode());
                rspBO.setRespDesc(result.getRespDesc());
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

