/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.comb.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPriceModifyAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceRspBo;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.busi.api.UccAddCoefficientDealBusiService;
import com.tydic.commodity.estore.comb.api.UccAddCoefficientConfigModifyCombService;
import com.tydic.commodity.estore.comb.bo.UccAddCoefficientConfigModifyCombServiceReqBo;
import com.tydic.commodity.estore.comb.bo.UccAddCoefficientConfigModifyCombServiceRspBo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccAddCoefficientConfigModifyCombServiceImpl
implements UccAddCoefficientConfigModifyCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAddCoefficientConfigModifyCombServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;
    @Autowired
    private UccAddCoefficientDealBusiService uccAddCoefficientDealBusiService;
    @Autowired
    private UccSkuPriceModifyAtomService uccSkuPriceModifyAtomService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    public static final String ESTORE_DEFAULT_COEFFICIENT = "ESTORE_DEFAULT_COEFFICIENT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UccAddCoefficientConfigModifyCombServiceRspBo dealCoefficientConfigModify(UccAddCoefficientConfigModifyCombServiceReqBo reqBo) {
        UccParamsConfigDetailPO paramsConfigDetailPO = this.packagingParamsConfigDetail();
        if (null != paramsConfigDetailPO && !StringUtils.isBlank((CharSequence)paramsConfigDetailPO.getRule()) && Convert.toInt((Object)paramsConfigDetailPO.getRule()) >= 0 && UccConstants.UccAddCoefficientDealState.DEALING.equals(paramsConfigDetailPO.getDealStatus())) {
            try {
                List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getNoAddCoefficientList();
                if (CollectionUtils.isNotEmpty((Collection)uccEMdmCatalogPOS)) {
                    List commodityTypeIds = this.uccCommodityTypeMapper.qeryTypeIdByCatalogIds(uccEMdmCatalogPOS.stream().map(UccEMdmCatalogPO::getCatalogId).collect(Collectors.toList()));
                    for (Long commodityTypeId : commodityTypeIds) {
                        ArrayList<Long> skuIds = new ArrayList<Long>();
                        this.deal(paramsConfigDetailPO, commodityTypeId, skuIds);
                        this.syncEs(skuIds);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u7535\u5546\u52a0\u4ef7\u914d\u7f6e\u4fee\u6539\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
            finally {
                UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
                uccParamsConfigDetailPO.setCode("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE");
                this.updateState(uccParamsConfigDetailPO);
            }
        }
        return new UccAddCoefficientConfigModifyCombServiceRspBo();
    }

    private void updateState(UccParamsConfigDetailPO uccParamsConfigDetailPO) {
        UccParamsConfigDetailPO set = new UccParamsConfigDetailPO();
        set.setRule(String.valueOf(UccConstants.UccAddCoefficientDealState.DEAL_SUCCESS));
        this.uccParamsConfigDetailMapper.updateBy(set, uccParamsConfigDetailPO);
    }

    private void deal(UccParamsConfigDetailPO paramsConfigDetailPO, Long commodityTypeId, List<Long> skuIdList) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setCommodityTypeId(commodityTypeId);
        uccSkuPo.setSkuSource(Integer.valueOf(2));
        Page page = new Page(1, 1000);
        List uccSkuPos = this.uccSkuMapper.getListPage(uccSkuPo, page);
        if (CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
            log.error("\u9ed8\u8ba4\u52a0\u4ef7\u5355\u54c1\uff1a" + uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
            this.dealAddCoefficient(uccSkuPos, paramsConfigDetailPO, skuIdList);
            if (page.getTotalPages() > 1) {
                for (int i = 2; i <= page.getTotalPages(); ++i) {
                    Page iPage = new Page(i, 1000);
                    List iUccSkuPos = this.uccSkuMapper.getListPage(uccSkuPo, iPage);
                    if (!CollectionUtils.isNotEmpty((Collection)iUccSkuPos)) continue;
                    this.dealAddCoefficient(iUccSkuPos, paramsConfigDetailPO, skuIdList);
                }
            }
        }
        log.error("\u9ed8\u8ba4\u52a0\u4ef7\u5355\u54c12\uff1a" + skuIdList);
    }

    private void dealAddCoefficient(List<UccSkuPo> uccSkuPos, UccParamsConfigDetailPO paramsConfigDetailPO, List<Long> skuIdList) {
        List skuIds = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        UccSkuPriceModifyAtomServiceReqBo uccSkuPriceModifyAtomServiceReqBo = new UccSkuPriceModifyAtomServiceReqBo();
        uccSkuPriceModifyAtomServiceReqBo.setSkuIds(skuIds);
        uccSkuPriceModifyAtomServiceReqBo.setChangeType(UccConstants.SkuPriceChangeType.COEFFICIENT);
        uccSkuPriceModifyAtomServiceReqBo.setAddCoefficient(new BigDecimal(paramsConfigDetailPO.getRule()));
        uccSkuPriceModifyAtomServiceReqBo.setAllowMarketPrice(paramsConfigDetailPO.getAllowMarketPrice());
        UccSkuPriceModifyAtomServiceRspBo uccSkuPriceModifyAtomServiceRspBo = this.uccSkuPriceModifyAtomService.skuPriceChange(uccSkuPriceModifyAtomServiceReqBo);
        if (!"0000".equals(uccSkuPriceModifyAtomServiceRspBo.getRespCode())) {
            throw new BusinessException("8888", uccSkuPriceModifyAtomServiceRspBo.getRespDesc());
        }
        skuIdList.addAll(skuIds);
        log.error("\u9ed8\u8ba4\u52a0\u4ef7\u5355\u54c13\uff1a" + skuIdList);
    }

    private void syncEs(List<Long> skuIds) {
        if (CollectionUtils.isNotEmpty(skuIds)) {
            int INCREMENT;
            int endIndex = INCREMENT = 200;
            if (skuIds.size() > INCREMENT) {
                int times = skuIds.size() % INCREMENT == 0 ? skuIds.size() / INCREMENT : skuIds.size() / INCREMENT + 1;
                int startIndex = 0;
                for (int i = 1; i <= times; ++i) {
                    this.sendMq(skuIds.subList(startIndex, i == times ? skuIds.size() : endIndex));
                    startIndex += INCREMENT;
                    endIndex += INCREMENT;
                }
            } else {
                log.error("\u540c\u6b65\u52a0\u4ef7es\uff1a" + skuIds);
                this.sendMq(skuIds);
            }
        }
    }

    private void sendMq(List<Long> subList) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(subList);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u52a0\u4ef7\u63a8\u9001es\u5f02\u5e38--->", (Throwable)e);
        }
    }

    private UccParamsConfigDetailPO packagingParamsConfigDetail() {
        UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
        ArrayList<String> codeList = new ArrayList<String>(3);
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT");
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET");
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE");
        List listByCode = this.uccParamsConfigDetailMapper.getListByCode(codeList);
        if (CollectionUtils.isNotEmpty((Collection)listByCode)) {
            Map<String, UccParamsConfigDetailPO> paramsConfigDetailMap = listByCode.stream().collect(Collectors.toMap(UccParamsConfigDetailPO::getCode, po -> po, (k1, k2) -> k2));
            uccParamsConfigDetailPO = paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT");
            uccParamsConfigDetailPO.setDealStatus(Integer.valueOf(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE").getRule()));
            uccParamsConfigDetailPO.setAllowMarketPrice(Integer.valueOf(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET").getRule()));
        }
        return uccParamsConfigDetailPO;
    }
}

