/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.signcontractapply;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.signcontractapply.IUmcSignContractApplyModel;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.service.signcontractapply.UmcUpdateContractStatusService;
import com.tydic.dyc.umc.service.signcontractapply.bo.UmcUpdateContractStatusReqBo;
import com.tydic.dyc.umc.service.signcontractapply.bo.UmcUpdateContractStatusRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.signcontractapply.UmcUpdateContractStatusService"})
public class UmcUpdateContractStatusServiceImpl
implements UmcUpdateContractStatusService {
    @Autowired
    private IUmcSignContractApplyModel iUmcSignContractApplyModel;

    @PostMapping(value={"UmcUpdateContractStatus"})
    public UmcUpdateContractStatusRspBo UmcUpdateContractStatus(@RequestBody UmcUpdateContractStatusReqBo reqBo) {
        this.validateAgr(reqBo);
        UmcSignContractApplyDo qryDetailDo = new UmcSignContractApplyDo();
        qryDetailDo.setSignContractId(reqBo.getApplyId());
        UmcSignContractApplyDo detail = this.iUmcSignContractApplyModel.querySignContractApplyInfo(qryDetailDo);
        if (null == detail) {
            throw new BaseBusinessException("200100", "\u8be5\u7b7e\u7ea6\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        }
        if (UmcCommConstant.SUP_CONTRACT_STATUS.CREATED.equals(reqBo.getContractStatus()) && !UmcStatusConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE.equals(detail.getStatus())) {
            throw new BaseBusinessException("200100", "\u672a\u7b7e\u7ea6\u5b8c\u6bd5\uff0c\u4e0d\u80fd\u8fdb\u884c\u5408\u540c\u7b7e\u7f72\u56de\u8c03");
        }
        UmcSignContractApplyDo updateSignApplyDo = StrUtil.noNullStringAttr(UmcRu.js(reqBo, UmcSignContractApplyDo.class));
        updateSignApplyDo.setApplyId(detail.getApplyId());
        this.iUmcSignContractApplyModel.updateSignContractApply(updateSignApplyDo);
        UmcUpdateContractStatusRspBo rspBo = new UmcUpdateContractStatusRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateAgr(UmcUpdateContractStatusReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u7533\u8bf7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

