/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDoneList;
import com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService"})
public class UmcSendHaveDoneServiceImpl
implements UmcSendHaveDoneService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendHaveDoneServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.have.done.sync.enable:true}")
    private boolean haveDoneSyncEnable;

    @PostMapping(value={"sendHaveDone"})
    public UmcSendHaveDoneRspBo sendHaveDone(@RequestBody UmcSendHaveDoneReqBo reqBO) {
        UmcTodoDo qryDo = new UmcTodoDo();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryDo);
        List<UmcTodoDo> results = this.iUmcTodoModel.getTodoList(qryDo);
        if (CollectionUtils.isEmpty(results)) {
            throw new BaseBusinessException("200100", "\u67e5\u8be2\u5f85\u529e\u5217\u8868\u4e3a\u7a7a");
        }
        Date now = new Date();
        ArrayList<UmcTodoDone> todoDoneList = new ArrayList<UmcTodoDone>();
        ArrayList<Long> deleteTodoIdList = new ArrayList<Long>();
        UmcTodoDo dealUmcTodoDo = results.get(0);
        UmcTodoDone umcTodoDone = new UmcTodoDone();
        BeanUtils.copyProperties((Object)dealUmcTodoDo, (Object)umcTodoDone);
        umcTodoDone.setTodoStatus(UmcCommConstant.TODO_STATUS.DONE);
        umcTodoDone.setTodoCreateTime(dealUmcTodoDo.getCreateTime());
        umcTodoDone.setCreateTime(now);
        todoDoneList.add(umcTodoDone);
        deleteTodoIdList.add(umcTodoDone.getTodoId());
        if (reqBO.getIsAllDeal().booleanValue()) {
            qryDo.setDealUserId(null);
            List<UmcTodoDo> otherTodoList = this.iUmcTodoModel.getTodoList(qryDo);
            if (CollectionUtils.isEmpty(otherTodoList)) {
                throw new BaseBusinessException("200100", "\u67e5\u8be2\u5f85\u529e\u5217\u8868\u4e3a\u7a7a");
            }
            for (UmcTodoDo bo : otherTodoList) {
                if (Objects.equals(bo.getDealUserId(), reqBO.getDealUserId())) continue;
                UmcTodoDone otherUmcTodoDone = new UmcTodoDone();
                BeanUtils.copyProperties((Object)bo, (Object)otherUmcTodoDone);
                otherUmcTodoDone.setTodoStatus(UmcCommConstant.TODO_STATUS.REVOKE);
                otherUmcTodoDone.setTodoCreateTime(dealUmcTodoDo.getCreateTime());
                otherUmcTodoDone.setCreateTime(now);
                otherUmcTodoDone.setCreateUserId(dealUmcTodoDo.getCreateUserId());
                otherUmcTodoDone.setCreateName(dealUmcTodoDo.getCreateName());
                otherUmcTodoDone.setCreateOrgId(dealUmcTodoDo.getCreateOrgId());
                otherUmcTodoDone.setCreateOrgName(dealUmcTodoDo.getCreateOrgName());
                todoDoneList.add(otherUmcTodoDone);
                deleteTodoIdList.add(otherUmcTodoDone.getTodoId());
            }
        }
        UmcTodoDoneList umcTodoDoneList = new UmcTodoDoneList();
        umcTodoDoneList.setUmcTodoDoneList(todoDoneList);
        int isInsert = this.iUmcTodoModel.createDone(umcTodoDoneList);
        UmcTodoDo deleteUmcTodoDo = new UmcTodoDo();
        deleteUmcTodoDo.setTodoIdList(deleteTodoIdList);
        int isDelete = this.iUmcTodoModel.deleteTodo(deleteUmcTodoDo).getCheck();
        if (this.haveDoneSyncEnable) {
            // empty if block
        }
        return UmcRu.success(UmcSendHaveDoneRspBo.class);
    }
}

