/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoListDo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.service.todo.UmcSendTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoPushBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.todo.UmcSendTodoService"})
public class UmcSendTodoServiceImpl
implements UmcSendTodoService {
    private static final Logger log = LoggerFactory.getLogger(UmcSendTodoServiceImpl.class);
    @Autowired
    private IUmcTodoModel iUmcTodoModel;
    @Resource(name="umcTodoSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${umc.todo.sync.topic:UMC_TODO_SYNC_TOPIC}")
    private String todoSyncTopic;
    @Value(value="${umc.todo.sync.tag:*}")
    private String todoSyncTag;
    @Value(value="${umc.todo.sync.enable:true}")
    private boolean todoSyncEnable;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    @PostMapping(value={"sendTodo"})
    public UmcSendTodoRspBo sendTodo(@RequestBody UmcSendTodoReqBo reqBO) {
        this.valdateParam(reqBO);
        Set userIdList = reqBO.getTodoList().stream().map(UmcTodoBO::getDealUserId).collect(Collectors.toSet());
        userIdList.add(((UmcTodoBO)reqBO.getTodoList().get(0)).getCreateUserId());
        UmcUserInfoQryBo qryBO = new UmcUserInfoQryBo();
        qryBO.setUserIdList(new ArrayList<Long>(userIdList));
        List umcUserInfoQryBoList = this.iUmcUserInfoModel.getUserOrgBaseInfoList(qryBO).getRows();
        Map userInfoMap = umcUserInfoQryBoList.stream().collect(Collectors.toMap(UmcUserInfoQryBo::getUserId, Function.identity()));
        UmcUserInfoQryBo createUserInfo = (UmcUserInfoQryBo)((Object)userInfoMap.get(((UmcTodoBO)reqBO.getTodoList().get(0)).getCreateUserId()));
        Date now = new Date();
        UmcSendTodoRspBo rsp = UmcRu.success(UmcSendTodoRspBo.class);
        ArrayList<UmcTodoDo> umcTodoDoList = new ArrayList<UmcTodoDo>();
        for (UmcTodoBO bo : reqBO.getTodoList()) {
            UmcUserInfoQryBo dealUserInfo = (UmcUserInfoQryBo)((Object)userInfoMap.get(bo.getDealUserId()));
            UmcTodoDo umcTodoDo = new UmcTodoDo();
            BeanUtils.copyProperties((Object)bo, (Object)umcTodoDo);
            umcTodoDo.setTodoId(IdUtil.nextId());
            umcTodoDo.setCreateTime(now);
            umcTodoDo.setCreateName(createUserInfo.getCustName());
            umcTodoDo.setCreateOrgId(createUserInfo.getOrgId());
            umcTodoDo.setCreateOrgName(createUserInfo.getOrgName());
            umcTodoDo.setDealName(dealUserInfo.getCustName());
            umcTodoDo.setDealOrgId(dealUserInfo.getOrgId());
            umcTodoDo.setDealOrgName(dealUserInfo.getOrgName());
            umcTodoDo.setDealOrgPath(dealUserInfo.getOrgTreePath());
            umcTodoDo.setDealCompanyId(dealUserInfo.getCompanyId());
            umcTodoDo.setDealCompanyName(dealUserInfo.getCompanyName());
            umcTodoDoList.add(umcTodoDo);
        }
        UmcTodoListDo umcTodoListDo = new UmcTodoListDo();
        umcTodoListDo.setUmcTodoDos(umcTodoDoList);
        int isInsert = this.iUmcTodoModel.createTodo(umcTodoListDo);
        if (isInsert != umcTodoDoList.size()) {
            throw new BaseBusinessException("101021", "\u63d2\u5165\u4ee3\u529e\u4fe1\u606f\u8868\u5931\u8d25\uff01");
        }
        rsp.setTodoList(reqBO.getTodoList());
        if (this.todoSyncEnable) {
            // empty if block
        }
        return rsp;
    }

    private void sendMq(List<UmcTodoItem> todoItemList, List<UmcTodoDo> umcTodoDoList) {
        log.debug("todoItemList:{}", (Object)JSON.toJSONString(todoItemList));
        Map<String, UmcTodoItem> todoItemMap = todoItemList.stream().distinct().filter(a -> "1".equals(a.getPushFlag())).collect(Collectors.toMap(UmcTodoItem::getTodoItemCode, o -> o, (o1, o2) -> o1));
        log.debug("todoItemMap:{}", (Object)JSON.toJSONString(todoItemMap));
        for (UmcTodoDo umcTodoDo : umcTodoDoList) {
            UmcTodoItem umcTodoItem = todoItemMap.get(umcTodoDo.getTodoItemCode());
            if (null == umcTodoItem) continue;
            UmcToDoPushBo umcToDoPushBo = UmcRu.js(umcTodoDo, UmcToDoPushBo.class);
            umcToDoPushBo.setTodoType(UmcCommConstant.TODO_TYPE.TODO);
            umcToDoPushBo.setTodoModuleName(umcTodoItem.getTodoModuleName());
            umcToDoPushBo.setTodoModuleCode(umcTodoItem.getTodoModuleCode());
            umcToDoPushBo.setTodoItemCode(umcTodoItem.getTodoItemCode());
            umcToDoPushBo.setTodoItemName(umcTodoItem.getTodoItemName());
            umcToDoPushBo.setTodoClass(umcTodoItem.getTodoClass());
            this.proxyMessageProducer.send(new ProxyMessage(this.todoSyncTopic, this.todoSyncTag, JSON.toJSONString((Object)umcToDoPushBo)));
        }
    }

    private void valdateParam(UmcSendTodoReqBo reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getTodoList())) {
            throw new BaseBusinessException("200001", "\u5f85\u529e\u6a21\u5757-\u63a8\u9001\u5f85\u529eAPI\u5165\u53c2\u3010todoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcTodoBO umcTodoBO : reqBO.getTodoList()) {
        }
    }
}

