/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.service.user.UmcQryUserInfoListService;
import com.tydic.dyc.umc.service.user.bo.UmcQryUserInfoListReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcQryUserInfoListRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.user.UmcQryUserInfoListService"})
public class UmcQryUserInfoListServiceImpl
implements UmcQryUserInfoListService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"qryUserInfoList"})
    public UmcQryUserInfoListRspBo qryUserInfoList(@RequestBody UmcQryUserInfoListReqBo reqBo) {
        UmcUserInfoQryBo userInfoQryBo = UmcRu.js(reqBo, UmcUserInfoQryBo.class);
        List userInfoQryBoList = this.iUmcUserInfoModel.getUserInfoList(StrUtil.noNullStringAttr(userInfoQryBo)).getRows();
        List<Long> orgIds = userInfoQryBoList.stream().map(UmcUserInfoQryBo::getOrgId).collect(Collectors.toList());
        UmcEnterpriseInfoDo pathReqDo = new UmcEnterpriseInfoDo();
        pathReqDo.setOrgIds(orgIds);
        Map<Long, String> orgFullNameMap = this.iUmcEnterpriseInfoModel.getOrgFullNameByOrgIds(pathReqDo).getOrgFullNameByOrgIds();
        Map<String, String> sexMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "MEM_SEX")).getMap();
        Map<String, String> stopStatusMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "MEM_STOP_STATUS")).getMap();
        Map<String, String> userTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "USER_TYPE")).getMap();
        for (UmcUserInfoQryBo bo : userInfoQryBoList) {
            UmcCustInfo custInfoBo;
            if (orgFullNameMap.containsKey(bo.getOrgId())) {
                bo.setOrgFullName(orgFullNameMap.get(bo.getOrgId()));
            }
            if (null != (custInfoBo = bo.getCustInfo()).getSex()) {
                custInfoBo.setSexStr(sexMap.get(custInfoBo.getSex().toString()));
            }
            if (!StringUtils.isEmpty((Object)bo.getStopStatus()) && !CollectionUtils.isEmpty(stopStatusMap)) {
                bo.setStopStatusStr(stopStatusMap.get(bo.getStopStatus()));
            }
            if (StringUtils.isEmpty((Object)bo.getUserType()) || CollectionUtils.isEmpty(userTypeMap)) continue;
            bo.setUserTypeStr(userTypeMap.get(bo.getUserType()));
        }
        UmcQryUserInfoListRspBo rspBo = UmcRu.success(UmcQryUserInfoListRspBo.class);
        rspBo.setUserInfoBoList(UmcRu.jsl(userInfoQryBoList, UmcUserInfoBo.class));
        return rspBo;
    }
}

