/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.user.UmcUserInfoPartService;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoPartReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoPartRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.user.UmcUserInfoPartService"})
public class UmcUserInfoPartServiceImpl
implements UmcUserInfoPartService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"partUserInfo"})
    public UmcUserInfoPartRspBo partUserInfo(@RequestBody UmcUserInfoPartReqBo reqBo) {
        this.validReqParam(reqBo);
        UmcUserInfoPartRspBo rspBo = UmcRu.success(UmcUserInfoPartRspBo.class);
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        userInfoQryBo.setDelFlag("0");
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getUserInfo(userInfoQryBo);
        if (null == userInfoDo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getNewOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        UmcUserInfoDo umcUserInfoDo = this.buildUserInfo(reqBo, userInfoDo, orgInfo);
        this.iUmcUserInfoModel.createUserInfo(umcUserInfoDo);
        rspBo.setUserInfoBo(UmcRu.js(umcUserInfoDo, UmcUserInfoBo.class));
        return rspBo;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserInfoPartReqBo reqBo, UmcUserInfoDo userInfoDo, UmcOrgInfo orgInfo) {
        UmcUserInfoDo umcUserInfoDo = UmcRu.js(userInfoDo, UmcUserInfoDo.class);
        umcUserInfoDo.setUserId(reqBo.getNewUserId());
        umcUserInfoDo.setOrgId(reqBo.getNewOrgId());
        umcUserInfoDo.setCompanyId(orgInfo.getCompanyId());
        umcUserInfoDo.setCustInfo(null);
        umcUserInfoDo.setPartRemark(reqBo.getRemark());
        umcUserInfoDo.setCreateOperId(reqBo.getCreateOperId());
        umcUserInfoDo.setCreateOperName(reqBo.getCreateOperName());
        umcUserInfoDo.setCreateTime(reqBo.getCreateTime());
        umcUserInfoDo.setUpdateOperId(reqBo.getUpdateOperId());
        umcUserInfoDo.setUpdateOperName(reqBo.getUpdateOperName());
        umcUserInfoDo.setUpdateTime(reqBo.getUpdateTime());
        umcUserInfoDo.setIsMain("0");
        umcUserInfoDo.setOrgTreePath(reqBo.getOrgTreePath());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            ArrayList<UmcUserTagRel> userTagRelList = new ArrayList<UmcUserTagRel>();
            for (UmcUserTagRelBo userTag : reqBo.getUserTagRelList()) {
                UmcUserTagRel userTagRel = new UmcUserTagRel();
                userTagRel.setRelId(IdUtil.nextId());
                userTagRel.setTagId(userTag.getTagId());
                userTagRel.setTenantId(userInfoDo.getTenantId());
                userTagRel.setUserId(reqBo.getNewUserId());
                userTagRel.setIsDefalt(userTag.getIsDefalt());
                userTagRel.setDelFlag("0");
                userTagRel.setCreateOperId(reqBo.getCreateOperId());
                userTagRel.setCreateOperName(reqBo.getCreateOperName());
                userTagRel.setCreateTime(reqBo.getCreateTime());
                userTagRelList.add(userTagRel);
            }
            umcUserInfoDo.setUserTagRelList(userTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelBoList())) {
            ArrayList<UmcUserRoleRel> userRoleRelList = new ArrayList<UmcUserRoleRel>();
            for (UmcUserRoleRelBo userRole : reqBo.getUserRoleRelBoList()) {
                UmcUserRoleRel userRoleRel = new UmcUserRoleRel();
                userRoleRel.setRelId(IdUtil.nextId());
                userRoleRel.setUserId(reqBo.getNewUserId());
                userRoleRel.setTenantId(userInfoDo.getTenantId());
                userRoleRel.setRoleId(userRole.getRoleId());
                userRoleRel.setDelFlag("0");
                userRoleRel.setCreateOperId(reqBo.getCreateOperId());
                userRoleRel.setCreateOperName(reqBo.getCreateOperName());
                userRoleRel.setCreateTime(reqBo.getCreateTime());
                userRoleRelList.add(userRoleRel);
            }
            umcUserInfoDo.setUserRoleRelList(userRoleRelList);
        }
        if (!CollectionUtils.isEmpty(userInfoDo.getUserExtMapList())) {
            for (UmcUserExtMap extMap : userInfoDo.getUserExtMapList()) {
                extMap.setExtId(IdUtil.nextId());
                extMap.setUserId(reqBo.getNewUserId());
            }
            umcUserInfoDo.setUserExtMapList(userInfoDo.getUserExtMapList());
        }
        return umcUserInfoDo;
    }

    private void validReqParam(UmcUserInfoPartReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[newUserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewOrgId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[NewOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

