/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.config;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcInquiryConfigConstant;
import com.tydic.dyc.umc.model.orgpublicdicConfig.IUmcOrgPublicDicConfigModel;
import com.tydic.dyc.umc.model.orgpublicdicConfig.sub.UmcOrgPublicDicConfigExtBo;
import com.tydic.dyc.umc.model.orgpublicdicConfig.sub.UmcOrgPublicDicConfigExtBoRspBo;
import com.tydic.dyc.umc.service.config.UmcQueryInquiryRuleConfigService;
import com.tydic.dyc.umc.service.config.bo.UmcInquiryRuleBO;
import com.tydic.dyc.umc.service.config.bo.UmcQueryInquiryRuleConfigReqBO;
import com.tydic.dyc.umc.service.config.bo.UmcQueryInquiryRuleConfigRspBO;
import com.tydic.dyc.umc.service.config.bo.UmcSelectedRuleBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.config.UmcQueryInquiryRuleConfigService"})
public class UmcQueryInquiryRuleConfigServiceImpl
implements UmcQueryInquiryRuleConfigService {
    @Autowired
    private IUmcOrgPublicDicConfigModel iUmcOrgPublicDicConfigModel;

    @PostMapping(value={"queryInquiryRuleConfig"})
    public UmcQueryInquiryRuleConfigRspBO queryInquiryRuleConfig(@RequestBody UmcQueryInquiryRuleConfigReqBO reqBO) {
        this.valData(reqBO);
        UmcQueryInquiryRuleConfigRspBO rspBO = UmcRu.success(UmcQueryInquiryRuleConfigRspBO.class);
        this.qryInquiryConfig(reqBO, rspBO);
        this.qrySelectedConfig(reqBO, rspBO);
        return rspBO;
    }

    private void qrySelectedConfig(UmcQueryInquiryRuleConfigReqBO reqBO, UmcQueryInquiryRuleConfigRspBO rspBO) {
        UmcOrgPublicDicConfigExtBo qrySelectedBO = new UmcOrgPublicDicConfigExtBo();
        qrySelectedBO.setConfigId(reqBO.getSelectedRuleConfigId());
        qrySelectedBO.setOrderBy("dic_code");
        UmcOrgPublicDicConfigExtBoRspBo qrySelectedListBO = this.iUmcOrgPublicDicConfigModel.getListExt(qrySelectedBO);
        if (!CollectionUtils.isEmpty((Collection)qrySelectedListBO.getRows())) {
            ArrayList<UmcSelectedRuleBO> selectedRuleBOList = new ArrayList<UmcSelectedRuleBO>();
            for (UmcOrgPublicDicConfigExtBo configExtBo : qrySelectedListBO.getRows()) {
                UmcSelectedRuleBO selectedRuleBO = new UmcSelectedRuleBO();
                selectedRuleBO.setValidQuotationNum(Integer.valueOf(configExtBo.getDicCode()));
                selectedRuleBO.setSelectedNum(Integer.valueOf(configExtBo.getDicValue()));
                selectedRuleBOList.add(selectedRuleBO);
            }
            rspBO.setSelectedRuleBOList(selectedRuleBOList);
        }
    }

    private void qryInquiryConfig(UmcQueryInquiryRuleConfigReqBO reqBO, UmcQueryInquiryRuleConfigRspBO rspBO) {
        UmcOrgPublicDicConfigExtBo qryInquiryBO = new UmcOrgPublicDicConfigExtBo();
        qryInquiryBO.setConfigId(reqBO.getInquiryRuleConfigId());
        UmcOrgPublicDicConfigExtBoRspBo qryInquiryListBO = this.iUmcOrgPublicDicConfigModel.getListExt(qryInquiryBO);
        if (!CollectionUtils.isEmpty((Collection)qryInquiryListBO.getRows())) {
            Map<String, UmcOrgPublicDicConfigExtBo> inquiryMap = qryInquiryListBO.getRows().stream().collect(Collectors.toMap(UmcOrgPublicDicConfigExtBo::getDicCode, e -> e, (e1, e2) -> e2));
            UmcInquiryRuleBO inquiryRuleBO = new UmcInquiryRuleBO();
            inquiryRuleBO.setConfigId(reqBO.getInquiryRuleConfigId());
            if (inquiryMap.containsKey(UmcInquiryConfigConstant.ConfigExt.CONFIG_TYPE.getCode())) {
                inquiryRuleBO.setConfigType(inquiryMap.get(UmcInquiryConfigConstant.ConfigExt.CONFIG_TYPE.getCode()).getDicValue());
            }
            if (inquiryMap.containsKey(UmcInquiryConfigConstant.ConfigExt.TYPE_TIME.getCode())) {
                inquiryRuleBO.setConfigTime(inquiryMap.get(UmcInquiryConfigConstant.ConfigExt.TYPE_TIME.getCode()).getDicValue());
            }
            if (inquiryMap.containsKey(UmcInquiryConfigConstant.ConfigExt.TYPE_WEEK.getCode())) {
                inquiryRuleBO.setConfigWeek(inquiryMap.get(UmcInquiryConfigConstant.ConfigExt.TYPE_WEEK.getCode()).getDicValue());
            }
            if (inquiryMap.containsKey(UmcInquiryConfigConstant.ConfigExt.TYPE_MONTH.getCode())) {
                inquiryRuleBO.setConfigMonth(inquiryMap.get(UmcInquiryConfigConstant.ConfigExt.TYPE_MONTH.getCode()).getDicValue());
            }
            rspBO.setInquiryRuleBO(inquiryRuleBO);
        }
    }

    private void valData(UmcQueryInquiryRuleConfigReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInquiryRuleConfigId())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u8be2\u4ef7\u89c4\u5219\u914d\u7f6eID[inquiryRuleConfigId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSelectedRuleConfigId())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u8be2\u4ef7\u89c4\u5219\u914d\u7f6e\u5165\u53c2\u4e2d\u9009\u89c4\u5219\u914d\u7f6eID[selectedRuleConfigId]\u4e3a\u7a7a");
        }
    }
}

