/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcBatchAddOrg;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.enterpriseacount.IUmcEnterpriseAccountModel;
import com.tydic.dyc.umc.model.enterpriseacount.UmcEnterpriseAccountDo;
import com.tydic.dyc.umc.model.enterpriseacount.qrybo.UmcEnterpriseAccountQryBo;
import com.tydic.dyc.umc.model.invoice.IUmcInvoiceInfoModel;
import com.tydic.dyc.umc.model.invoice.UmcInvoiceInfoDo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoQryBo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcCustInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcBatchAddUser;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.enterprise.UmcDealSupplierInfoAndUserInfoService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDealSupplierInfoAndUserInfoBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDealSupplierInfoAndUserInfoReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDealSupplierInfoAndUserInfoRspBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgTagRelBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcDealSupplierInfoAndUserInfoService"})
public class UmcDealSupplierInfoAndUserInfoServiceImpl
implements UmcDealSupplierInfoAndUserInfoService {
    @Autowired
    private IUmcEnterpriseInfoModel umcEnterpriseInfoModel;
    @Autowired
    private IUmcEnterpriseAccountModel umcEnterpriseAccountModel;
    @Autowired
    private IUmcInvoiceInfoModel umcInvoiceInfoModel;
    @Autowired
    private IUmcUserInfoModel umcUserInfoModel;
    @Value(value="${syncSupplier.onlineSupplierCode:100055,100054}")
    private String onlineSupplierCode;
    @Value(value="${syncSupplier.tenantId:10000}")
    private Long tenantId;
    @Value(value="${syncSupplier.defaultArgRoleId:12}")
    private Long defaultArgRoleId;
    @Value(value="${syncSupplier.defaultOnlineRoleId:13}")
    private Long defaultOnlineRoleId;
    @Value(value="${syncSupplier.parentId:305775845729763332}")
    private Long parentId;
    @Value(value="${syncSupplier.parentOrgTreePath:1-305775845729763327-305775845729763332-}")
    private String parentOrgTreePath;
    private static final String AUTH_TYPE = "auth:extorg:manage";
    private static final List<Long> JD_IDS = Arrays.asList(100054L, 100055L);

    @PostMapping(value={"dealSupplierInfoAndUserInfo"})
    public UmcDealSupplierInfoAndUserInfoRspBO dealSupplierInfoAndUserInfo(@RequestBody UmcDealSupplierInfoAndUserInfoReqBO reqBO) {
        UmcDealSupplierInfoAndUserInfoRspBO rspBO = UmcRu.success(UmcDealSupplierInfoAndUserInfoRspBO.class);
        this.valDealData(reqBO);
        Map<Object, Object> extOrgIdGroup = new HashMap();
        Map<Object, Object> enterpriseInfoMap = new HashMap();
        HashMap<Long, UmcEnterpriseContact> enterpriseContactMap = new HashMap();
        HashMap<Long, UmcEnterpriseBank> enterpriseBankMap = new HashMap();
        HashMap<Long, UmcEnterpriseAccountDo> enterpriseAccountMap = new HashMap();
        HashMap<Long, UmcInvoiceInfoDo> invoiceInfoMap = new HashMap();
        List<Long> orgIds = new ArrayList<Long>();
        List<String> extOrgIds = reqBO.getDealSupplierInfoAndUserInfoBOList().stream().map(UmcDealSupplierInfoAndUserInfoBO::getExtOrgId).collect(Collectors.toList());
        UmcOrgInfoQryBo qryOrgInfoBO = new UmcOrgInfoQryBo();
        qryOrgInfoBO.setExtOrgIds(extOrgIds);
        List umcOrgInfos = this.umcEnterpriseInfoModel.getOrgInfoList(qryOrgInfoBO).getRows();
        if (!ObjectUtil.isEmpty((Object)umcOrgInfos)) {
            extOrgIdGroup = umcOrgInfos.stream().collect(Collectors.groupingBy(UmcOrgInfo::getExtOrgId));
            orgIds = umcOrgInfos.stream().map(UmcOrgInfo::getOrgId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            UmcEnterpriseInfoQryBo umcEnterpriseInfoQryBo = new UmcEnterpriseInfoQryBo();
            umcEnterpriseInfoQryBo.setOrgIds(orgIds);
            List umcEnterpriseInfoDoList = this.umcEnterpriseInfoModel.getEnterpriseInfoList(umcEnterpriseInfoQryBo).getRows();
            if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoDoList)) {
                enterpriseInfoMap = umcEnterpriseInfoDoList.stream().collect(Collectors.toMap(UmcEnterpriseInfoDo::getOrgId, o -> o));
            }
            UmcEnterpriseContactQryBo umcEnterpriseContactQryBo = new UmcEnterpriseContactQryBo();
            umcEnterpriseContactQryBo.setOrgIds(orgIds);
            List<UmcEnterpriseContact> umcEnterpriseContactList = this.umcEnterpriseInfoModel.getEnterpriseContactList(umcEnterpriseContactQryBo).getEnterpriseContactList();
            if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoDoList)) {
                enterpriseContactMap = umcEnterpriseContactList.stream().collect(Collectors.toMap(UmcEnterpriseContact::getOrgId, o -> o));
            }
            UmcEnterpriseBankQryBo umcEnterpriseBankQryBo = new UmcEnterpriseBankQryBo();
            umcEnterpriseBankQryBo.setOrgIds(orgIds);
            List<UmcEnterpriseBank> umcEnterpriseBankList = this.umcEnterpriseInfoModel.getEnterpriseBankList(umcEnterpriseBankQryBo).getEnterpriseBankList();
            if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoDoList)) {
                enterpriseBankMap = umcEnterpriseBankList.stream().collect(Collectors.toMap(UmcEnterpriseBank::getOrgId, o -> o));
            }
            UmcEnterpriseAccountQryBo umcEnterpriseAccountQryBo = new UmcEnterpriseAccountQryBo();
            umcEnterpriseAccountQryBo.setOrgIds(orgIds);
            List umcEnterpriseAccountDoList = this.umcEnterpriseAccountModel.getEnterpriseAccountList(umcEnterpriseAccountQryBo).getRows();
            if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoDoList)) {
                enterpriseAccountMap = umcEnterpriseAccountDoList.stream().collect(Collectors.toMap(UmcEnterpriseAccountDo::getOrgId, o -> o));
            }
            UmcInvoiceInfoQryBo umcInvoiceInfoQryBo = new UmcInvoiceInfoQryBo();
            umcInvoiceInfoQryBo.setOrgIds(orgIds);
            List umcInvoiceInfoDoList = this.umcInvoiceInfoModel.getInvoiceInfoList(umcInvoiceInfoQryBo).getRows();
            if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoDoList)) {
                invoiceInfoMap = umcInvoiceInfoDoList.stream().collect(Collectors.toMap(UmcInvoiceInfoDo::getOrgId, o -> o));
            }
        }
        List<String> onlineSupplierCodeList = Arrays.asList(this.onlineSupplierCode.split(","));
        ArrayList<UmcOrgInfo> addOrgInfoList = new ArrayList<UmcOrgInfo>();
        ArrayList<UmcOrgTagRel> addOrgRelList = new ArrayList<UmcOrgTagRel>();
        ArrayList<UmcEnterpriseInfoDo> addEnterpriseInfoList = new ArrayList<UmcEnterpriseInfoDo>();
        ArrayList<UmcEnterpriseAccountDo> addEnterpriseAccountList = new ArrayList<UmcEnterpriseAccountDo>();
        ArrayList<UmcEnterpriseContact> addEnterpriseContactList = new ArrayList<UmcEnterpriseContact>();
        ArrayList<UmcEnterpriseBank> addEnterpriseBankList = new ArrayList<UmcEnterpriseBank>();
        ArrayList<UmcInvoiceInfoDo> addInvoiceInfoList = new ArrayList<UmcInvoiceInfoDo>();
        ArrayList<UmcCustInfo> addCustInfoList = new ArrayList<UmcCustInfo>();
        ArrayList<UmcUserInfoDo> addUserInfoList = new ArrayList<UmcUserInfoDo>();
        ArrayList<UmcUserTagRel> addUserTagRelList = new ArrayList<UmcUserTagRel>();
        ArrayList<UmcUserRoleRel> addUserRoleRelList = new ArrayList<UmcUserRoleRel>();
        ArrayList<UmcOrgInfo> updateOrgInfoList = new ArrayList<UmcOrgInfo>();
        ArrayList<UmcCustInfo> updateCustInfoList = new ArrayList<UmcCustInfo>();
        ArrayList<Long> delCustIdList = new ArrayList<Long>();
        for (UmcDealSupplierInfoAndUserInfoBO supplierInfo : reqBO.getDealSupplierInfoAndUserInfoBOList()) {
            if (extOrgIdGroup.containsKey(supplierInfo.getExtOrgId())) {
                List umcOrgInfoList = (List)extOrgIdGroup.get(supplierInfo.getExtOrgId());
                UmcEnterpriseInfoDo enterpriseInfoDo = (UmcEnterpriseInfoDo)((Object)enterpriseInfoMap.get(((UmcOrgInfo)((Object)umcOrgInfoList.get(0))).getOrgId()));
                Long custId = this.getNowCustId(enterpriseInfoDo.getSupplierManageId());
                boolean updateSupAdminBool = enterpriseInfoDo.getSupplierManageId().equals(supplierInfo.getRegAccount());
                if (!JD_IDS.contains(enterpriseInfoDo.getOrgId())) {
                    if (!updateSupAdminBool) {
                        this.delOldSupAdmin(custId, delCustIdList);
                        custId = IdUtil.nextId();
                        this.setAddCustInfo(addCustInfoList, supplierInfo, custId);
                    } else {
                        this.setUpdateCustInfo(updateCustInfoList, supplierInfo, custId);
                    }
                }
                for (int i = 0; umcOrgInfoList.size() > i; ++i) {
                    UmcOrgInfo updateOrgInfo = this.setUpdateOrgInfo(onlineSupplierCodeList, updateOrgInfoList, supplierInfo, umcOrgInfoList, i);
                    this.setUpdateEnterpriseInfo(enterpriseInfoMap, supplierInfo, updateOrgInfo);
                    this.setUpdateEnterContact(enterpriseContactMap, supplierInfo, custId, updateOrgInfo);
                    this.setUpdateEnterBank(enterpriseBankMap, supplierInfo, updateOrgInfo);
                    UmcEnterpriseAccountDo updateEnterpriseAccount = this.setUpdateEnterpriseAccount(enterpriseAccountMap, supplierInfo, updateOrgInfo);
                    this.setUpdateInvoiceInfo(invoiceInfoMap, supplierInfo, updateOrgInfo, updateEnterpriseAccount);
                    if (JD_IDS.contains(((UmcOrgInfo)((Object)umcOrgInfoList.get(0))).getOrgId()) || updateSupAdminBool) continue;
                    String isMain = i == 0 ? "1" : "0";
                    UmcUserInfoDo addUserInfoBo = this.setAddUserInfo(addUserInfoList, supplierInfo, updateOrgInfo, custId, isMain);
                    this.setAddUserTagInfo(addUserTagRelList, addUserInfoBo);
                    this.setAddUserRoleInfo(addUserRoleRelList, supplierInfo, addUserInfoBo);
                    UmcEnterpriseInfoDo updateEnterInfo = (UmcEnterpriseInfoDo)((Object)enterpriseInfoMap.get(updateOrgInfo.getOrgId()));
                    updateEnterInfo.setExtField5(addUserInfoBo.getUserId() + "");
                    this.umcEnterpriseInfoModel.updateEnterpriseInfo(updateEnterInfo);
                }
                continue;
            }
            long orgId = IdUtil.nextId();
            UmcOrgInfo addOrgInfo = this.setAddOrgInfo(addOrgInfoList, supplierInfo, orgId);
            this.setAddOrgTagInfo(addOrgRelList, orgId);
            long custId = IdUtil.nextId();
            this.setAddCustInfo(addCustInfoList, supplierInfo, custId);
            UmcUserInfoDo addUserInfo = this.setAddUserInfo(addUserInfoList, supplierInfo, addOrgInfo, custId, "1");
            this.setAddUserTagInfo(addUserTagRelList, addUserInfo);
            this.setAddUserRoleInfo(addUserRoleRelList, supplierInfo, addUserInfo);
            long invoiceId = IdUtil.nextId();
            this.setAddEnterpriseInfo(addEnterpriseInfoList, supplierInfo, orgId, invoiceId, addUserInfo.getUserId());
            this.setAddEnterpriseContact(addEnterpriseContactList, supplierInfo, orgId, custId);
            this.setAddEnterpriseBank(addEnterpriseBankList, supplierInfo, orgId);
            UmcEnterpriseAccountDo addEnterpriseAccount = this.setAddEnterpriseAccount(addEnterpriseAccountList, supplierInfo, orgId);
            this.setAddInvoiceInfo(addInvoiceInfoList, supplierInfo, orgId, addEnterpriseAccount, invoiceId);
        }
        this.addOrg(addOrgInfoList, addOrgRelList, addEnterpriseInfoList, addEnterpriseAccountList, addEnterpriseContactList, addEnterpriseBankList, addInvoiceInfoList);
        this.addUser(addCustInfoList, addUserInfoList, addUserTagRelList, addUserRoleRelList);
        rspBO.setAddOrgInfoList(UmcRu.jsl(addOrgInfoList, UmcOrgInfoBo.class));
        rspBO.setAddOrgRelList(UmcRu.jsl(addOrgRelList, UmcOrgTagRelBo.class));
        rspBO.setAddCustInfoList(UmcRu.jsl(addCustInfoList, UmcCustInfoBo.class));
        rspBO.setAddUserInfoList(UmcRu.jsl(addUserInfoList, UmcUserInfoBo.class));
        rspBO.setAddUserTagRelList(UmcRu.jsl(addUserTagRelList, UmcUserTagRelBo.class));
        rspBO.setAddUserRoleRelList(UmcRu.jsl(addUserRoleRelList, UmcUserRoleRelBo.class));
        rspBO.setUpdateOrgInfoList(UmcRu.jsl(updateOrgInfoList, UmcOrgInfoBo.class));
        rspBO.setUpdateCustInfoList(UmcRu.jsl(updateCustInfoList, UmcCustInfoBo.class));
        rspBO.setDelCustIdList(delCustIdList);
        return rspBO;
    }

    private void addOrg(List<UmcOrgInfo> addOrgInfoList, List<UmcOrgTagRel> addOrgRelList, List<UmcEnterpriseInfoDo> addEnterpriseInfoList, List<UmcEnterpriseAccountDo> addEnterpriseAccountList, List<UmcEnterpriseContact> addEnterpriseContactList, List<UmcEnterpriseBank> addEnterpriseBankList, List<UmcInvoiceInfoDo> addInvoiceInfoList) {
        UmcBatchAddOrg addOrg = new UmcBatchAddOrg();
        addOrg.setOrgInfoList(addOrgInfoList);
        addOrg.setOrgTagRelList(addOrgRelList);
        addOrg.setEnterpriseInfoDoList(addEnterpriseInfoList);
        addOrg.setEnterpriseAccountDoList(addEnterpriseAccountList);
        addOrg.setEnterpriseBankList(addEnterpriseBankList);
        addOrg.setEnterpriseContactList(addEnterpriseContactList);
        addOrg.setInvoiceInfoDoList(addInvoiceInfoList);
        this.umcEnterpriseInfoModel.addOrg(addOrg);
    }

    private void addUser(List<UmcCustInfo> addCustInfoList, List<UmcUserInfoDo> addUserInfoList, List<UmcUserTagRel> addUserTagRelList, List<UmcUserRoleRel> addUserRoleRelList) {
        UmcBatchAddUser addUser = new UmcBatchAddUser();
        addUser.setUserInfoDoList(addUserInfoList);
        addUser.setCustInfoList(addCustInfoList);
        addUser.setUserTagRelList(addUserTagRelList);
        addUser.setUserRoleRelList(addUserRoleRelList);
        this.umcUserInfoModel.addUser(addUser);
    }

    private UmcOrgInfo setAddOrgInfo(List<UmcOrgInfo> addOrgInfoList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, long orgId) {
        UmcOrgInfo addOrgInfo = new UmcOrgInfo();
        addOrgInfo.setOrgId(orgId);
        addOrgInfo.setOrgName(supplierInfo.getOrgName());
        addOrgInfo.setTenantId(this.tenantId);
        addOrgInfo.setParentId(this.parentId);
        addOrgInfo.setOrgTreePath(this.parentOrgTreePath + orgId + "-");
        addOrgInfo.setOrgCode(supplierInfo.getExtOrgCode());
        addOrgInfo.setExtOrgId(supplierInfo.getExtOrgId());
        addOrgInfo.setExtOrgCode(supplierInfo.getExtOrgCode());
        addOrgInfo.setOrgType(supplierInfo.getOrgType());
        addOrgInfo.setCompanyId(orgId);
        addOrgInfo.setDeep(addOrgInfo.getOrgTreePath().split("-").length);
        addOrgInfo.setIsVirtual("1");
        addOrgInfo.setDelFlag("0");
        addOrgInfo.setOrgStatus(supplierInfo.getOrgStatus());
        addOrgInfo.setCreateOperId(UmcCommConstant.System.ID);
        addOrgInfo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addOrgInfo.setCreateTime(new Date());
        addOrgInfoList.add(addOrgInfo);
        return addOrgInfo;
    }

    private UmcOrgInfo setUpdateOrgInfo(List<String> onlineSupplierCodeList, List<UmcOrgInfo> updateOrgInfoList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, List<UmcOrgInfo> umcOrgInfoList, int i) {
        UmcOrgInfo updateOrgInfo = umcOrgInfoList.get(i);
        if (!onlineSupplierCodeList.contains(updateOrgInfo.getOrgCode())) {
            updateOrgInfo.setOrgName(supplierInfo.getOrgName());
            updateOrgInfo.setOrgCode(supplierInfo.getExtOrgCode());
        } else {
            supplierInfo.setOrgClass("5");
        }
        updateOrgInfo.setExtOrgCode(supplierInfo.getExtOrgCode());
        updateOrgInfo.setDelFlag("0");
        updateOrgInfo.setUpdateOperId(UmcCommConstant.System.ID);
        updateOrgInfo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateOrgInfo.setUpdateTime(new Date());
        updateOrgInfoList.add(updateOrgInfo);
        this.umcEnterpriseInfoModel.updateOrgInfo(updateOrgInfo);
        return updateOrgInfo;
    }

    private void setAddEnterpriseInfo(List<UmcEnterpriseInfoDo> addEnterpriseInfoList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, long orgId, Long invoiceId, Long userId) {
        UmcEnterpriseInfoDo addEnterpriseInfo = new UmcEnterpriseInfoDo();
        addEnterpriseInfo.setOrgId(orgId);
        addEnterpriseInfo.setTenantId(this.tenantId);
        addEnterpriseInfo.setOrgClass(supplierInfo.getOrgClass());
        addEnterpriseInfo.setIsAbroad("0");
        addEnterpriseInfo.setIsMerchant("0");
        addEnterpriseInfo.setIsShopOrg("1");
        addEnterpriseInfo.setCreditNo(supplierInfo.getCreditNo());
        addEnterpriseInfo.setSupplierManageId(supplierInfo.getRegAccount());
        addEnterpriseInfo.setAddress(supplierInfo.getAddress());
        addEnterpriseInfo.setTelephone(supplierInfo.getTelephone());
        addEnterpriseInfo.setExtField4(invoiceId + "");
        addEnterpriseInfo.setExtField5(userId + "");
        addEnterpriseInfo.setDelFlag("0");
        addEnterpriseInfo.setCreateOperId(UmcCommConstant.System.ID);
        addEnterpriseInfo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addEnterpriseInfo.setCreateTime(new Date());
        addEnterpriseInfoList.add(addEnterpriseInfo);
    }

    private void setUpdateEnterpriseInfo(Map<Long, UmcEnterpriseInfoDo> enterpriseInfoMap, UmcDealSupplierInfoAndUserInfoBO supplierInfo, UmcOrgInfo orgInfo) {
        UmcEnterpriseInfoDo updateEnterInfo = enterpriseInfoMap.get(orgInfo.getOrgId());
        updateEnterInfo.setOrgId(orgInfo.getOrgId());
        updateEnterInfo.setCreditNo(supplierInfo.getCreditNo());
        if (!JD_IDS.contains(orgInfo.getOrgId())) {
            updateEnterInfo.setSupplierManageId(supplierInfo.getRegAccount());
        }
        updateEnterInfo.setOrgClass(supplierInfo.getOrgClass());
        updateEnterInfo.setAddress(supplierInfo.getAddress());
        updateEnterInfo.setTelephone(supplierInfo.getTelephone());
        updateEnterInfo.setDelFlag("0");
        updateEnterInfo.setUpdateOperId(UmcCommConstant.System.ID);
        updateEnterInfo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateEnterInfo.setUpdateTime(new Date());
        this.umcEnterpriseInfoModel.updateEnterpriseInfo(updateEnterInfo);
    }

    private void setAddEnterpriseContact(List<UmcEnterpriseContact> addEnterpriseContactList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, long orgId, long custId) {
        UmcEnterpriseContact addEnterpriseContact = new UmcEnterpriseContact();
        addEnterpriseContact.setContactId(IdUtil.nextId());
        addEnterpriseContact.setOrgId(orgId);
        addEnterpriseContact.setTenantId(this.tenantId);
        addEnterpriseContact.setCustId(custId);
        addEnterpriseContact.setContactName(supplierInfo.getCustName());
        addEnterpriseContact.setPhoneNumber(supplierInfo.getRegMobile());
        addEnterpriseContact.setTel(supplierInfo.getOfficePhone());
        addEnterpriseContact.setEmail(supplierInfo.getRegEmail());
        addEnterpriseContact.setDelFlag("0");
        addEnterpriseContact.setExtField1("1");
        addEnterpriseContact.setCreateOperId(UmcCommConstant.System.ID);
        addEnterpriseContact.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addEnterpriseContact.setCreateTime(new Date());
        addEnterpriseContactList.add(addEnterpriseContact);
    }

    private void setUpdateEnterContact(Map<Long, UmcEnterpriseContact> enterpriseContactMap, UmcDealSupplierInfoAndUserInfoBO supplierInfo, Long custId, UmcOrgInfo orgInfo) {
        UmcEnterpriseContact updateEnterContact = enterpriseContactMap.get(orgInfo.getOrgId());
        updateEnterContact.setOrgId(orgInfo.getOrgId());
        updateEnterContact.setTenantId(this.tenantId);
        updateEnterContact.setCustId(custId);
        updateEnterContact.setContactName(supplierInfo.getCustName());
        updateEnterContact.setPhoneNumber(supplierInfo.getRegMobile());
        updateEnterContact.setTel(supplierInfo.getOfficePhone());
        updateEnterContact.setEmail(supplierInfo.getRegEmail());
        updateEnterContact.setDelFlag("0");
        updateEnterContact.setExtField1("1");
        updateEnterContact.setUpdateOperId(UmcCommConstant.System.ID);
        updateEnterContact.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateEnterContact.setUpdateTime(new Date());
        this.umcEnterpriseInfoModel.updateEnterpriseContact(updateEnterContact);
    }

    private void setAddEnterpriseBank(List<UmcEnterpriseBank> addEnterpriseBankList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, long orgId) {
        UmcEnterpriseBank addEnterpriseBank = new UmcEnterpriseBank();
        addEnterpriseBank.setBankId(IdUtil.nextId());
        addEnterpriseBank.setTenantId(this.tenantId);
        addEnterpriseBank.setOrgId(orgId);
        addEnterpriseBank.setBankName(supplierInfo.getBankName());
        addEnterpriseBank.setBankCode(supplierInfo.getBankCode());
        addEnterpriseBank.setBankAccount(supplierInfo.getBankAccount());
        addEnterpriseBank.setBankAccountName(supplierInfo.getBankName());
        addEnterpriseBank.setBankLinkNo(supplierInfo.getBankLinkNo());
        addEnterpriseBank.setBankAddr(supplierInfo.getBankAddr());
        addEnterpriseBank.setDelFlag("0");
        addEnterpriseBank.setCreateOperId(UmcCommConstant.System.ID);
        addEnterpriseBank.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addEnterpriseBank.setCreateTime(new Date());
        addEnterpriseBankList.add(addEnterpriseBank);
    }

    private void setUpdateEnterBank(Map<Long, UmcEnterpriseBank> enterpriseBankMap, UmcDealSupplierInfoAndUserInfoBO supplierInfo, UmcOrgInfo orgInfo) {
        UmcEnterpriseBank updateEnterBank = enterpriseBankMap.get(orgInfo.getOrgId());
        updateEnterBank.setTenantId(this.tenantId);
        updateEnterBank.setOrgId(orgInfo.getOrgId());
        updateEnterBank.setBankName(supplierInfo.getBankName());
        updateEnterBank.setBankCode(supplierInfo.getBankCode());
        updateEnterBank.setBankAccount(supplierInfo.getBankAccount());
        updateEnterBank.setBankAccountName(supplierInfo.getBankName());
        updateEnterBank.setBankLinkNo(supplierInfo.getBankLinkNo());
        updateEnterBank.setBankAddr(supplierInfo.getBankAddr());
        updateEnterBank.setDelFlag("0");
        updateEnterBank.setUpdateOperId(UmcCommConstant.System.ID);
        updateEnterBank.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateEnterBank.setUpdateTime(new Date());
        this.umcEnterpriseInfoModel.updateEnterpriseBank(updateEnterBank);
    }

    private UmcEnterpriseAccountDo setAddEnterpriseAccount(List<UmcEnterpriseAccountDo> addEnterpriseAccountList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, long orgId) {
        UmcEnterpriseAccountDo addEnterpriseAccount = new UmcEnterpriseAccountDo();
        addEnterpriseAccount.setAccountId(IdUtil.nextId());
        addEnterpriseAccount.setTenantId(this.tenantId);
        addEnterpriseAccount.setOrgId(orgId);
        addEnterpriseAccount.setAccountName(supplierInfo.getOrgName() + "\u8d26\u5957");
        addEnterpriseAccount.setAccountType("01");
        addEnterpriseAccount.setIsShadowAccount("0");
        addEnterpriseAccount.setCheckStatus("1");
        addEnterpriseAccount.setAccountOwner("COMPANY");
        addEnterpriseAccount.setDelFlag("0");
        addEnterpriseAccount.setCreateOperId(UmcCommConstant.System.ID);
        addEnterpriseAccount.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addEnterpriseAccount.setCreateTime(new Date());
        addEnterpriseAccountList.add(addEnterpriseAccount);
        return addEnterpriseAccount;
    }

    private UmcEnterpriseAccountDo setUpdateEnterpriseAccount(Map<Long, UmcEnterpriseAccountDo> enterpriseAccountMap, UmcDealSupplierInfoAndUserInfoBO supplierInfo, UmcOrgInfo orgInfo) {
        UmcEnterpriseAccountDo updateEnterpriseAccount = enterpriseAccountMap.get(orgInfo.getOrgId());
        updateEnterpriseAccount.setAccountName(supplierInfo.getOrgName() + "\u8d26\u5957");
        updateEnterpriseAccount.setTenantId(this.tenantId);
        updateEnterpriseAccount.setOrgId(orgInfo.getOrgId());
        updateEnterpriseAccount.setDelFlag("0");
        updateEnterpriseAccount.setUpdateOperId(UmcCommConstant.System.ID);
        updateEnterpriseAccount.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateEnterpriseAccount.setUpdateTime(new Date());
        this.umcEnterpriseAccountModel.updateEnterpriseAccount(updateEnterpriseAccount);
        return updateEnterpriseAccount;
    }

    private void setAddInvoiceInfo(List<UmcInvoiceInfoDo> addInvoiceInfoList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, long orgId, UmcEnterpriseAccountDo addEnterpriseAccount, Long invoiceId) {
        UmcInvoiceInfoDo addInvoiceInfoDo = new UmcInvoiceInfoDo();
        addInvoiceInfoDo.setInvoiceId(invoiceId);
        addInvoiceInfoDo.setAccountId(addEnterpriseAccount.getAccountId());
        addInvoiceInfoDo.setOrgId(orgId);
        addInvoiceInfoDo.setInvoiceTitle(supplierInfo.getOrgName());
        addInvoiceInfoDo.setTaxpayerId(supplierInfo.getCreditNo());
        addInvoiceInfoDo.setBank(supplierInfo.getBankName());
        addInvoiceInfoDo.setAccount(supplierInfo.getBankAccount());
        addInvoiceInfoDo.setAddress(supplierInfo.getAddress());
        addInvoiceInfoDo.setPhone(supplierInfo.getTelephone());
        addInvoiceInfoDo.setContact(supplierInfo.getCustName());
        addInvoiceInfoDo.setContactPhone(supplierInfo.getRegMobile());
        addInvoiceInfoDo.setContactMail(supplierInfo.getRegEmail());
        addInvoiceInfoDo.setInvoiceType("00");
        addInvoiceInfoDo.setInvoiceClass("0");
        addInvoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.YES);
        addInvoiceInfoDo.setTitleType("COMPANY");
        addInvoiceInfoDo.setDelFlag("0");
        addInvoiceInfoDo.setCreateOperId(UmcCommConstant.System.ID);
        addInvoiceInfoDo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addInvoiceInfoDo.setCreateTime(new Date());
        addInvoiceInfoList.add(addInvoiceInfoDo);
    }

    private void setUpdateInvoiceInfo(Map<Long, UmcInvoiceInfoDo> invoiceInfoMap, UmcDealSupplierInfoAndUserInfoBO supplierInfo, UmcOrgInfo orgInfo, UmcEnterpriseAccountDo updateEnterpriseAccount) {
        UmcInvoiceInfoDo updateInvoiceInfo = invoiceInfoMap.get(orgInfo.getOrgId());
        updateInvoiceInfo.setAccountId(updateEnterpriseAccount.getAccountId());
        updateInvoiceInfo.setOrgId(orgInfo.getOrgId());
        updateInvoiceInfo.setInvoiceTitle(supplierInfo.getOrgName());
        updateInvoiceInfo.setTaxpayerId(supplierInfo.getCreditNo());
        updateInvoiceInfo.setBank(supplierInfo.getBankName());
        updateInvoiceInfo.setAccount(supplierInfo.getBankAccount());
        updateInvoiceInfo.setAddress(supplierInfo.getAddress());
        updateInvoiceInfo.setPhone(supplierInfo.getTelephone());
        updateInvoiceInfo.setContact(supplierInfo.getCustName());
        updateInvoiceInfo.setContactPhone(supplierInfo.getRegMobile());
        updateInvoiceInfo.setContactMail(supplierInfo.getRegEmail());
        updateInvoiceInfo.setInvoiceType("00");
        updateInvoiceInfo.setInvoiceClass("0");
        updateInvoiceInfo.setMainFlag(UmcCommConstant.EntInvMainFlag.YES);
        updateInvoiceInfo.setTitleType("COMPANY");
        updateInvoiceInfo.setDelFlag("0");
        updateInvoiceInfo.setUpdateOperId(UmcCommConstant.System.ID);
        updateInvoiceInfo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateInvoiceInfo.setUpdateTime(new Date());
        this.umcInvoiceInfoModel.updateInvoiceInfo(updateInvoiceInfo);
    }

    private void setAddCustInfo(List<UmcCustInfo> addCustInfoList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, Long custId) {
        UmcCustInfo addCustInfo = new UmcCustInfo();
        addCustInfo.setCustId(custId);
        addCustInfo.setRegAccount(supplierInfo.getRegAccount());
        addCustInfo.setRegMobile(supplierInfo.getRegMobile());
        addCustInfo.setRegEmail(supplierInfo.getRegEmail());
        addCustInfo.setCustStatus(supplierInfo.getCustStatus());
        addCustInfo.setCustNickname(supplierInfo.getCustName());
        addCustInfo.setOfficePhone(supplierInfo.getOfficePhone());
        addCustInfo.setCustName(supplierInfo.getCustName());
        addCustInfo.setDelFlag("0");
        addCustInfo.setIsPasswdValid("0");
        addCustInfo.setStopStatus("01");
        addCustInfo.setCustAffiliation("01");
        addCustInfo.setCustType("2");
        addCustInfo.setCustClassify("2");
        addCustInfo.setMaxRepeatLoginNum(5);
        addCustInfo.setIsOnline("0");
        addCustInfo.setIsBlacklist("0");
        addCustInfo.setCreateOperId(UmcCommConstant.System.ID);
        addCustInfo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addCustInfo.setCreateTime(new Date());
        addCustInfoList.add(addCustInfo);
    }

    private void setUpdateCustInfo(List<UmcCustInfo> updateCustInfoList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, Long custId) {
        UmcCustInfo updateCustInfo = new UmcCustInfo();
        updateCustInfo.setCustId(custId);
        updateCustInfo.setRegMobile(supplierInfo.getRegMobile());
        updateCustInfo.setRegEmail(supplierInfo.getRegEmail());
        updateCustInfo.setCustStatus(supplierInfo.getCustStatus());
        updateCustInfo.setOfficePhone(supplierInfo.getOfficePhone());
        updateCustInfo.setCustName(supplierInfo.getCustName());
        updateCustInfo.setDelFlag("0");
        updateCustInfo.setUpdateOperId(UmcCommConstant.System.ID);
        updateCustInfo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        updateCustInfo.setUpdateTime(new Date());
        updateCustInfoList.add(updateCustInfo);
        this.umcUserInfoModel.updateCustInfo(updateCustInfo);
    }

    private UmcUserInfoDo setAddUserInfo(List<UmcUserInfoDo> addUserInfoList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, UmcOrgInfo orgInfo, Long custId, String isMain) {
        UmcUserInfoDo addUserInfoBo = new UmcUserInfoDo();
        addUserInfoBo.setUserId(IdUtil.nextId());
        addUserInfoBo.setCustId(custId);
        addUserInfoBo.setMainCustId(custId);
        addUserInfoBo.setTenantId(this.tenantId);
        addUserInfoBo.setOrgId(orgInfo.getOrgId());
        addUserInfoBo.setCompanyId(orgInfo.getCompanyId());
        addUserInfoBo.setOrgTreePath(orgInfo.getOrgTreePath());
        addUserInfoBo.setUserType(supplierInfo.getUserType());
        addUserInfoBo.setAuthorityType(AUTH_TYPE);
        addUserInfoBo.setIsMain(isMain);
        addUserInfoBo.setStopStatus(supplierInfo.getStopStatus());
        addUserInfoBo.setDelFlag("0");
        addUserInfoBo.setCreateOperId(UmcCommConstant.System.ID);
        addUserInfoBo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addUserInfoBo.setCreateTime(new Date());
        addUserInfoBo.setOrgName(supplierInfo.getOrgName());
        addUserInfoBo.setRegAccount(supplierInfo.getRegAccount());
        addUserInfoBo.setCustName(supplierInfo.getCustName());
        addUserInfoList.add(addUserInfoBo);
        return addUserInfoBo;
    }

    private void setAddUserTagInfo(List<UmcUserTagRel> addUserTagRelList, UmcUserInfoDo addUserInfoBo) {
        UmcUserTagRel addUserTagBO = new UmcUserTagRel();
        addUserTagBO.setRelId(IdUtil.nextId());
        addUserTagBO.setUserId(addUserInfoBo.getUserId());
        addUserTagBO.setTenantId(this.tenantId);
        addUserTagBO.setTagId("2");
        addUserTagBO.setIsDefalt("1");
        addUserTagBO.setDelFlag("0");
        addUserTagBO.setCreateOperId(UmcCommConstant.System.ID);
        addUserTagBO.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addUserTagBO.setCreateTime(new Date());
        addUserTagRelList.add(addUserTagBO);
    }

    private void setAddOrgTagInfo(List<UmcOrgTagRel> addOrgRelList, long orgId) {
        UmcOrgTagRel addOrgTagRel = new UmcOrgTagRel();
        addOrgTagRel.setRelId(IdUtil.nextId());
        addOrgTagRel.setOrgId(orgId);
        addOrgTagRel.setTenantId(this.tenantId);
        addOrgTagRel.setTagId("2");
        addOrgTagRel.setTagStatus("1");
        addOrgTagRel.setDelFlag("0");
        addOrgTagRel.setCreateOperId(UmcCommConstant.System.ID);
        addOrgTagRel.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addOrgTagRel.setCreateTime(new Date());
        addOrgRelList.add(addOrgTagRel);
    }

    private void setAddUserRoleInfo(List<UmcUserRoleRel> addUserRoleRelList, UmcDealSupplierInfoAndUserInfoBO supplierInfo, UmcUserInfoDo addUserInfoBo) {
        UmcUserRoleRel addUserRoleRel = new UmcUserRoleRel();
        addUserRoleRel.setRelId(IdUtil.nextId());
        addUserRoleRel.setUserId(addUserInfoBo.getUserId());
        addUserRoleRel.setTenantId(this.tenantId);
        if ("5".equals(supplierInfo.getOrgClass())) {
            addUserRoleRel.setRoleId(this.defaultOnlineRoleId);
        } else {
            addUserRoleRel.setRoleId(this.defaultArgRoleId);
        }
        addUserRoleRel.setTagId("2");
        addUserRoleRel.setDelFlag("0");
        addUserRoleRel.setCreateOperId(UmcCommConstant.System.ID);
        addUserRoleRel.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        addUserRoleRel.setCreateTime(new Date());
        addUserRoleRelList.add(addUserRoleRel);
    }

    private Long getNowCustId(String regAccount) {
        UmcCustInfoQryBo custInfoQryBo = new UmcCustInfoQryBo();
        custInfoQryBo.setRegAccount(regAccount);
        UmcCustInfo custInfo = this.umcUserInfoModel.getCustInfo(custInfoQryBo);
        return custInfo.getCustId();
    }

    private void delOldSupAdmin(Long custId, List<Long> delCustIdList) {
        UmcCustInfo delCustInfo = new UmcCustInfo();
        delCustInfo.setCustId(custId);
        delCustInfo.setDelFlag("1");
        delCustInfo.setUpdateOperId(UmcCommConstant.System.ID);
        delCustInfo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        delCustInfo.setUpdateTime(new Date());
        this.umcUserInfoModel.updateCustInfo(delCustInfo);
        UmcUserInfoDo delUserInfo = new UmcUserInfoDo();
        delUserInfo.setCustId(custId);
        delUserInfo.setDelFlag("1");
        delUserInfo.setUpdateOperId(UmcCommConstant.System.ID);
        delUserInfo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        delUserInfo.setUpdateTime(new Date());
        this.umcUserInfoModel.updateUserInfo(delUserInfo);
        delCustIdList.add(custId);
    }

    void valDealData(UmcDealSupplierInfoAndUserInfoReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealSupplierInfoAndUserInfoBOList())) {
            throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getDealSupplierInfoAndUserInfoBOList().forEach(item -> {
            if (ObjectUtil.isEmpty((Object)item.getExtOrgId())) {
                throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u5916\u90e8\u4f9b\u5e94\u5546ID[extOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)item.getOrgName())) {
                throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u5916\u90e8\u4f9b\u5e94\u5546\u540d\u79f0[orgName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)item.getOrgClass())) {
                throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u673a\u6784\u7c7b\u522b[orgClass]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)item.getOrgType())) {
                throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u673a\u6784\u7c7b\u578b[orgType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)item.getRegAccount())) {
                throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u7528\u6237\u767b\u5f55\u540d[regAccount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)item.getCustName())) {
                throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u7528\u6237\u59d3\u540d[custName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)item.getRegMobile())) {
                throw new BaseBusinessException("200001", "\u5904\u7406\u4f9b\u5e94\u5546\u4fe1\u606f\u548c\u7528\u6237\u4fe1\u606f\u5165\u53c2\u7528\u6237\u624b\u673a\u53f7[regMobile]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

