/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.config.IUmcConfigModel;
import com.tydic.dyc.umc.model.config.qrybo.UmcOrgPublicDicConfigQryBo;
import com.tydic.dyc.umc.model.config.sub.UmcOrgPublicDicConfig;
import com.tydic.dyc.umc.model.config.sub.UmcOrgPublicDicConfigExt;
import com.tydic.dyc.umc.service.enterprise.UmcVerifyOrgBindJdPINService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcVerifyOrgBindJdPINReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcVerifyOrgBindJdPINRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcVerifyOrgBindJdPINService"})
public class UmcVerifyOrgBindJdPINServiceImpl
implements UmcVerifyOrgBindJdPINService {
    @Autowired
    private IUmcConfigModel iUmcConfigModel;
    private static final String JD_PIN_APP_MODE = "JD_PIN_APP_MODE";
    private static final String jdPin = "jdPin";
    private static final String jdPinPassword = "jdPinPassword";

    @PostMapping(value={"verifyOrgBindJdPIN"})
    public UmcVerifyOrgBindJdPINRspBO verifyOrgBindJdPIN(@RequestBody UmcVerifyOrgBindJdPINReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u6821\u9a8c\u8be5\u5355\u4f4d\u662f\u5426\u7ed1\u5b9a\u4eac\u4e1cPIN\u7801\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgIdWeb())) {
            throw new BaseBusinessException("200001", "\u6821\u9a8c\u8be5\u5355\u4f4d\u662f\u5426\u7ed1\u5b9a\u4eac\u4e1cPIN\u7801\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u4e3a\u7a7a");
        }
        UmcVerifyOrgBindJdPINRspBO rspBO = UmcRu.success(UmcVerifyOrgBindJdPINRspBO.class);
        UmcOrgPublicDicConfigQryBo dicConfigQryBo = new UmcOrgPublicDicConfigQryBo();
        dicConfigQryBo.setOrgId(reqBO.getOrgIdWeb());
        dicConfigQryBo.setPublicDicCode(JD_PIN_APP_MODE);
        UmcOrgPublicDicConfig dicConfig = this.iUmcConfigModel.qryOrgPublicDicConfigDetail(dicConfigQryBo);
        if (ObjectUtil.isEmpty((Object)dicConfig)) {
            rspBO.setBindResult(Boolean.FALSE);
            return rspBO;
        }
        rspBO.setBindResult(Boolean.TRUE);
        rspBO.setOrgId(dicConfigQryBo.getOrgId());
        if (ObjectUtil.isNotEmpty(dicConfig.getDicList())) {
            Map<String, UmcOrgPublicDicConfigExt> extMap = dicConfig.getDicList().stream().collect(Collectors.toMap(UmcOrgPublicDicConfigExt::getDicCode, e -> e, (e1, e2) -> e2));
            if (extMap.containsKey(jdPin)) {
                rspBO.setJdPin(extMap.get(jdPin).getDicValue());
            }
            if (extMap.containsKey(jdPinPassword)) {
                rspBO.setJdPinPassword(extMap.get(jdPinPassword).getDicValue());
            }
        }
        return rspBO;
    }
}

