package com.tydic.dyc.oc.service.businessrevenue.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题：UocQryBusinessRevenueListReqBo
 * 说明：营业收入统计表报表查询 入参
 * 时间：2023/09/26 17:30
 * 作者 zhoujie
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocQryBusinessRevenueListReqBo extends BaseReqBo {
    private static final long serialVersionUID = -1026695366006532437L;

    @DocField(
            value = "页码，默认1",
            required = true,
            defaultValue = "1"
    )
    private int pageNo = 1;
    @DocField(
            value = "每页数量，默认10",
            required = true,
            defaultValue = "10"
    )
    private int pageSize = 10;
    @DocField("排序字段名称(需要接口支持)")
    private String sortName;
    @DocField("排序顺序(需要接口支持，传值例如：asc、desc)")
    private String sortOrder;

    /**
     * 统计类别：1、商品池维度2、商品类目维度
     */
    private String businessRevenueType;

    /**
     * 年度
     */
    private Integer revenueYear;

    /**
     * 月度开始时间（1月、2月。。）
     */
    private Integer revenueMoonStart;

    /**
     * 月度结束时间（1月、2月。。）
     */
    private Integer revenueMoonEnd;

    /**
     * 门店id集合
     */
    private List<Long> orgIds;

    /**
     * 商品类别编码
     */
    private String categoryCode;
    /**
     * 商品类别名称
     */
    private String categoryName;
    /**
     * 商品品类id
     */
    private Long itemCatId;
    /**
     * 商品品类名称
     */
    private String itemCatName;
    /**
     * 一级商品品类ID
     */
    private Long itemCatOneId;
    /**
     * 一级商品品类名称
     */
    private String itemCatOneName;
    /**
     * 二级商品品类ID
     */
    private Long itemCatTwoId;
    /**
     * 二级商品品类名称
     */
    private String itemCatTwoName;



}
