package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocAfterOrderFinishConfirmReqBo
 * 说明:售后完成确认
 * 时间:2022-05-13 13:54:43
 * 作者:luoyou
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocAfterOrderFinishConfirmReqBo extends BaseReqBo {
	private static final long serialVersionUID = 974671034940661760L;

	/**
	 * 售后单ID
	 */
	private Long afOrderId;

	/**
	 * 订单ID
	 */
	private Long orderId;
	/**
	 * 任务id
	 */
	private String taskId;

	/**
	 * 1：供应商确认 0：采购方确认
	 */
	private Integer flag;

	/**
	 * 环节编码
	 */
	private String stepId;
    private Long userId;
	/**
	 * 物流执行单位id
	 */
	private String shipCompanyId;

	/**
	 * 物流执行单位名称
	 */
    private String shipCompanyName;

	/**
	 * 配送单号
	 */
	private String shipCode;

	/**
	 * 预计到货日期
	 */
	private Date sendTime;

	/**
	 * 发货日期
	 */
	private Date shipTime;

	/**
	 * 发货联系人
	 */
	private String shipName;

	/**
	 * 发货人电话
	 */
	private String shipPhone;

	/**
	 * 服务单类型  退货(10) 换货(20)  维修(30)
	 */
	private Integer servType;

	/**
	 * 销售单id
	 */
	private Long saleOrderId;


	/**
	 * 附件
	 * */
	private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;
}
