package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题:UocQryShipOrderDetailsRspDetailItemBo
 * 说明:发货明细信息
 * 时间:2022/3/14 15:26
 * 作者:罗有
 */

@Data
public class UocQryShipOrderDetailsRspDetailItemBo implements Serializable {
    private static final long serialVersionUID = -2548277411118302336L;

    @DocField(value = "发货明细id")
    private Long shipOrderItemId;

    @DocField(value = "执行明细id")
    private Long implOrderItemId;

    @DocField(value = "销售明细id")
    private Long saleOrderItemId;

    @DocField(value = "明细状态")
    private String shipItemState;

    @DocField(value = "明细状态翻译")
    private String shipItemStateStr;

    @DocField(value = "计量单位")
    private String unitName;

    @DocField(value = "发货数量")
    private BigDecimal sendCount;

    @DocField(value = "到货数量             供应商到货登记时预留字段")
    private BigDecimal arriveCount;

    @DocField(value = "拒收数量")
    private BigDecimal refuseCount;

    @DocField(value = "退货数量")
    private BigDecimal returnCount;

    @DocField(value = "售后中数量")
    private BigDecimal afterServingCount;

    @DocField(value = "可售后数量")
    private BigDecimal availableAfServCount;

    @DocField(value = "验收数量")
    private BigDecimal inspCount;
    
    @DocField(value = "验收销售金额（验收数量*销售单价）")
    private BigDecimal inspSaleFee;

    @DocField(value = "异常变更在途数量，表示异常供应商确认之前的记录数量")
    private BigDecimal chngingCount;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "单品ID")
    private String skuId;

    @DocField(value = "单品名称")
    private String skuName;

    @DocField(value = "商品名称")
    private String commodityName;

    @DocField(value = "商品ID")
    private String commodityId;

    @DocField(value = "采购数量")
    private BigDecimal purchaseCount;

    @DocField(value = "采购金额")
    private BigDecimal purchaseFee;

    @DocField(value = "销售金额")
    private BigDecimal saleFee;

    @DocField(value = "采购金额")
    private BigDecimal purchasePrice;

    @DocField(value = "销售金额")
    private BigDecimal salePrice;

    @DocField(value = "税金")
    private String taxPrice;

    @DocField(value = "税率")
    private String tax;

    @DocField(value = "sku物料编码")
    private String skuMaterialId;

    @DocField(value = "sku外部单品id")
    private String skuExtSkuId;

    @DocField(value = "sku品牌id")
    private Long skuBrandId;

    @DocField(value = "供应商id")
    private String supplierId;

    @DocField(value = "店铺id")
    private String supplierShopId;

    @DocField(value = "单品品牌名称")
    private String skuBrandName;

    @DocField(value = "sku明细id")
    private String skuItemId;

    @DocField(value = "sku物料名称")
    private String skuMaterialName;

    @DocField(value = "sku物料类型名称")
    private String skuMaterialTypeName;

    @DocField(value = "sku物料类型id")
    private String skuMaterialTypeId;

    @DocField(value = "型号")
    private String model;

    @DocField(value = "规格")
    private String spec;

    @DocField(value = "材质")
    private String texture;

    @DocField(value = "图号")
    private String figure;

    @DocField(value = "一级类目")
    private Long l1Catalog;

    @DocField(value = "二级类目")
    private Long l2Catalog;

    @DocField(value = "三级类目")
    private Long l3Catalog;

    @DocField(value = "一级类目名称")
    private String l1CatalogName;

    @DocField(value = "二级类目名称")
    private String l2CatalogName;

    @DocField(value = "三级类目名称")
    private String l3CatalogName;

    @DocField(value = "sku单品主图url")
    private String skuMainPicUrl;

    /**
     * 计量单位位数
     */
    private String unitDigit;

    /**
     * 仅退款数量
     */
    private BigDecimal refundNum;
}
