package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.oc.service.common.bo.UocOrderAccessoryBO;
import com.tydic.dyc.oc.service.common.bo.UocQryAccessoryListRspBO;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题 UocReissueBO
 * 说明 补发发货单BO
 * 时间 2023/10/27 15:24
 *
 * @author 唐富强
 */
@Data
public class UocReissueBO implements Serializable {


    private static final long serialVersionUID = 5884381400832444906L;
    /**
     * 快递单号
     */
    private String logisticsNo;

    /**
     * 预计到货日期
     */
    private Date arrivalTime;

    /**
     * 发货单编号
     */
    private String deliveryOrderNo;

    /**
     * 供应商名称
     */
    private String supName;

    /**
     * 发货联系人
     */
    private String deliveryContact;

    /**
     * 联系人电话
     */
    private String deliveryContactPhone;

    /**
     * 发货单状态
     */
    private String deliveryOrderStateStr;

    /**
     * 发货日期
     */
    private Date deliveryTime;

    /**
     * 销售单编号
     */
    private String saleOrderNo;

    /**
     * 订单来源
     */
    private Integer orderSource;

    /**
     * 物流公司编码
     */
    private String shipCompanyId;
    /**
     * 物流公司名称
     */
    private String shipCompanyName;

    /**
     * 发货附件
     */
    private List<UocOrderAccessoryBO> shipAccessoryList;

    /**
     * 发货明细
     */
    private List<UocReissueItemBO> deliveryOrderCommodityInfo;
}
