package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题 UocReissueItemBO
 * 说明 补发发货单明细BO
 * 时间 2023/10/27 15:40
 *
 * @author 唐富强
 */
@Data
public class UocReissueItemBO implements Serializable {


    private static final long serialVersionUID = -4603899803616263714L;
    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;

    /**
     * 发货数量
     */
    private BigDecimal deliveryCount;

    /**
     * 采购金额
     */
    private BigDecimal purFee;

    /**
     * 采购单价
     */
    private BigDecimal purPrice;

    /**
     * 税率
     */
    private String rate;

    /**
     * 销售金额
     */
    private BigDecimal saleFee;

    /**
     * 销售单价
     */
    private BigDecimal salePrice;
    /**
     * 商品名称
     */
    private String skuName;
    /**
     * 商品编码
     */
    private String skuCode;
    /**
     * 商品主图
     */
    private String skuMainPic;

    /**
     * skuId
     */
    private String skuId;

    /**
     * 供应商ID
     */
    private String supplierId;
    /**
     * 店铺ID
     */
    private String supplierShopId;

    /**
     * 物料分类id
     */
    private String materialClassifyId;
    /**
     * 物料分类名称
     */
    private String materialClassifyName;
    /**
     * 物料编码
     */
    private String materialCode;
    /**
     * 物料名称
     */
    private String materialName;

    /**
     * 销售计量单位
     */
    private String saleUnit;

    //商品编码
    private String commodityCode;

    /**
     * 商品类型id
     */
    private String commodityTypeId;
}
