package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocAuditOrderPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocAuditOrderMapper
 * 说明:审批单表
 * 时间:2022-03-10 10:33
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocAuditOrderMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocAuditOrderPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocAuditOrderPo uocAuditOrderPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocAuditOrderPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocAuditOrderPo uocAuditOrderPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocAuditOrderPo set, @Param("where") UocAuditOrderPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocAuditOrderPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocAuditOrderPo uocAuditOrderPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocAuditOrderPo 参数对象
	 * @return UocAuditOrderPo 结果对象
	 */
	UocAuditOrderPo getModelBy(UocAuditOrderPo uocAuditOrderPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocAuditOrderPo 参数对象
	 * @return List<UocAuditOrderPo> 结果对象
	 */
	List<UocAuditOrderPo> getList(UocAuditOrderPo uocAuditOrderPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocAuditOrderPo 参数对象
	 * @param page            分页参数
	 * @return List<UocAuditOrderPo> 结果对象
	 */
	List<UocAuditOrderPo> getListPage(UocAuditOrderPo uocAuditOrderPo, Page<UocAuditOrderPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocAuditOrderPo> list);

}
