package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenueBreedPO;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenuePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：营业收入商品品种统计
 * 
 * @author SuJingchun
 * @date 2023-10-25 21:09
 **/
@Mapper
@Repository
public interface UocBusinessRevenueBreedMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBusinessRevenueBreedPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBusinessRevenueBreedPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBusinessRevenueBreedPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBusinessRevenueBreedPO set, @Param("where") UocBusinessRevenueBreedPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBusinessRevenueBreedPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBusinessRevenueBreedPo 参数对象
	 * @return UocBusinessRevenueBreedPO 结果对象
	 */
	UocBusinessRevenueBreedPO getModelBy(UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBusinessRevenueBreedPo 参数对象
	 * @return List<UocBusinessRevenueBreedPO> 结果对象
	 */
	List<UocBusinessRevenueBreedPO> getList(UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBusinessRevenueBreedPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBusinessRevenueBreedPO> 结果对象
	 */
	List<UocBusinessRevenueBreedPO> getListPage(UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo, Page<UocBusinessRevenueBreedPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBusinessRevenueBreedPO> list);

    List<UocBusinessRevenueBreedPO> qryBusinessRevenueBreedCount(UocBusinessRevenuePO qryUocBusinessRevenueBreedPo);

}
