package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.BusinessRevenue.qrybo.UocBusinessRevenueOrderInfoQryBo;
import com.tydic.dyc.oc.model.BusinessRevenue.sub.UocBusinessRevenueOrderInfoSbu;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenuePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：营收收入统计总表
 * 
 * @author SuJingchun
 * @date 2023-10-25 21:09
 **/
@Mapper
@Repository
public interface UocBusinessRevenueMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBusinessRevenuePo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBusinessRevenuePO uocBusinessRevenuePo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBusinessRevenuePo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBusinessRevenuePO uocBusinessRevenuePo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBusinessRevenuePo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(UocBusinessRevenuePO uocBusinessRevenuePo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBusinessRevenuePO set, @Param("where") UocBusinessRevenuePO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBusinessRevenuePo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBusinessRevenuePO uocBusinessRevenuePo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBusinessRevenuePo 参数对象
	 * @return UocBusinessRevenuePO 结果对象
	 */
	UocBusinessRevenuePO getModelBy(UocBusinessRevenuePO uocBusinessRevenuePo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBusinessRevenuePo 参数对象
	 * @return List<UocBusinessRevenuePO> 结果对象
	 */
	List<UocBusinessRevenuePO> getList(UocBusinessRevenuePO uocBusinessRevenuePo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBusinessRevenuePo 参数对象
	 * @param page 分页参数
	 * @return List<UocBusinessRevenuePO> 结果对象
	 */
	List<UocBusinessRevenuePO> getListPage(UocBusinessRevenuePO uocBusinessRevenuePo, Page<UocBusinessRevenuePO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBusinessRevenuePO> list);

    List<UocBusinessRevenuePO> getListJsonPage(UocBusinessRevenuePO uocBusinessRevenuePo, Page<UocBusinessRevenuePO> page);

    List<UocBusinessRevenuePO> qryUocBusinessRevenueMoonPoCount(UocBusinessRevenuePO qryUocBusinessRevenuePO);

    List<UocBusinessRevenueOrderInfoSbu> qryUocSaleOrderItemSbuList(UocBusinessRevenueOrderInfoQryBo qryBo);

	List<UocBusinessRevenuePO> getPurItemListJsonPage(UocBusinessRevenuePO uocBusinessRevenuePo, Page<UocBusinessRevenuePO> page);
}
