package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenueMoonPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：营业收入每月统计详细表
 * 
 * @author SuJingchun
 * @date 2023-10-25 21:09
 **/
@Mapper
@Repository
public interface UocBusinessRevenueMoonMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBusinessRevenueMoonPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBusinessRevenueMoonPO uocBusinessRevenueMoonPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBusinessRevenueMoonPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBusinessRevenueMoonPO uocBusinessRevenueMoonPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBusinessRevenueMoonPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(UocBusinessRevenueMoonPO uocBusinessRevenueMoonPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBusinessRevenueMoonPO set, @Param("where") UocBusinessRevenueMoonPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBusinessRevenueMoonPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBusinessRevenueMoonPO uocBusinessRevenueMoonPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBusinessRevenueMoonPo 参数对象
	 * @return UocBusinessRevenueMoonPO 结果对象
	 */
	UocBusinessRevenueMoonPO getModelBy(UocBusinessRevenueMoonPO uocBusinessRevenueMoonPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBusinessRevenueMoonPo 参数对象
	 * @return List<UocBusinessRevenueMoonPO> 结果对象
	 */
	List<UocBusinessRevenueMoonPO> getList(UocBusinessRevenueMoonPO uocBusinessRevenueMoonPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBusinessRevenueMoonPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBusinessRevenueMoonPO> 结果对象
	 */
	List<UocBusinessRevenueMoonPO> getListPage(UocBusinessRevenueMoonPO uocBusinessRevenueMoonPo, Page<UocBusinessRevenueMoonPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBusinessRevenueMoonPO> list);

}
