package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.repository.po.UocInspOrderItemPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocInspOrderItemMapper
 * 说明:验收明细
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocInspOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocInspOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocInspOrderItemPo uocInspOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocInspOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocInspOrderItemPo uocInspOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocInspOrderItemPo set, @Param("where") UocInspOrderItemPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocInspOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocInspOrderItemPo uocInspOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocInspOrderItemPo 参数对象
	 * @return UocInspOrderItemPo 结果对象
	 */
	UocInspOrderItemPo getModelBy(UocInspOrderItemPo uocInspOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocInspOrderItemPo 参数对象
	 * @return List<UocInspOrderItemPo> 结果对象
	 */
	List<UocInspOrderItemPo> getList(UocInspOrderItemPo uocInspOrderItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocInspOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocInspOrderItemPo> 结果对象
	 */
	List<UocInspOrderItemPo> getListPage(UocInspOrderItemPo uocInspOrderItemPo, Page<UocInspOrderItemPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocInspOrderItemPo> list);

    void modifyInspOrderItemChngingCount(@Param("list")List<UocInspOrderItem> inspOrderItems,@Param("uocInspOrderItem") UocInspOrderItem uocInspOrderItem);

    void modifyItemChngCountRefuse(UocInspOrderItem uocInspOrderItem);

	void modifyItemChngCountConfirm(UocInspOrderItem uocInspOrderItem);

	void modifyBatchItemInspConfirm(UocInspOrderItem uocInspOrderItem);

	void updateInspItemRate(UocInspOrderItemPo uocInspOrderItemPo);
}
