package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.BusinessRevenue.qrybo.UocBusinessRevenueOrderInfoQryBo;
import com.tydic.dyc.oc.model.BusinessRevenue.qrybo.UocJyShopQuotaQryBo;
import com.tydic.dyc.oc.model.BusinessRevenue.sub.UocBusinessRevenueOrderInfoSbu;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenuePO;
import com.tydic.dyc.oc.repository.po.UocJyShopQuotaPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：门店配额表
 * 
 * @author SuJingchun
 * @date 2023-10-25 21:09
 **/
@Mapper
@Repository
public interface UocJyShopQuotaMapper {
	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocJyShopQuotaPO 参数对象
	 * @return List<UocJyShopQuotaPO> 结果对象
	 */
	List<UocJyShopQuotaPO> getList(UocJyShopQuotaPO uocJyShopQuotaPO);
	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocJyShopQuotaPO 参数对象
	 * @param page 分页参数
	 * @return List<uocJyShopQuotaPO> 结果对象
	 */
	List<UocJyShopQuotaPO> getListPage(UocJyShopQuotaPO uocJyShopQuotaPO, Page<UocJyShopQuotaPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocJyShopQuotaPO> list);
	/**
	 * 根据条件删除数据
	 *
	 * @param uocJyShopQuotaPO 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocJyShopQuotaPO uocJyShopQuotaPO);
	/**
	 * 统计数量
	 * @date 2023/11/8 10:19
	 */
	Integer qryQuotaCount(UocJyShopQuotaPO uocJyShopQuotaPO);
}
