package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.repository.UocAfOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocAfOrderRepositoryImpl
 * 说明:售后单
 * 时间:2022/2/21 18:54
 * 作者:罗有
 */

@Service
public class UocAfOrderRepositoryImpl implements UocAfOrderRepository {

    @Autowired
    private UocAfOrderMapper uocAfOrderMapper;
    @Autowired
    private UocAfOrderMapMapper uocAfOrderMapMapper;
    @Autowired
    private UocAfOrderObjMapper uocAfOrderObjMapper;
    @Autowired
    private UocAfOrderItemMapper uocAfOrderItemMapper;
    @Autowired
    private UocAfItemMapMapper uocAfItemMapMapper;
    @Autowired
    private UocAfOrderWaybillMapper uocAfOrderWaybillMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrdLogisticsRelaMapper uocOrdLogisticsRelaMapper;

    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        List<UocAfOrderItemPo> list = uocAfOrderItemMapper.getList(UocRu.js(uocAfOrderItemQryBo, UocAfOrderItemPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderItem.class) : new ArrayList<>();
    }

    @Override
    public UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo) {
        UocAfOrderPo uocAfOrderPo = new UocAfOrderPo();
        uocAfOrderPo.setAfOrderId(uocAfOrderQryBo.getAfOrderId());
        if (ObjectUtil.isNotNull(uocAfOrderQryBo.getOrderId())) {
            uocAfOrderPo.setOrderId(uocAfOrderQryBo.getOrderId());
        }
        uocAfOrderPo = uocAfOrderMapper.getModelBy(uocAfOrderPo);
        return null != uocAfOrderPo ? UocRu.js(uocAfOrderPo, UocAfOrder.class) : null;
    }

    @Override
    public List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo) {
        List<UocAfOrderPo> list = uocAfOrderMapper.getList(UocRu.js(uocAfOrderQryBo, UocAfOrderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrder.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo) {
        List<UocAfOrderObjPo> list = uocAfOrderObjMapper.getList(UocRu.js(uocAfOrderObjQryBo, UocAfOrderObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo) {
        List<UocAfOrderMapPo> list = uocAfOrderMapMapper.getList(UocRu.js(uocAfOrderMapQryBo, UocAfOrderMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderMap.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo) {
        List<UocAfOrderWaybillPo> list = uocAfOrderWaybillMapper.getList(UocRu.js(uocAfOrderWaybillQryBo, UocAfOrderWaybillPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderWaybill.class) : new ArrayList<>();
    }

    @Override
    public void modifyAfOrder(UocAfOrderDo uocAfOrderDo) {
        UocAfOrderPo where = new UocAfOrderPo();
        where.setAfOrderId(uocAfOrderDo.getAfOrderId());
        uocAfOrderMapper.updateBy(UocRu.js(uocAfOrderDo, UocAfOrderPo.class), where);
    }

    @Override
    public UocAfOrderDo saveAfterOder(UocAfOrderDo afOrderDo) {
        UocAfOrderPo uocAfOrderPo = UocRu.js(afOrderDo, UocAfOrderPo.class);
        uocAfOrderMapper.insert(uocAfOrderPo);
        List<UocAfOrderMap> extParallelBoList = afOrderDo.getExtParallelBoList();
        if (ObjectUtil.isNotEmpty(extParallelBoList)) {
            uocAfOrderMapMapper.insertBatch(UocRu.jsl(extParallelBoList, UocAfOrderMapPo.class));
        }
        uocAfOrderObjMapper.insertBatch(UocRu.jsl(afOrderDo.getAfOrderObjList(), UocAfOrderObjPo.class));
        List<UocAfOrderItem> afOrderItemBoList = afOrderDo.getAfOrderItemBoList();
        if (ObjectUtil.isNotEmpty(afOrderItemBoList)) {
            uocAfOrderItemMapper.insertBatch(UocRu.jsl(afOrderItemBoList, UocAfOrderItemPo.class));
        }

        List<UocOrderAccessory> orderAccessoryBoList = afOrderDo.getOrderAccessoryBoList();
        if (ObjectUtil.isNotEmpty(orderAccessoryBoList)) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(orderAccessoryBoList, UocOrderAccessoryPo.class));
        }
        UocOrdLogisticsRela takeAddress = afOrderDo.getTakeAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            uocOrdLogisticsRelaMapper.insert(UocRu.js(takeAddress, UocOrdLogisticsRelaPo.class));
        }
        UocOrdLogisticsRela returnAddress = afOrderDo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            uocOrdLogisticsRelaMapper.insert(UocRu.js(returnAddress, UocOrdLogisticsRelaPo.class));
        }
        return afOrderDo;
    }


    @Override
    public List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo) {
        List<UocAfItemMapPo> list = uocAfItemMapMapper.getList(UocRu.js(uocAfItemMapQryBo, UocAfItemMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfItemMap.class) : new ArrayList<>();
    }

    @Override
    public void modifyBatchAfOrderRemark(List<UocAfOrderDo> uocAfOrderDoList) {
        if (!CollectionUtils.isEmpty(uocAfOrderDoList)) {
            uocAfOrderMapper.updateBatch(UocRu.jsl(uocAfOrderDoList, UocAfOrderPo.class), UocRu.js(uocAfOrderDoList.get(0), UocAfOrderPo.class));
            List<UocOrdLogisticsRela> uocOrdLogisticsRelas = new ArrayList<>();
            for (UocAfOrderDo uocAfOrderDo : uocAfOrderDoList) {
                if (null!=uocAfOrderDo.getReturnAddress()&&null!=uocAfOrderDo.getReturnAddress().getContactId()){
                   uocOrdLogisticsRelas.add(uocAfOrderDo.getReturnAddress());
                }
            }
            if (!CollectionUtils.isEmpty(uocOrdLogisticsRelas)) {
                uocOrdLogisticsRelaMapper.insertBatch(UocRu.jsl(uocOrdLogisticsRelas, UocOrdLogisticsRelaPo.class));
            }
        }
    }

    @Override
    public void modifyAfOrderExtOrderId(UocAfOrderDo afOrderDo) {
        uocAfOrderMapper.updateExtId(UocRu.js(afOrderDo, UocAfOrderPo.class));

    }

    @Override
    public void saveAfOrderWayBill(UocAfOrderWaybill uocAfOrderWaybill) {
        if (ObjectUtil.isNotEmpty(uocAfOrderWaybill)) {
            uocAfOrderWaybillMapper.insert(UocRu.js(uocAfOrderWaybill, UocAfOrderWaybillPo.class));
            UocAfOrderPo set = new UocAfOrderPo();
            set.setWaybillFlag(0);
            UocAfOrderPo where = new UocAfOrderPo();
            where.setAfOrderId(uocAfOrderWaybill.getAfOrderId());
            uocAfOrderMapper.updateBy(set, where);
        }
    }

    @Override
    public void modifyAfOrderState(UocAfOrderDo afOrderDo) {
        uocAfOrderMapper.updateStateId(UocRu.js(afOrderDo, UocAfOrderPo.class));
    }
    
    @Override
    public List<UocAfOrderDo> getCheckAfOrders(UocAfOrderDo afOrderDo) {
        List<UocAfOrderPo> uocAfOrderPos = uocAfOrderMapper.getCheckAfOrders(UocRu.js(afOrderDo, UocAfOrderPo.class));
        return UocRu.jsl(uocAfOrderPos,UocAfOrderDo.class);
    }

    /**
     * 添加售后扩展信息
     * @param list
     */
    @Override
    public void addAfOrderMap(List<UocAfOrderMap> list) {
        uocAfOrderMapMapper.insertBatch(UocRu.jsl(list, UocAfOrderMapPo.class));
    }

    /**
     * 售后扩展信息查询
     * @param record
     * @return
     */
    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMap record) {
        return UocRu.jsl(uocAfOrderMapMapper.getList(UocRu.js(record,UocAfOrderMapPo.class)),UocAfOrderMap.class);
    }

}
