package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.BusinessRevenue.UocBusinessRevenueDo;
import com.tydic.dyc.oc.model.BusinessRevenue.qrybo.UocBusinessRevenueBreedQryBo;
import com.tydic.dyc.oc.model.BusinessRevenue.qrybo.UocBusinessRevenueOrderInfoQryBo;
import com.tydic.dyc.oc.model.BusinessRevenue.qrybo.UocBusinessRevenueQryBo;
import com.tydic.dyc.oc.model.BusinessRevenue.sub.UocBusinessRevenueBreedSub;
import com.tydic.dyc.oc.model.BusinessRevenue.sub.UocBusinessRevenueMoonSub;
import com.tydic.dyc.oc.model.BusinessRevenue.sub.UocBusinessRevenueOrderInfoSbu;
import com.tydic.dyc.oc.repository.UocBusinessRevenueRepository;
import com.tydic.dyc.oc.repository.dao.UocBusinessRevenueBreedMapper;
import com.tydic.dyc.oc.repository.dao.UocBusinessRevenueMapper;
import com.tydic.dyc.oc.repository.dao.UocBusinessRevenueMoonMapper;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenueBreedPO;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenueMoonPO;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenuePO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocBusinessRevenueRepositoryImpl
 * 说明:
 * 时间:2022/10/26 17:27
 * 作者:zhoujie
 */
@Service
public class UocBusinessRevenueRepositoryImpl implements UocBusinessRevenueRepository {

    @Autowired
    private UocBusinessRevenueMapper uocBusinessRevenueMapper;

    @Autowired
    private UocBusinessRevenueMoonMapper uocBusinessRevenueMoonMapper;
    @Autowired
    private UocBusinessRevenueBreedMapper uocBusinessRevenueBreedMapper;

    @Override
    public BasePageRspBo<UocBusinessRevenueDo> qryBusinessRevenueList(UocBusinessRevenueQryBo qryBo) {
        UocBusinessRevenuePO qryUocBusinessRevenuePo = JSON.parseObject(JSON.toJSONString(qryBo), UocBusinessRevenuePO.class);
        Page<UocBusinessRevenuePO> page = new Page<>(qryBo.getPageNo(), qryBo.getPageSize());
        List<UocBusinessRevenuePO> uocBusinessRevenuePos = uocBusinessRevenueMapper.getListJsonPage(qryUocBusinessRevenuePo, page);
        BasePageRspBo<UocBusinessRevenueDo> rspBo = new BasePageRspBo<>();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(uocBusinessRevenuePos) ? UocRu.jsl(uocBusinessRevenuePos, UocBusinessRevenueDo.class) : new ArrayList<>(0));
        return rspBo;
    }

    @Override
    public List<UocBusinessRevenueBreedSub> qryBusinessRevenueBreedCount(UocBusinessRevenueQryBo qryBo) {
        UocBusinessRevenuePO qryUocBusinessRevenuePo = UocRu.js(qryBo, UocBusinessRevenuePO.class);
        List<UocBusinessRevenueBreedPO> uocBusinessRevenueBreedPos = uocBusinessRevenueBreedMapper.qryBusinessRevenueBreedCount(qryUocBusinessRevenuePo);
        if(CollectionUtils.isEmpty(uocBusinessRevenueBreedPos)){
            return new ArrayList<>();
        }
        return UocRu.jsl(uocBusinessRevenueBreedPos, UocBusinessRevenueBreedSub.class);
    }

    @Override
    public List<UocBusinessRevenueDo> qryUocBusinessRevenueMoonPoCount(UocBusinessRevenueQryBo qryBo) {
        UocBusinessRevenuePO qryUocBusinessRevenuePo = UocRu.js(qryBo, UocBusinessRevenuePO.class);
        List<UocBusinessRevenuePO> uocBusinessRevenuePos = uocBusinessRevenueMapper.qryUocBusinessRevenueMoonPoCount(qryUocBusinessRevenuePo);
        if(CollectionUtils.isEmpty(uocBusinessRevenuePos)){
            return new ArrayList<>();
        }
        return UocRu.jsl(uocBusinessRevenuePos, UocBusinessRevenueDo.class);
    }

    @Override
    public UocBusinessRevenueDo qryUocBusinessRevenueDo(UocBusinessRevenueDo uocBusinessRevenueDo) {
        UocBusinessRevenuePO qryUocBusinessRevenuePo = UocRu.js(uocBusinessRevenueDo, UocBusinessRevenuePO.class);
        UocBusinessRevenuePO uocBusinessRevenuePo = uocBusinessRevenueMapper.getModelBy(qryUocBusinessRevenuePo);
        if(uocBusinessRevenuePo == null){
            return new UocBusinessRevenueDo();
        }
       return UocRu.js(uocBusinessRevenuePo, UocBusinessRevenueDo.class);
    }

    @Override
    public void updateUocBusinessRevenueBreed(UocBusinessRevenueBreedSub setPo, UocBusinessRevenueBreedSub wherePo) {
        UocBusinessRevenueBreedPO setBo = UocRu.js(setPo, UocBusinessRevenueBreedPO.class);
        UocBusinessRevenueBreedPO whereBo = UocRu.js(wherePo, UocBusinessRevenueBreedPO.class);
        uocBusinessRevenueBreedMapper.updateBy(setBo,whereBo);
    }

    @Override
    public List<UocBusinessRevenueOrderInfoSbu> qryUocSaleOrderItemSbuList(UocBusinessRevenueOrderInfoQryBo qryBo) {
        return uocBusinessRevenueMapper.qryUocSaleOrderItemSbuList(qryBo);
    }

    @Override
    public BasePageRspBo<UocBusinessRevenueDo> qryPurItemNumList(UocBusinessRevenueQryBo qryBo) {
        UocBusinessRevenuePO qryUocBusinessRevenuePo = JSON.parseObject(JSON.toJSONString(qryBo), UocBusinessRevenuePO.class);
        Page<UocBusinessRevenuePO> page = new Page<>(qryBo.getPageNo(), qryBo.getPageSize());
        List<UocBusinessRevenuePO> uocBusinessRevenuePos = uocBusinessRevenueMapper.getPurItemListJsonPage(qryUocBusinessRevenuePo, page);
        BasePageRspBo<UocBusinessRevenueDo> rspBo = new BasePageRspBo<>();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(uocBusinessRevenuePos) ? UocRu.jsl(uocBusinessRevenuePos, UocBusinessRevenueDo.class) : new ArrayList<>(0));
        return rspBo;
    }


    @Override
    public void insertUocBusinessRevenueDoBatch(List<UocBusinessRevenueDo> uocBusinessRevenueDo) {
        List<UocBusinessRevenuePO> insetUocBusinessRevenuePos = new ArrayList<>();
        List<UocBusinessRevenueMoonPO> insertUocBusinessRevenueMoonPos = new ArrayList<>();
        List<UocBusinessRevenueBreedPO> insertUocBusinessRevenueBreedPo = new ArrayList<>();
        List<Long> businessRevenueIds = new ArrayList<>();
        for (UocBusinessRevenueDo each : uocBusinessRevenueDo) {
            //根据年度、商品池或三级类目、统计类型查询主表是否存在
            UocBusinessRevenuePO qryUocBusinessRevenuePo = new UocBusinessRevenuePO();
            qryUocBusinessRevenuePo.setRevenueYear(each.getRevenueYear());
            qryUocBusinessRevenuePo.setBusinessRevenueType(each.getBusinessRevenueType());
            qryUocBusinessRevenuePo.setOrgId(each.getOrgId());
            if(each.getBusinessRevenueType().equals(UocDicConstant.BusinessRevenueType.POOL)){
                qryUocBusinessRevenuePo.setCategoryCode(each.getCategoryCode());
            }else {
                qryUocBusinessRevenuePo.setItemCatId(each.getItemCatId());
            }
            UocBusinessRevenuePO uocBusinessRevenueResultPo = uocBusinessRevenueMapper.getModelBy(qryUocBusinessRevenuePo);
            if(uocBusinessRevenueResultPo == null){
                //新增
                each.setBusinessRevenueId(IdUtil.nextId());
                each.setCreateTime(new Date());
                each.setDelFlag(UocDicConstant.DELETE_TAG.NO_DEL.toString());
                UocBusinessRevenuePO uocBusinessRevenuePo = UocRu.js(each, UocBusinessRevenuePO.class);
                insetUocBusinessRevenuePos.add(uocBusinessRevenuePo);
            }else {
                each.setBusinessRevenueId(uocBusinessRevenueResultPo.getBusinessRevenueId());
                businessRevenueIds.add(uocBusinessRevenueResultPo.getBusinessRevenueId());
            }
            //新增新的营业收入每月统计详细表集合
            if(each.getUocBusinessRevenueMoon() != null){
                UocBusinessRevenueMoonPO uocBusinessRevenueMoonPo = UocRu.js(each.getUocBusinessRevenueMoon(), UocBusinessRevenueMoonPO.class);
                uocBusinessRevenueMoonPo.setBusinessRevenueId(each.getBusinessRevenueId());
                uocBusinessRevenueMoonPo.setMoonId(IdUtil.nextId());
                uocBusinessRevenueMoonPo.setCreateTime(new Date());
                uocBusinessRevenueMoonPo.setDelFlag(UocDicConstant.DELETE_TAG.NO_DEL.toString());
                //年度
                uocBusinessRevenueMoonPo.setExtField1(each.getRevenueYear().toString());
                insertUocBusinessRevenueMoonPos.add(uocBusinessRevenueMoonPo);
            }
            //营业收入商品品种统计
            if(!CollectionUtils.isEmpty(each.getUocBusinessRevenueBreedSubs())){
                for (UocBusinessRevenueBreedSub uocBusinessRevenueBreedSub : each.getUocBusinessRevenueBreedSubs()) {
                    UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo = UocRu.js(uocBusinessRevenueBreedSub, UocBusinessRevenueBreedPO.class);
                    uocBusinessRevenueBreedPo.setBusinessRevenueId(each.getBusinessRevenueId());
                    uocBusinessRevenueBreedPo.setCreateTime(new Date());
                    uocBusinessRevenueBreedPo.setBreedId(IdUtil.nextId());
                    uocBusinessRevenueBreedPo.setDelFlag(UocDicConstant.DELETE_TAG.NO_DEL.toString());
                    //年度
                    uocBusinessRevenueBreedPo.setExtField1(each.getRevenueYear().toString());
                    insertUocBusinessRevenueBreedPo.add(uocBusinessRevenueBreedPo);
                }
            }
        }
        if(!CollectionUtils.isEmpty(businessRevenueIds)){
            String revenueYear = uocBusinessRevenueDo.get(0).getRevenueYear().toString();
            Integer revenueMoon = uocBusinessRevenueDo.get(0).getRevenueMoon();
            //根据 月度 businessRevenueId 删除旧数据 改根据月度和年度删除
            UocBusinessRevenueMoonPO whereUocBusinessRevenueMoonPo = new UocBusinessRevenueMoonPO();
//            whereUocBusinessRevenueMoonPo.setBusinessRevenueIds(businessRevenueIds);
            whereUocBusinessRevenueMoonPo.setExtField1(revenueYear);
            whereUocBusinessRevenueMoonPo.setRevenueMoon(revenueMoon);
            whereUocBusinessRevenueMoonPo.setDelFlag(UocDicConstant.DELETE_TAG.NO_DEL.toString());
            uocBusinessRevenueMoonMapper.deleteBy(whereUocBusinessRevenueMoonPo);

            //根据 月度 businessRevenueId 删除旧数据  改根据月度和年度删除
            UocBusinessRevenueBreedPO uocBusinessRevenueBreedPo = new UocBusinessRevenueBreedPO();
//            uocBusinessRevenueBreedPo.setBusinessRevenueIds(businessRevenueIds);
            whereUocBusinessRevenueMoonPo.setExtField1(revenueYear);
            uocBusinessRevenueBreedPo.setRevenueMoon(revenueMoon);
            uocBusinessRevenueBreedPo.setDelFlag(UocDicConstant.DELETE_TAG.NO_DEL.toString());
            uocBusinessRevenueBreedMapper.deleteBy(uocBusinessRevenueBreedPo);
        }

        if(!CollectionUtils.isEmpty(insetUocBusinessRevenuePos)){
            uocBusinessRevenueMapper.insertBatch(insetUocBusinessRevenuePos);
        }
        if(!CollectionUtils.isEmpty(insertUocBusinessRevenueMoonPos)){
            uocBusinessRevenueMoonMapper.insertBatch(insertUocBusinessRevenueMoonPos);
        }
        if(!CollectionUtils.isEmpty(insertUocBusinessRevenueBreedPo)){
            uocBusinessRevenueBreedMapper.insertBatch(insertUocBusinessRevenueBreedPo);
        }
    }
}
