package com.tydic.dyc.oc.repository.impl;

import com.tydic.dyc.oc.model.insporder.UocInspOrdItemDo;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.UocJyServSupQryDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspItemMap;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderMap;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.repository.UocInspOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocInspOrderRepositoryImpl
 * 说明:验收单
 * 时间:2022/2/21 18:53
 * 作者:罗有
 */

@Service
public class UocInspOrderRepositoryImpl implements UocInspOrderRepository {
    @Autowired
    private UocInspOrderMapper uocInspOrderMapper;
    @Autowired
    private UocInspOrderItemMapper uocInspOrderItemMapper;
    @Autowired
    private UocInspOrderMapMapper uocInspOrderMapMapper;
    @Autowired
    private UocInspItemMapMapper uocInspItemMapMapper;
    @Autowired
    private UocShipInspRelMapper uocShipInspRelMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocSaleStakeholderMapper uocSaleStakeholderMapper;


    @Override
    public void createInspOrder(UocInspOrderDo uocInspOrderDo) {
        uocInspOrderMapper.insert(UocRu.js(uocInspOrderDo, UocInspOrderPo.class));
        uocInspOrderItemMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getUocInspOrderItemList(), UocInspOrderItemPo.class));
        uocShipInspRelMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getUocShipInspRelList(), UocShipInspRelPo.class));
        if (!CollectionUtils.isEmpty(uocInspOrderDo.getExtParallelBoList())) {
            uocInspOrderMapMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getExtParallelBoList(), UocInspOrderMapPo.class));
        }
        List<UocInspItemMapPo> inspItemMapPoList = new ArrayList<>();
        uocInspOrderDo.getUocInspOrderItemList().forEach(uocInspOrderItem -> {
            if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                inspItemMapPoList.addAll(UocRu.jsl(uocInspOrderItem.getItemExtParallelBoList(), UocInspItemMapPo.class));
            }
        });
        if (!CollectionUtils.isEmpty(inspItemMapPoList)) {
            uocInspItemMapMapper.insertBatch(inspItemMapPoList);
        }
    }

    @Override
    public UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo) {
        UocInspOrderPo uocInspOrderPo = new UocInspOrderPo();
        uocInspOrderPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
        uocInspOrderPo = uocInspOrderMapper.getModelBy(uocInspOrderPo);
        UocInspOrderDo uocInspOrderDo = UocRu.js(uocInspOrderPo, UocInspOrderDo.class);
        if (null != uocInspOrderPo) {
            UocInspOrderMapPo uocInspOrderMapPo = new UocInspOrderMapPo();
            uocInspOrderMapPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            List<UocInspOrderMapPo> uocInspOrderMapPoList = uocInspOrderMapMapper.getList(uocInspOrderMapPo);
            uocInspOrderDo.setExtParallelBoList(UocRu.jsl(uocInspOrderMapPoList, UocInspOrderMap.class));

            UocShipInspRelPo uocShipInspRelPo = new UocShipInspRelPo();
            uocShipInspRelPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            List<UocShipInspRelPo> uocShipInspRelPoList = uocShipInspRelMapper.getList(uocShipInspRelPo);
            uocInspOrderDo.setUocShipInspRelList(UocRu.jsl(uocShipInspRelPoList, UocShipInspRel.class));

            UocOrderAccessoryPo uocOrderAccessoryPo = new UocOrderAccessoryPo();
            uocOrderAccessoryPo.setOrderId(uocInspOrderQryBo.getOrderId());
            uocOrderAccessoryPo.setObjId(uocInspOrderQryBo.getInspOrderId());
            List<UocOrderAccessoryPo> accessoryList = uocOrderAccessoryMapper.getList(uocOrderAccessoryPo);
            if(!CollectionUtils.isEmpty(accessoryList)){
                uocInspOrderDo.setUocOrderAccessoryList(UocRu.jsl(accessoryList, UocOrderAccessory.class));
            }

        }
        return uocInspOrderDo;
    }

    @Override
    public UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        List<UocInspOrderItemPo> uocInspOrderItemPoList = uocInspOrderItemMapper.getList(UocRu.js(uocInspOrderItemQryBo, UocInspOrderItemPo.class));
        uocInspOrderDo.setUocInspOrderItemList(UocRu.jsl(uocInspOrderItemPoList, UocInspOrderItem.class));
//        List<Long> inspItemOrderIdList = uocInspOrderItemPoList.stream().map(UocInspOrderItemPo::getImplOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(inspItemOrderIdList)) {
//            UocInspItemMapPo uocInspItemMapPo = new UocInspItemMapPo();
//            uocInspItemMapPo.setInspOrderItemIdList(inspItemOrderIdList);
//            List<UocInspItemMapPo> uocInspItemMapPoList = uocInspItemMapMapper.getList(uocInspItemMapPo);
//            if (!CollectionUtils.isEmpty(uocInspItemMapPoList)) {
//                ConcurrentMap<Long, List<UocInspItemMapPo>> uocInspItemMap =
//                        uocInspItemMapPoList.stream().collect(Collectors.groupingByConcurrent(UocInspItemMapPo::getInspOrderItemId));
//                uocInspOrderDo.getUocInspOrderItemList().forEach(uocInspOrderItem ->
//                        uocInspOrderItem.setItemExtParallelBoList(UocRu.jsl(uocInspItemMap.get(uocInspOrderItem.getInspOrderItemId()), UocInspItemMap.class)));
//            }
//        }
        return uocInspOrderDo;
    }

    @Override
    public List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo) {
        List<UocInspOrderPo> uocInspOrderPoList = uocInspOrderMapper.getList(UocRu.js(uocInspOrderQryBo, UocInspOrderPo.class));
        return UocRu.jsl(uocInspOrderPoList, UocInspOrderDo.class);
    }

    @Override
    public UocInspOrderDo qryTotalFeeAndCount(UocInspOrderQryBo uocInspOrderQryBo) {
        UocInspOrderPo uocInspOrderPo = UocRu.js(uocInspOrderQryBo, UocInspOrderPo.class);
        uocInspOrderPo = uocInspOrderMapper.qryTotalFeeAndCount(uocInspOrderPo);
        return UocRu.js(uocInspOrderPo, UocInspOrderDo.class);
    }

    @Override
    public void modifySaleOrderItemReturningCount(UocInspOrderItem uocSaleOrderItem) {
        UocInspOrderItemPo uocInspOrderItemPo = new UocInspOrderItemPo();
        uocInspOrderItemPo.setOrderId(uocSaleOrderItem.getOrderId());
        uocInspOrderItemPo.setInspOrderItemId(uocSaleOrderItem.getInspOrderItemId());
        uocInspOrderItemPo = uocInspOrderItemMapper.getModelBy(uocInspOrderItemPo);
        UocInspOrderItemPo set = new UocInspOrderItemPo();
        set.setReturnCount(uocInspOrderItemPo.getReturnCount().subtract(uocSaleOrderItem.getReturnCount()));
        set.setUpdateTime(uocSaleOrderItem.getUpdateTime());
        set.setUpdateOperId(uocSaleOrderItem.getUpdateOperId());
        UocInspOrderItemPo where = new UocInspOrderItemPo();
        where.setOrderId(uocSaleOrderItem.getOrderId());
        where.setInspOrderItemId(uocSaleOrderItem.getInspOrderItemId());
        uocInspOrderItemMapper.updateBy(set, where);
    }

    @Override
    public void modifyInspOrderItemChngingCount(UocInspOrderDo inspOrderDo) {
        uocInspOrderItemMapper.modifyInspOrderItemChngingCount(UocRu.jsl(inspOrderDo.getUocInspOrderItemList(), UocInspOrderItem.class), UocRu.js(inspOrderDo, UocInspOrderItem.class));
    }

    @Override
    public void modifyItemChngCountRefuse(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyItemChngCountRefuse(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));
    }

    @Override
    public void modifyItemChngCountConfirm(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyItemChngCountConfirm(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));
    }

    @Override
    public void modifyBatchItemInspConfirm(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyBatchItemInspConfirm(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));
        uocInspOrderMapper.modifyInspPrice(UocRu.js(convertInspOrderDo,UocInspOrderPo.class));
    }

    @Override
    public void modifyItemTaxRate(UocInspOrdItemDo uocInspOrdItemDo) {
        if (!CollectionUtils.isEmpty(uocInspOrdItemDo.getItemList())) {
            uocInspOrdItemDo.getItemList().forEach(itemDo ->{
                UocInspOrderItemPo uocInspOrderItemPo = new UocInspOrderItemPo();
                uocInspOrderItemPo.setExtField1(itemDo.getTaxRate().toString());
                uocInspOrderItemPo.setInspOrderItemId(itemDo.getInspOrdItemId());
                uocInspOrderItemPo.setInspOrderId(uocInspOrdItemDo.getInspOrderId());
                uocInspOrderItemMapper.updateInspItemRate(uocInspOrderItemPo);
            });
        }
    }

    @Override
    public List<UocJyServSupQryDo> qryServFeeSupList() {
        List<UocSaleStakeholderPo> uocSaleStakeholderPoList = uocSaleStakeholderMapper.qryServFeeSupList();
        return UocRu.jsl(uocSaleStakeholderPoList, UocJyServSupQryDo.class);
    }

    @Override
    public void addInspItemMap(List<UocInspItemMap> list) {
        uocInspItemMapMapper.insertBatch(UocRu.jsl(list,UocInspItemMapPo.class));
    }

    @Override
    public List<UocInspItemMap> getInspItemMapList(UocInspItemMap uocInspItemMap) {
        UocInspItemMapPo uocInspItemMapPo = UocRu.js(uocInspItemMap,UocInspItemMapPo.class);
        List<UocInspItemMapPo> list = uocInspItemMapMapper.getList(uocInspItemMapPo);
        return UocRu.jsl(list,UocInspItemMap.class);
    }
}
