package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.shiporder.UocReissueDo;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocReissueItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipItemMap;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocShipOrderRepositoryImpl
 * 说明:发货单
 * 时间:2022/2/21 18:54
 * 作者:罗有
 */

@Service
public class UocShipOrderRepositoryImpl implements UocShipOrderRepository {

    @Autowired
    private UocShipOrderMapper uocShipOrderMapper;
    @Autowired
    private UocShipOrderMapMapper uocShipOrderMapMapper;
    @Autowired
    private UocShipOrderItemMapper uocShipOrderItemMapper;
    @Autowired
    private UocShipItemMapMapper uocShipItemMapMapper;
    @Autowired
    private UocReissueMapper uocReissueMapper;
    @Autowired
    private UocReissueItemMapper uocReissueItemMapper;

    @Override
    public void createShipOrder(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderMapper.insert(UocRu.js(uocShipOrderDo, UocShipOrderPo.class));
        uocShipOrderItemMapper.insertBatch(UocRu.jsl(uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class));
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderMapMapper.insertBatch(UocRu.jsl(uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class));
        }
        List<UocShipItemMap> uocShipItemMapList = new ArrayList<>();
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            if (!CollectionUtils.isEmpty(uocShipOrderItem.getItemExtParallelBoList())) {
                uocShipItemMapList.addAll(uocShipOrderItem.getItemExtParallelBoList());
            }
        });
        if (!CollectionUtils.isEmpty(uocShipItemMapList)) {
            uocShipItemMapMapper.insertBatch(UocRu.jsl(uocShipItemMapList, UocShipItemMapPo.class));
        }
    }

    @Override
    public void createReissue(UocReissueDo uocShipOrderDo) {
        uocReissueMapper.insert(UocRu.js(uocShipOrderDo, UocReissuePO.class));
        uocReissueItemMapper.insertBatch(UocRu.jsl(uocShipOrderDo.getShipOrderItemBoList(), UocReissueItemPO.class));
    }

    @Override
    public void modifyBatchShipOrderArrivaRefuse(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo where = new UocShipOrderPo();
        where.setShipOrderIdList(uocShipOrderDo.getShipOrderIdList());
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocShipOrderMapper.updateBy(UocRu.js(uocShipOrderDo, UocShipOrderPo.class), where);
    }

    @Override
    public void modifyArrivaShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderItemMapper.updateItemArriveCount(UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public void modifyRefuseShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderItemMapper.updateItemRefuseCount(UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public UocShipOrderDo getListShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        UocShipOrderDo uocShipOrderRspDo = new UocShipOrderDo();
        List<UocShipOrderPo> list = uocShipOrderMapper.getList(UocRu.js(uocShipOrderItemQryBo, UocShipOrderPo.class));
        if (ObjectUtil.isNotEmpty(list)) {
            uocShipOrderRspDo = UocRu.js(list.get(0), UocShipOrderDo.class);
        }
        List<UocShipOrderItemPo> uocShipOrderItemPoList = uocShipOrderItemMapper.getList(UocRu.js(uocShipOrderItemQryBo, UocShipOrderItemPo.class));
        if (ObjectUtil.isNotEmpty(uocShipOrderItemPoList)) {
            uocShipOrderRspDo.setShipOrderItemBoList(UocRu.jsl(uocShipOrderItemPoList, UocShipOrderItem.class));
            List<Long> shipOrderItemIdList = uocShipOrderItemPoList.stream().map(UocShipOrderItemPo::getShipOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
            List<Long> orderIdList = uocShipOrderItemPoList.stream().map(UocShipOrderItemPo::getOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shipOrderItemIdList)) {
                uocShipOrderRspDo.setShipOrderItemIdList(shipOrderItemIdList);
                UocShipItemMapPo uocShipItemMapPo = new UocShipItemMapPo();
                uocShipItemMapPo.setShipOrderItemIdList(shipOrderItemIdList);
                uocShipItemMapPo.setOrderIdList(orderIdList);
                List<UocShipItemMapPo> uocShipItemMapPoList = uocShipItemMapMapper.getList(uocShipItemMapPo);
                if (ObjectUtil.isNotEmpty(uocShipItemMapPoList)) {
                    ConcurrentMap<Long, List<UocShipItemMapPo>> uocShipItemMap = uocShipItemMapPoList.stream().collect(Collectors.groupingByConcurrent(UocShipItemMapPo::getShipOrderItemId));
                    uocShipOrderRspDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> uocShipOrderItem.setItemExtParallelBoList(UocRu.jsl(uocShipItemMap.get(uocShipOrderItem.getShipOrderItemId()), UocShipItemMap.class)));
                }
            }
        }
        return uocShipOrderRspDo;
    }

    @Override
    public List<UocShipOrderItem> getShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        List<UocShipOrderItemPo> uocShipOrderItemPoList = uocShipOrderItemMapper.getList(UocRu.js(uocShipOrderItemQryBo, UocShipOrderItemPo.class));
        return UocRu.jsl(uocShipOrderItemPoList, UocShipOrderItem.class);
    }

    @Override
    public void modifyShipOrderMain(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo where = new UocShipOrderPo();
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        where.setShipOrderIdList(uocShipOrderDo.getShipOrderIdList());
        where.setShipOperId(uocShipOrderDo.getShipOperId());
        where.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderMapper.updateBy(UocRu.js(uocShipOrderDo, UocShipOrderPo.class), where);
    }

    @Override
    public void modifyBatchShipOrderItemInspCount(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderItemMapper.updateItemInspCount(UocRu.jsl(uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class), UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
    }

    @Override
    public UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        UocShipOrderPo uocShipOrderPo = new UocShipOrderPo();
        uocShipOrderPo.setShipOrderId(uocShipOrderQryBo.getShipOrderId());
        if (ObjectUtil.isNotEmpty(uocShipOrderQryBo.getOrderId())) {
            uocShipOrderPo.setOrderId(uocShipOrderQryBo.getOrderId());
        }
        uocShipOrderPo = uocShipOrderMapper.getModelBy(uocShipOrderPo);
        if (null != uocShipOrderPo) {
            uocShipOrderDo = UocRu.js(uocShipOrderPo, UocShipOrderDo.class);
            UocShipOrderMapPo uocShipOrderMapPo = new UocShipOrderMapPo();
            uocShipOrderMapPo.setShipOrderId(uocShipOrderQryBo.getShipOrderId());
            List<UocShipOrderMapPo> uocShipOrderMapPoList = uocShipOrderMapMapper.getList(uocShipOrderMapPo);
            if (!CollectionUtils.isEmpty(uocShipOrderMapPoList)) {
                uocShipOrderDo.setExtParallelBoList(UocRu.jsl(uocShipOrderMapPoList, UocShipOrderMap.class));
            }
        } else {
            return null;
        }
        return uocShipOrderDo;
    }

    @Override
    public List<UocShipOrderDo> getListShipOrder(UocShipOrderQryBo uocShipOrderQryBo) {
        List<UocShipOrderPo> uocShipOrderPoList = uocShipOrderMapper.getList(UocRu.js(uocShipOrderQryBo, UocShipOrderPo.class));
        return UocRu.jsl(uocShipOrderPoList, UocShipOrderDo.class);
    }

    @Override
    public UocShipOrderDo getShipOrderNo(UocShipOrderDo uocShipOrderDo) {
        return null;
    }

    @Override
    public void modifyShipOrderItemChngingCount(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            uocShipOrderItemMapper.updateItemChngingCount(UocRu.jsl(uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class), UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public void modifyItemReturnCountConfirm(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderItemMapper.updateItemReturnCountByChngingCount(UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public void modifyItemChngCountRefuse(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderItemMapper.updateItemReturnCountZero(UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo set = new UocShipOrderPo();
        if (!StringUtils.isBlank(uocShipOrderDo.getProcState())) {
            set.setProcState(uocShipOrderDo.getProcState());
        }
        set.setShipOrderState(uocShipOrderDo.getShipOrderState());
        set.setFinishFlag(uocShipOrderDo.getFinishFlag());
        UocShipOrderPo where = new UocShipOrderPo();
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderMapper.updateBy(set, where);
    }

    @Override
    public void addShipOrderMap(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderMapMapper.insertBatch(UocRu.jsl(uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class));
        }
    }

    @Override
    public void updateBatchValue(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderMapMapper.updateBatchValue(UocRu.jsl(uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class), UocRu.js(uocShipOrderDo, UocShipOrderMapPo.class));
        }
    }

    @Override
    public void updateInvalid(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderMapMapper.updateInvalid(UocRu.js(uocShipOrderDo, UocShipOrderMapPo.class));
        }
    }

    @Override
    public void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class);
        uocShipOrderItemMapper.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderItemPo);
    }

    @Override
    public void modifyItemArriveCountConfirm(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class);
        uocShipOrderItemMapper.modifyItemArriveCountConfirm(uocShipOrderItemPo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class);
        uocShipOrderItemMapper.modifyItemRefuseCountConfirm(uocShipOrderItemPo);
    }
    
    @Override
    public void modifyShipArrivtime(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderMapPo uocShipOrderMapPo = UocRu.js(uocShipOrderDo, UocShipOrderMapPo.class);
        uocShipOrderMapMapper.updateByShipOrderId(uocShipOrderMapPo);
    }
    
    @Override
    public void modifyItemArriveCount(UocShipOrderDo uocShipOrderDo) {
        for(UocShipOrderItem shipOrderItem: uocShipOrderDo.getShipOrderItemBoList()){
            UocShipOrderItemPo set = new UocShipOrderItemPo();
            set.setArriveCount(shipOrderItem.getArriveCount());
            set.setRefuseCount(shipOrderItem.getRefuseCount());
            set.setShipItemState(shipOrderItem.getShipItemState());
    
            UocShipOrderItemPo where = new UocShipOrderItemPo();
            where.setShipOrderItemId(shipOrderItem.getShipOrderItemId());
            uocShipOrderItemMapper.updateItemArriveCountAndRefuseAccount(set,where);
    
        }
       
    }

    @Override
    public void modifyShipStatus(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo uocShipOrderPo = new UocShipOrderPo() ;
        uocShipOrderPo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderPo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocShipOrderPo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderMapper.updateShipStatus(uocShipOrderPo);
    }

    @Override
    public void modifyStatChngShipStatus(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo uocShipOrderPo = new UocShipOrderPo() ;
        uocShipOrderPo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderPo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderMapper.updateStatChngShipStatus(uocShipOrderPo);
    }

    @Override
    public void modifyShipOrderItemAfterServingCount(UocShipOrderItem uocShipOrderItem) {
        uocShipOrderMapper.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
    }

    @Override
    public void modifyShipOrderItemReturningCount(UocShipOrderItem uocShipOrderItem) {
        uocShipOrderMapper.modifyShipOrderItemReturningCount(uocShipOrderItem);
    }
    
    @Override
    public List<UocShipOrderDo> getCheckVoterOrders(UocShipOrderDo record) {
        List<UocShipOrderDo> uocShipOrderDos = new ArrayList<>();
        List<UocShipOrderPo> uocShipOrderPos = uocShipOrderMapper.getCheckVoterOrders(UocRu.js(record,UocShipOrderPo.class));
        if(ObjectUtil.isNotEmpty(uocShipOrderPos)){
            uocShipOrderDos = UocRu.jsl(uocShipOrderPos,UocShipOrderDo.class);
            List<Long> shipOrderIds = uocShipOrderPos.stream().map(UocShipOrderPo::getShipOrderId).collect(Collectors.toList());
            UocShipOrderItemPo uocShipOrderItemPo = new UocShipOrderItemPo();
            uocShipOrderItemPo.setShipOrderIdList(shipOrderIds);
            List<UocShipOrderItemPo> shipOrderItemPos = uocShipOrderItemMapper.getList(uocShipOrderItemPo);
            Map<Long,List<UocShipOrderItemPo>> longListMap = shipOrderItemPos.stream().collect(Collectors.groupingBy(UocShipOrderItemPo::getShipOrderId));
            for(UocShipOrderDo uocShipOrderDo: uocShipOrderDos){
                uocShipOrderDo.setShipOrderItemBoList(UocRu.jsl(longListMap.get(uocShipOrderDo.getShipOrderId()),UocShipOrderItem.class));
            }
        }
        
        return uocShipOrderDos;
    }
    
    @Override
    public List<UocShipOrderDo> getCheckRefuseOrders(UocShipOrderDo record) {
        List<UocShipOrderDo> uocShipOrderDos = new ArrayList<>();
        List<UocShipOrderPo> uocShipOrderPos = uocShipOrderMapper.getCheckRefuseOrders(UocRu.js(record,UocShipOrderPo.class));
        if(ObjectUtil.isNotEmpty(uocShipOrderPos)){
            uocShipOrderDos = UocRu.jsl(uocShipOrderPos,UocShipOrderDo.class);
            List<Long> shipOrderIds = uocShipOrderPos.stream().map(UocShipOrderPo::getShipOrderId).collect(Collectors.toList());
            UocShipOrderItemPo uocShipOrderItemPo = new UocShipOrderItemPo();
            uocShipOrderItemPo.setShipOrderIdList(shipOrderIds);
            List<UocShipOrderItemPo> shipOrderItemPos = uocShipOrderItemMapper.getList(uocShipOrderItemPo);
            Map<Long,List<UocShipOrderItemPo>> longListMap = shipOrderItemPos.stream().collect(Collectors.groupingBy(UocShipOrderItemPo::getShipOrderId));
            for(UocShipOrderDo uocShipOrderDo: uocShipOrderDos){
                uocShipOrderDo.setShipOrderItemBoList(UocRu.jsl(longListMap.get(uocShipOrderDo.getShipOrderId()),UocShipOrderItem.class));
            }
        }
    
        return uocShipOrderDos;
    }

    /**
     * 发货单明细扩展信息获取
     * @param uocShipItemMap
     * @return
     */
    @Override
    public List<UocShipItemMap> getShipItemMapList(UocShipItemMap uocShipItemMap) {
        UocShipItemMapPo uocShipItemMapPo = UocRu.js(uocShipItemMap,UocShipItemMapPo.class);
        return UocRu.jsl(uocShipItemMapMapper.getList(uocShipItemMapPo),UocShipItemMap.class);
    }

    /**
     * 新增发货单明细扩展信息
     * @param list
     */
    @Override
    public void addShipItemMap(List<UocShipItemMap> list) {
        List<UocShipItemMapPo> uocShipItemMapPos = UocRu.jsl(list,UocShipItemMapPo.class);
        uocShipItemMapMapper.insertBatch(uocShipItemMapPos);
    }

    /**
     * 更新发货单明细扩展信息
     * @param set
     * @param where
     */
    @Override
    public void modifyShipItemMap(UocShipItemMap set, UocShipItemMap where) {
        UocShipItemMapPo setPo = UocRu.js(set,UocShipItemMapPo.class);
        UocShipItemMapPo wherePo = UocRu.js(where, UocShipItemMapPo.class) ;
        uocShipItemMapMapper.updateBy(setPo,wherePo);
    }

    /**
     * 补发发货单获取
     * @param uocReissueDo
     * @return
     */
    @Override
    public List<UocReissueDo> getReissueList(UocReissueDo uocReissueDo) {
        List<UocReissueDo> list = UocRu.jsl(uocReissueMapper.getList(UocRu.js(uocReissueDo, UocReissuePO.class)),UocReissueDo.class);
        if(!CollectionUtils.isEmpty(list)){
            List<Long> shipOrderIdList = list.stream().map(UocReissueDo::getShipOrderId).collect(Collectors.toList());
            UocReissueItemPO uocReissueItemPO = new UocReissueItemPO();
            uocReissueItemPO.setShipOrderIdList(shipOrderIdList);
            List<UocReissueItemPO> itemPOList = uocReissueItemMapper.getList(uocReissueItemPO);
            Map<Long, List<UocReissueItemPO>> itemMap = itemPOList.stream().collect(Collectors.groupingBy(UocReissueItemPO::getShipOrderId));
            for (UocReissueDo reissueDo : list){
                reissueDo.setShipOrderItemBoList(UocRu.jsl(itemMap.get(reissueDo.getShipOrderId()), UocReissueItem.class));
            }
        }
        return list;
    }
}
