package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.BusinessRevenue.JyUocQuotaDo;
import com.tydic.dyc.oc.model.BusinessRevenue.UocBusinessRevenueDo;
import com.tydic.dyc.oc.model.BusinessRevenue.qrybo.UocJyShopQuotaQryBo;
import com.tydic.dyc.oc.repository.UocShopQuotaRepository;
import com.tydic.dyc.oc.repository.dao.UocJyShopQuotaMapper;
import com.tydic.dyc.oc.repository.po.UocBusinessRevenuePO;
import com.tydic.dyc.oc.repository.po.UocJyShopQuotaPO;
import com.tydic.dyc.oc.service.businessrevenue.bo.UocJyShopQuotaBO;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @desc：
 * @author： liujian
 * @date： 2023/11/7 11:12
 **/
@Service
public class UocShopQuotaRepositoryImpl implements UocShopQuotaRepository {

    @Autowired
    private UocJyShopQuotaMapper uocJyShopQuotaMapper;

    @Override
    public void insertDataBatch(JyUocQuotaDo jyUocQuotaDo) {
        if (jyUocQuotaDo.getDelFlag()) {
            UocJyShopQuotaPO uocJyShopQuotaPO = new UocJyShopQuotaPO();
            uocJyShopQuotaPO.setOrgId(jyUocQuotaDo.getOrgId());
            uocJyShopQuotaPO.setDelFlag("0");
            uocJyShopQuotaMapper.deleteBy(uocJyShopQuotaPO);
        }
        List<UocJyShopQuotaPO> uocJyShopQuotaPOS = new ArrayList<>(jyUocQuotaDo.getQuotaList().size());
        jyUocQuotaDo.getQuotaList().forEach(bo ->{
            UocJyShopQuotaPO po = UocRu.js(bo, UocJyShopQuotaPO.class);
            po.setQuotaId(Sequence.getInstance().nextId());
            po.setCreateOperId(jyUocQuotaDo.getUserId());
            po.setCreateOperName(jyUocQuotaDo.getName());
            po.setCreateTime(new Date());
            po.setOrgId(jyUocQuotaDo.getOrgId());
            po.setOrgName(jyUocQuotaDo.getOrgName());
            po.setDelFlag("0");
            uocJyShopQuotaPOS.add(po);
        });
        uocJyShopQuotaMapper.insertBatch(uocJyShopQuotaPOS);
    }

    @Override
    public BasePageRspBo<UocJyShopQuotaBO> qryShopQuotaList(UocJyShopQuotaQryBo uocJyShopQuotaQryBo) {
        UocJyShopQuotaPO uocJyShopQuotaPO = new UocJyShopQuotaPO();
        uocJyShopQuotaPO.setOrgId(uocJyShopQuotaQryBo.getOrgId());
        Page<UocJyShopQuotaPO> page = new Page<>(uocJyShopQuotaQryBo.getPageNo(), uocJyShopQuotaQryBo.getPageSize());
        List<UocJyShopQuotaPO> uocJyShopQuotaPOS = uocJyShopQuotaMapper.getListPage(uocJyShopQuotaPO, page);
        BasePageRspBo<UocJyShopQuotaBO> rspBo = new BasePageRspBo<>();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(uocJyShopQuotaPOS) ? UocRu.jsl(uocJyShopQuotaPOS, UocJyShopQuotaBO.class) : new ArrayList<>(0));
        return rspBo;
    }

    @Override
    public Integer qryQuotaCount(UocJyShopQuotaQryBo uocJyShopQuotaQryBo) {
        UocJyShopQuotaPO uocJyShopQuotaPO = new UocJyShopQuotaPO();
        uocJyShopQuotaPO.setOrgId(uocJyShopQuotaQryBo.getOrgId());
        return uocJyShopQuotaMapper.qryQuotaCount(uocJyShopQuotaPO);
    }
}