package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：营业收入商品品种统计
 * 
 * @author SuJingchun
 * @date 2023-10-25 21:08
 **/
@Data
public class UocBusinessRevenueBreedPO implements Serializable {
	private static final long serialVersionUID =  -5404998339384976023L;

	/**
	 * 营业收入每月统计详细id
	 */
	private Long breedId;
	/**
	 * 营收收统计id
	 */
	private Long businessRevenueId;
	/**
	 * 商品id
	 */
	private String skuId;
	/**
	 * 商品名称
	 */
	private String skuName;
	/**
	 * 月度
	 */
	private Integer revenueMoon;
	/**
	 * 下单时间
	 */
	private Date orderTime;
	private Date orderTimeStart;
	private Date orderTimeEnd;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 扩展字段1
	 */
	private String extField1;
	/**
	 * 扩展字段2
	 */
	private String extField2;
	/**
	 * 扩展字段3
	 */
	private String extField3;
	/**
	 * 扩展字段4
	 */
	private String extField4;
	/**
	 * 扩展字段5
	 */
	private String extField5;
	/**
	 * 删除标记;0生效  1已删除
	 */
	private String delFlag;
	/**
	 * 排序
	 */
	private String orderBy;


	/**
	 * 月度开始时间（1月、2月。。）
	 */
	private Integer revenueMoonStart;

	/**
	 * 月度结束时间（1月、2月。。）
	 */
	private Integer revenueMoonEnd;

	/**
	 * 营收收统计id集合
	 */
	private List<Long> businessRevenueIds;

	/**
	 * 品种数
	 */
	private BigDecimal varietiesNum;

}
