package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：营收收入统计总表
 * 
 * @author SuJingchun
 * @date 2023-10-25 21:08
 **/
@Data
public class UocBusinessRevenuePO implements Serializable {
	private static final long serialVersionUID =  3881471687593586599L;

	/**
	 * 营收收统计id
	 */
	private Long businessRevenueId;
	/**
	 * 门店名称
	 */
	private String orgName;
	/**
	 * 门店id
	 */
	private Long orgId;
	/**
	 * 商品类别编码
	 */
	private String categoryCode;
	/**
	 * 商品类别名称
	 */
	private String categoryName;
	/**
	 * 商品品类id
	 */
	private Long itemCatId;
	/**
	 * 商品品类名称
	 */
	private String itemCatName;
	/**
	 * 一级商品品类ID
	 */
	private Long itemCatOneId;
	/**
	 * 一级商品品类名称
	 */
	private String itemCatOneName;
	/**
	 * 二级商品品类ID
	 */
	private Long itemCatTwoId;
	/**
	 * 二级商品品类名称
	 */
	private String itemCatTwoName;
	/**
	 * 年度
	 */
	private Integer revenueYear;
	/**
	 * 统计类别：1、商品池维度2、商品类目维度
	 */
	private String businessRevenueType;
	/**
	 * 创建人
	 */
	private Long createOperId;
	/**
	 * 创建人名称
	 */
	private String createOperName;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 修改人
	 */
	private Long updateOperId;
	/**
	 * 修改人名称
	 */
	private String updateOperName;
	/**
	 * 修改时间
	 */
	private Date updateTime;
	private Date updateTimeStart;
	private Date updateTimeEnd;
	/**
	 * 扩展字段1
	 */
	private String extField1;
	/**
	 * 扩展字段2
	 */
	private String extField2;
	/**
	 * 扩展字段3
	 */
	private String extField3;
	/**
	 * 扩展字段4
	 */
	private String extField4;
	/**
	 * 扩展字段5
	 */
	private String extField5;
	/**
	 * 删除标记;0生效  1已删除
	 */
	private String delFlag;
	/**
	 * 排序
	 */
	private String orderBy;


	/**
	 * 月度开始时间（1月、2月。。）
	 */
	private Integer revenueMoonStart;

	/**
	 * 月度结束时间（1月、2月。。）
	 */
	private Integer revenueMoonEnd;

	/**
	 * 营业收入每月统计详细表集合
	 */
	private List<UocBusinessRevenueMoonPO> uocBusinessRevenueMoons;

	/**
	 * 门店id集合
	 */
	private List<Long> orgIds;
	/**
	 * 累计金额 （总和）
	 */
	private BigDecimal purMoneyTotal;

	/**
	 * 营收收统计id集合
	 */
	private List<Long> businessRevenueIds;
	/**
	 * 应采购数量
	 */
	private BigDecimal num;
	/**
	 * 年度开始时间
	 */
	private Integer revenueYearStart;

	/**
	 * 年度结束时间
	 */
	private Integer revenueYearEnd;
	/**
	 * 查询时间开始
	 */
	private String qryDateStart;
	/**
	 * 查询时间结束
	 */
	private String qryDateEnd;
	/**
	 * 采购数量
	 */
	private BigDecimal purNum;
}
