package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题 UocReissuePO
 * 说明 补发发货单
 * 时间 2023/10/27 11:42
 *
 * @author 唐富强
 */
@Data
public class UocReissuePO implements Serializable {


    private static final long serialVersionUID = 6789041715218606323L;
    @DocField(value = "发货单id")
    private Long shipOrderId;

    @DocField(value = "销售单id")
    private Long saleOrderId;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "发货单编码")
    private String shipOrderNo;

    @DocField(value = "外部发货单编码")
    private String shipOrderNoExt;

    @DocField(value = "发货单名称")
    private String shipOrderName;

    @DocField(value = "发货单类型")
    private Integer shipOrderType;

    @DocField(value = "订单状态")
    private String shipOrderState;

    @DocField(value = "供应商编码")
    private String supNo;

    @DocField(value = "供应商账户")
    private String supAccount;

    @DocField(value = "物流公司id")
    private String shipCompanyId;

    @DocField(value = "物流公司名称")
    private String shipCompanyName;

    @DocField(value = "发货时间")
    private Date shipTime;

    @DocField(value = "发货时间 开始")
    private Date shipTimeStart;

    @DocField(value = "发货时间 结束")
    private Date shipTimeEnd;

    @DocField(value = "发货联系人姓名")
    private String shipName;

    @DocField(value = "发货联系人电话")
    private String shipPhone;

    @DocField(value = "发货工号")
    private String shipOperId;

    @DocField(value = "预计到货时间")
    private Date estimateArrivalTime;

    @DocField(value = "预计到货时间 开始")
    private Date estimateArrivalTimeStart;

    @DocField(value = "预计到货时间 结束")
    private Date estimateArrivalTimeEnd;

    @DocField(value = "到货时间")
    private Date arriveTime;

    @DocField(value = "到货时间 开始")
    private Date arriveTimeStart;

    @DocField(value = "到货时间 结束")
    private Date arriveTimeEnd;

    @DocField(value = "验收时间-该发货单全部被验收")
    private Date inspTime;

    @DocField(value = "验收时间-该发货单全部被验收 开始")
    private Date inspTimeStart;

    @DocField(value = "验收时间-该发货单全部被验收 结束")
    private Date inspTimeEnd;

    @DocField(value = "是否包含附件")
    private Integer isEnclosure;

    @DocField(value = "发货备注")
    private String shipRemark;

    @DocField(value = "到货备注")
    private String arriveRemark;

    @DocField(value = "验收人电话")
    private String inspOperPhone;

    @DocField(value = "验收人名字")
    private String inspOperId;

    @DocField(value = "验收人名称")
    private String inspOperName;

    @DocField(value = "收/拒收 货人")
    private String receiverUser;

    @DocField(value = "收/拒收 货备注")
    private String receiverRemark;

    @DocField(value = "收/拒收 联系人")
    private String receiverContact;

    @DocField(value = "收/拒收 时间")
    private Date receiverTime;

    @DocField(value = "收/拒收 时间 开始")
    private Date receiverTimeStart;

    @DocField(value = "收/拒收 时间 结束")
    private Date receiverTimeEnd;

    @DocField(value = "是否可以异常变更：1：不允许；其他情况都可以")
    private Integer isAbnormal;

    @DocField(value = "流转状态")
    private String procState;

    @DocField(value = "竣工标志             1 竣工             0 在途")
    private Integer finishFlag;

    @DocField(value = "租户ID")
    private String tenantId;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建时间 开始")
    private Date createTimeStart;

    @DocField(value = "创建时间 结束")
    private Date createTimeEnd;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新时间 开始")
    private Date updateTimeStart;

    @DocField(value = "更新时间 结束")
    private Date updateTimeEnd;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "撤单时间")
    private Date cancelTime;

    @DocField(value = "撤单时间 开始")
    private Date cancelTimeStart;

    @DocField(value = "撤单时间 结束")
    private Date cancelTimeEnd;

    @DocField(value = "撤单工号")
    private String cancelOperId;

    @DocField(value = "撤单原因")
    private String cancelReason;

    @DocField(value = "撤单标志:1 已撤单             0 未撤单")
    private Integer cancelFlag;

    @DocField(value = "物流单号")
    private String shipCompanyNo;

    @DocField(value = "车牌号")
    private String carNo;

    @DocField(value = "运输方式，1汽运，2三方物流")
    private Integer transportMode;

    @DocField(value = "允许变更时限")
    private Date allowChngTime;

    @DocField(value = "允许变更时限 开始")
    private Date allowChngTimeStart;

    @DocField(value = "允许变更时限 结束")
    private Date allowChngTimeEnd;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "竣工时间")
    private Date finishTime;

    @DocField(value = "竣工时间 开始")
    private Date finishTimeStart;

    @DocField(value = "竣工时间 结束")
    private Date finishTimeEnd;

    @DocField(value = "逾期时间")
    private Date expTime;

    @DocField(value = "逾期时间 开始")
    private Date expTimeStart;

    @DocField(value = "逾期时间 结束")
    private Date expTimeEnd;

    @DocField(value = "扩展字段1")
    private String extField1;

    @DocField(value = "扩展字段2")
    private String extField2;

    @DocField(value = "扩展字段3")
    private String extField3;

    @DocField(value = "扩展字段4")
    private String extField4;

    @DocField(value = "扩展字段5")
    private String extField5;

    @DocField(value = "删除标志1已删除")
    private Integer delTag;

}
