package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderItemPo
 * 说明:销售订单明细
 * 时间:2022-05-20 10:11
 * 作者:罗有
 **/
@Data
public class UocSaleOrderItemPo implements Serializable {
    private static final long serialVersionUID = -5861022529706617352L;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "销售明细id")
    private Long saleOrderItemId;

    @DocField(value = "销售单id")
    private Long saleOrderId;

    @DocField(value = "订单明细id")
    private Long orderItemId;

    @DocField(value = "明细类型             1 商品sku             2 物资             3 项目")
    private Integer itemType;

    @DocField(value = "单品来源      1 自营单品   2 电商导入   3 协议生成    ")
    private Integer skuSource;

    @DocField(value = "明细状态")
    private String saleItemState;

    @DocField(value = "单品ID")
    private String skuId;

    @DocField(value = "单品编码")
    private String skuCode;

    @DocField(value = "单品名称")
    private String skuName;

    @DocField(value = "商品id")
    private String commodityId;

    @DocField(value = "商品编码")
    private String commodityCode;

    @DocField(value = "商品名称")
    private String commodityName;

    @DocField(value = "商品类型id")
    private String commodityTypeId;

    @DocField(value = "商品类型名称")
    private String commodityTypeName;

    @DocField(value = "供应商ID")
    private String supplierId;

    @DocField(value = "店铺ID")
    private String supplierShopId;

    @DocField(value = "采购金额")
    private BigDecimal purchasePrice;

    @DocField(value = "采购金额")
    private BigDecimal salePrice;

    @DocField(value = "采购数量")
    private BigDecimal purchaseCount;

    @DocField(value = "发货数量")
    private BigDecimal sendCount;

    @DocField(value = "到货数量")
    private BigDecimal arriveCount;

    @DocField(value = "拒收数量")
    private BigDecimal refuseCount;

    @DocField(value = "验收数量")
    private BigDecimal acceptanceCount;

    @DocField(value = "是否存在超验 0否 1是")
    private Integer inspSuper;

    @DocField(value = "退货数量")
    private BigDecimal returnCount;

    @DocField(value = "异常变更在途数量，表示异常供应商确认之前的记录数量")
    private BigDecimal chngingCount;

    @DocField(value = "运费")
    private BigDecimal transFee;

    @DocField(value = "销售金额")
    private BigDecimal saleFee;

    @DocField(value = "采购金额")
    private BigDecimal purchaseFee;

    @DocField(value = "应付金额")
    private BigDecimal payFee;

    @DocField(value = "积分优惠金额")
    private BigDecimal integralDisFee;

    @DocField(value = "活动优惠金额")
    private BigDecimal actDisFee;

    @DocField(value = "其它优惠金额")
    private BigDecimal otherDisFee;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

    @DocField(value = "币种")
    private String currencyType;

    @DocField(value = "税金")
    private BigDecimal taxPrice;

    @DocField(value = "裸价")
    private BigDecimal nakedPrice;

    @DocField(value = "税率")
    private BigDecimal tax;

    @DocField(value = "税务编码")
    private String taxId;

    @DocField(value = "预计发货时间")
    private Date preSendTime;

    @DocField(value = "预计发货时间 开始")
    private Date preSendTimeStart;

    @DocField(value = "预计发货时间 结束")
    private Date preSendTimeEnd;

    @DocField(value = "预计交货时间")
    private Date preOfferTime;

    @DocField(value = "预计交货时间 开始")
    private Date preOfferTimeStart;

    @DocField(value = "预计交货时间 结束")
    private Date preOfferTimeEnd;

    @DocField(value = "计量单位")
    private String unitName;

    @DocField(value = "结算计量单位")
    private String settleUnit;

    @DocField(value = "售后在途数量")
    private BigDecimal afterServingCount;

    @DocField(value = "外部电商主订单id")
    private String lmOrderId;

    @DocField(value = "外部电商子订单id")
    private String lmSubOrderId;

    @DocField(value = "到货周期")
    private String arrivalTime;

    @DocField(value = "加价率")
    private Double markUpRate;

    @DocField(value = "商品服务费 ")
    private String serPrice;

    @DocField(value = "比选单号")
    private String cmpOrderNo;

    @DocField(value = "比选备注")
    private String cmpRemark;

    @DocField(value = "计划id")
    private String planId;

    @DocField(value = "计划明细id")
    private String planItemId;

    @DocField(value = "计划编号")
    private String planNo;

    @DocField(value = "计划明细编号")
    private String planItemNo;

    @DocField(value = "协议id")
    private String agreementId;

    @DocField(value = "协议编号")
    private String agreementNo;

    @DocField(value = "协议模式 1：平台协议 2：单位协议")
    private Integer agreementCode;

    @DocField(value = "协议明细编号")
    private String agreementIdItemNo;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建时间 开始")
    private Date createTimeStart;

    @DocField(value = "创建时间 结束")
    private Date createTimeEnd;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新时间 开始")
    private Date updateTimeStart;

    @DocField(value = "更新时间 结束")
    private Date updateTimeEnd;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "sku物料ID")
    private String skuMaterialId;

    @DocField(value = "sku物料编码")
    private String skuMaterialCode;

    @DocField(value = "sku外部单品id")
    private String skuExtSkuId;

    @DocField(value = "sku品牌id")
    private Long skuBrandId;

    @DocField(value = "单品品牌名称")
    private String skuBrandName;

    @DocField(value = "sku明细id")
    private String skuItemId;

    @DocField(value = "sku物料名称")
    private String skuMaterialName;

    @DocField(value = "sku物料类型名称")
    private String skuMaterialTypeName;

    @DocField(value = "sku物料类型id")
    private String skuMaterialTypeId;

    @DocField(value = "型号")
    private String model;

    @DocField(value = "规格")
    private String spec;

    @DocField(value = "材质")
    private String texture;

    @DocField(value = "图号")
    private String figure;

    @DocField(value = "一级类目")
    private Long l1Catalog;

    @DocField(value = "二级类目")
    private Long l2Catalog;

    @DocField(value = "三级类目")
    private Long l3Catalog;

    @DocField(value = "一级类目名称")
    private String l1CatalogName;

    @DocField(value = "二级类目名称")
    private String l2CatalogName;

    @DocField(value = "三级类目名称")
    private String l3CatalogName;

    @DocField(value = "退货时间，空代表不支持")
    private Integer rejectAllowDate;

    @DocField(value = "换货时间，空代表不支持")
    private Integer exchangeAllowDate;

    @DocField(value = "维修时间，空代表不支持")
    private Integer maintainAllowDate;

    @DocField(value = "sku单品主图url")
    private String skuMainPicUrl;

    @DocField(value = "删除标志1已删除")
    private Integer delTag;

    @DocField(value = "超验百分比，下单时保存（协议、无协议）")
    private Integer inspectionExcessPercent;

    @DocField(value = "超验数量")
    private BigDecimal inspSuperCount;

    @DocField(value = "排序")
    private String orderBy;

    @DocField(value = "销售明细id List")
    private List<Long> saleOrderItemIdList;


    /**
     * 未比选原因
     */
    private String noCmpReason;

    @DocField(value = "计量单位位数")
    private String unitDigit;
    /**
     * 是否运费商品
     */
    private Integer shipping;
}
