package com.tydic.dyc.oc.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 标题 UocTimeLimitEvaluateJobPo
 * 说明 订单时限类定时任务查询服务 实体
 * 时间 2023/10/10 16:10
 *
 * @author 唐富强
 */
@Data
public class UocTimeLimitJobPo implements Serializable {


    private static final long serialVersionUID = -4312503746138492430L;
    /**
     * 处理类型
     */
    private Integer dealType;
    /**
     * 处理分片大小 默认大小6个
     */
    private Integer dealShardSize;
    /**
     * 时效配置编码
     */
    private String effectiveCode;
    /**
     * 默认供应商编码
     */
    private String defaultSupplierNo;
    /**
     * 删除标志：0：生效；1：已删除
     */
    private Integer delTag;
    /**
     * 完结标志：0：未完结；1：已完结
     */
    private Integer finishTag;
    /**
     * 所在环节 集合
     */
    private List<String> procStateList;
    /**
     * 订单来源：1：自营单品；2：电商导入；3：协议生成
     */
    private Integer orderSource;
    /**
     * 扩展表编码-是否内部用户
     */
    private String internalUserFieldCode;
    /**
     * 服务单状态：400：服务取消；401：服务完成
     */
    private List<Integer> servStateList;
    /**
     * 不包含单据状态 集合
     */
    private List<String> objStateList;
    /**
     * 扩展表编码-是否推送分账
     */
    private String subLedgerFieldCode;
    /**
     * 扩展表编码-是否推送分账 值
     */
    private String subLedgerFieldValue;
    /**
     * 时限 秒数 目前是7天 604800秒
     */
    private Long timeLimit;
    /**
     * 销售单状态
     */
    private String saleOrderState;
    /**
     * 包含单据状态 集合
     */
    private List<String> objStateContainList;
    /**
     * 字段编码
     */
    private String fieldCode;
    /**
     * 支付方式
     */
    private String payType;
}
