/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.baseBo.UmcRspPageBO;
import com.tydic.dyc.umc.model.feedback.UmcEnterpriseOrgManageAtomService;
import com.tydic.dyc.umc.model.feedback.UmcEnterpriseOrgManageBusiService;
import com.tydic.dyc.umc.model.feedback.qrybo.UmcEnterpriseOrgQryBusiReqBO;
import com.tydic.dyc.umc.model.feedback.qrybo.UmcQryOrgFullNameByOrgIdsAtomReqBO;
import com.tydic.dyc.umc.model.feedback.sub.UmcQryOrgFullNameByOrgIdsAtomRspBO;
import com.tydic.dyc.umc.repository.dao.ExtEnterpriseOrgMapper;
import com.tydic.dyc.umc.repository.dao.ExtUmcOrgTypeConfigMapper;
import com.tydic.dyc.umc.repository.po.EnterpriseOrgPO;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseExtJsonBO;
import com.tydic.dyc.umc.repository.po.UmcOrgTypeConfigPO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.feedback.bo.UmcEnterpriseOrgBO;
import com.tydic.dyc.umc.service.feedback.bo.UmcZhEnterpriseOrgAbilityBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcEnterpriseOrgManageBusiServiceImpl
implements UmcEnterpriseOrgManageBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcEnterpriseOrgManageBusiServiceImpl.class);
    private static final Logger LOG = LoggerFactory.getLogger(UmcEnterpriseOrgManageBusiServiceImpl.class);
    @Autowired
    private ExtEnterpriseOrgMapper extEnterpriseOrgMapper;
    @Autowired
    private UmcEnterpriseOrgManageAtomService umcEnterpriseOrgManageAtomService;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private ExtUmcOrgTypeConfigMapper extUmcOrgTypeConfigMapper;

    public UmcRspPageBO<UmcEnterpriseOrgBO> queryEnterpriseOrgByPage(UmcEnterpriseOrgQryBusiReqBO busiReqBO) {
        ArrayList<Long> orgIds;
        Long orgId;
        UmcRspPageBO busiRsp = new UmcRspPageBO();
        EnterpriseOrgPO po = new EnterpriseOrgPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)po);
        Long l = orgId = busiReqBO.getOrgId() != null ? busiReqBO.getOrgId() : busiReqBO.getAdmOrgId();
        if (CollectionUtils.isEmpty((Collection)busiReqBO.getMgOrgIdsExt()) && orgId != null) {
            po.setOrgTreePath("%" + orgId + "-%");
        }
        if (StringUtils.isBlank((CharSequence)busiReqBO.getOrderBy())) {
            po.setOrderBy("t.DEEP,t.CREATE_TIME DESC");
        }
        po.setDelStatus("00");
        po.setOrgId(null);
        if ("01".equals(busiReqBO.getQueryType())) {
            po.setOrgId(orgId);
        } else if ("02".equals(busiReqBO.getQueryType())) {
            orgIds = new ArrayList<Long>();
            orgIds.add(orgId);
            po.setOrgIds(orgIds);
        } else if ("03".equals(busiReqBO.getQueryType())) {
            orgIds = new ArrayList();
            orgIds.add(orgId);
            po.setMgOrgIdsExt(orgIds);
        }
        if ("SG".equals(busiReqBO.getProjectOwnership())) {
            try {
                po.setBeginOneAmount(StringUtils.isBlank((CharSequence)busiReqBO.getBeginOneAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getBeginOneAmount())));
                po.setEndOneAmount(StringUtils.isBlank((CharSequence)busiReqBO.getEndOneAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getEndOneAmount())));
                po.setBeginPrivateAmount(StringUtils.isBlank((CharSequence)busiReqBO.getBeginPrivateAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getBeginPrivateAmount())));
                po.setEndPrivateAmount(StringUtils.isBlank((CharSequence)busiReqBO.getEndPrivateAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getEndPrivateAmount())));
                po.setBeginOneMonthAmount(StringUtils.isBlank((CharSequence)busiReqBO.getBeginOneMonthAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getBeginOneMonthAmount())));
                po.setEndOneMonthAmount(StringUtils.isBlank((CharSequence)busiReqBO.getEndOneMonthAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getEndOneMonthAmount())));
                po.setBeginPrivateMonthAmount(StringUtils.isBlank((CharSequence)busiReqBO.getBeginPrivateMonthAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getBeginPrivateMonthAmount())));
                po.setEndPrivateMonthAmount(StringUtils.isBlank((CharSequence)busiReqBO.getEndPrivateMonthAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getEndPrivateMonthAmount())));
                po.setBeginOrderAmount(StringUtils.isBlank((CharSequence)busiReqBO.getBeginOrderAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getBeginOrderAmount())));
                po.setEndOrderAmount(StringUtils.isBlank((CharSequence)busiReqBO.getEndOrderAmount()) ? null : MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(busiReqBO.getEndOrderAmount())));
                po.setProjectOwnership(busiReqBO.getProjectOwnership());
            }
            catch (Exception e) {
                throw new BaseBusinessException("163063", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
        }
        Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
        try {
            List<UmcEnterpriseOrgBO> boList = this.extEnterpriseOrgMapper.getListPage(po, (Page<EnterpriseOrgPO>)page);
            ArrayList<UmcEnterpriseOrgBO> rows = new ArrayList<UmcEnterpriseOrgBO>();
            if (!CollectionUtils.isEmpty(boList)) {
                ArrayList<Long> parentOrgIds = new ArrayList<Long>();
                ArrayList<Long> orgIds2 = new ArrayList<Long>();
                HashMap<Long, UmcEnterpriseOrgBO> busiBOMap = new HashMap<Long, UmcEnterpriseOrgBO>();
                for (UmcEnterpriseOrgBO boNew : boList) {
                    rows.add(boNew);
                    parentOrgIds.add(boNew.getParentId());
                    orgIds2.add(boNew.getOrgId());
                    busiBOMap.put(boNew.getOrgId(), boNew);
                }
                UmcQryOrgFullNameByOrgIdsAtomReqBO atomReqBO = new UmcQryOrgFullNameByOrgIdsAtomReqBO();
                atomReqBO.setOrgIds(orgIds2);
                UmcQryOrgFullNameByOrgIdsAtomRspBO atomRspBO1 = this.umcEnterpriseOrgManageAtomService.qryOrgFullNameByOrgIds(atomReqBO);
                if (!CollectionUtils.isEmpty((Map)atomRspBO1.getOrgIdAndOrgBOMap())) {
                    Map orgIdAndOrgBOMap = atomRspBO1.getOrgIdAndOrgBOMap();
                    for (Long orgIdItem : orgIdAndOrgBOMap.keySet()) {
                        if (busiBOMap.get(orgIdItem) == null) continue;
                        ((UmcEnterpriseOrgBO)busiBOMap.get(orgIdItem)).setOrgFullName(((UmcEnterpriseOrgBO)orgIdAndOrgBOMap.get(orgIdItem)).getOrgFullName());
                    }
                }
                EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
                enterpriseOrgPO.setOrgIds(parentOrgIds);
                List<UmcEnterpriseOrgBO> daoList = this.extEnterpriseOrgMapper.getList(enterpriseOrgPO);
                if (!CollectionUtils.isEmpty(daoList)) {
                    HashMap<Long, UmcEnterpriseOrgBO> map = new HashMap<Long, UmcEnterpriseOrgBO>();
                    for (UmcEnterpriseOrgBO boItem : daoList) {
                        map.put(boItem.getOrgId(), boItem);
                    }
                    for (UmcEnterpriseOrgBO busiRspBO : rows) {
                        if (map.get(busiRspBO.getParentId()) != null) {
                            busiRspBO.setParentOrgType(((UmcEnterpriseOrgBO)map.get(busiRspBO.getParentId())).getOrgType());
                            busiRspBO.setParentOrgTreePath(((UmcEnterpriseOrgBO)map.get(busiRspBO.getParentId())).getOrgTreePath());
                            continue;
                        }
                        if (busiRspBO.getParentId() != 1L) continue;
                        busiRspBO.setParentOrgType(busiRspBO.getOrgType());
                        busiRspBO.setParentOrgTreePath(busiRspBO.getOrgTreePath());
                    }
                }
            }
            busiRsp.setRows(rows);
            busiRsp.setTotal(Integer.valueOf(page.getTotalPages()));
            busiRsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            busiRsp.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            LOG.error("\u4f1a\u5458\u4e2d\u5fc3\u673a\u6784\u5206\u9875\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:{}", (Object)e.getMessage());
            throw new BaseBusinessException("163064", "\u4f1a\u5458\u4e2d\u5fc3\u673a\u6784\u5206\u9875\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        busiRsp.setRespCode("0000");
        busiRsp.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return busiRsp;
    }

    public List<UmcZhEnterpriseOrgAbilityBO> transfer(List<UmcEnterpriseOrgBO> busiList) {
        ArrayList<UmcZhEnterpriseOrgAbilityBO> rows = new ArrayList<UmcZhEnterpriseOrgAbilityBO>();
        if (!CollectionUtils.isEmpty(busiList)) {
            Map typeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "ENTERPRISE_ORG_TYPE");
            Map statueMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "ENTERPRISE_ORG_STATUS");
            Map isProfessionMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "IS_PROFESSIONAL_ORG");
            Map isShopOrgMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "IS_SHOP_ORG");
            Map isProfDeptMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "IS_PROF_DEPT");
            Map isBossMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "IS_BOSS");
            for (UmcEnterpriseOrgBO busiBO : busiList) {
                UmcOrgTypeConfigPO allParam;
                List<UmcOrgTypeConfigPO> allList;
                Map<String, List<UmcOrgTypeConfigPO>> codeMap;
                UmcEnterpriseExtJsonBO umcEnterpriseExtJsonBO;
                UmcZhEnterpriseOrgAbilityBO abilityBO = new UmcZhEnterpriseOrgAbilityBO();
                BeanUtils.copyProperties((Object)busiBO, (Object)abilityBO);
                if (!StringUtils.isBlank((CharSequence)busiBO.getExtJson()) && null != (umcEnterpriseExtJsonBO = (UmcEnterpriseExtJsonBO)JSON.parseObject((String)busiBO.getExtJson(), UmcEnterpriseExtJsonBO.class))) {
                    BeanUtils.copyProperties((Object)umcEnterpriseExtJsonBO, (Object)abilityBO);
                }
                if ((codeMap = (allList = this.extUmcOrgTypeConfigMapper.getList(allParam = new UmcOrgTypeConfigPO())).stream().collect(Collectors.groupingBy(UmcOrgTypeConfigPO::getOrgTypeCode))).get(abilityBO.getOrgType()) != null && codeMap.get(abilityBO.getOrgType()).size() > 0) {
                    abilityBO.setOrgTypeStr(codeMap.get(abilityBO.getOrgType()).get(0).getOrgTypeName());
                }
                abilityBO.setStatusStr((String)statueMap.get(abilityBO.getStatus()));
                abilityBO.setIsProfessionalOrgStr((String)isProfessionMap.get(abilityBO.getIsProfessionalOrg()));
                abilityBO.setIsProfDeptStr((String)isProfDeptMap.get(abilityBO.getIsProfDept()));
                abilityBO.setIsShopOrgStr((String)isShopOrgMap.get(abilityBO.getIsShopOrg()));
                abilityBO.setIsBossStr((String)isBossMap.get(abilityBO.getIsBoss()));
                try {
                    abilityBO.setBalance(MoneyUtils.Long2BigDecimal((Long)busiBO.getBalance()));
                    abilityBO.setSecurityAmount(MoneyUtils.Long2BigDecimal((Long)busiBO.getSecurityAmount()));
                    abilityBO.setPrivateMonthAmount(null == busiBO.getPrivateMonthAmount() || busiBO.getPrivateMonthAmount().equals(0L) ? null : MoneyUtils.Long2BigDecimal((Long)busiBO.getPrivateMonthAmount()).toString());
                    abilityBO.setPrivateAmount(null == busiBO.getPrivateAmount() || busiBO.getPrivateAmount().equals(0L) ? null : MoneyUtils.Long2BigDecimal((Long)busiBO.getPrivateAmount()).toString());
                    abilityBO.setOneMonthAmount(null == busiBO.getOneMonthAmount() || busiBO.getOneMonthAmount().equals(0L) ? null : MoneyUtils.Long2BigDecimal((Long)busiBO.getOneMonthAmount()).toString());
                    abilityBO.setOneAmount(null == busiBO.getOneAmount() || busiBO.getOneAmount().equals(0L) ? null : MoneyUtils.Long2BigDecimal((Long)busiBO.getOneAmount()).toString());
                    abilityBO.setOrderAmount(null == busiBO.getOrderAmount() || busiBO.getOrderAmount().equals(0L) ? null : MoneyUtils.Long2BigDecimal((Long)busiBO.getOrderAmount()).toString());
                }
                catch (Exception e) {
                    LOG.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                rows.add(abilityBO);
            }
        }
        return rows;
    }
}

