/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.api.FscPayBillAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillAtomRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillAtomServiceImpl
implements FscPayBillAtomService {
    @Value(value="${fscPayNotifyUrl}")
    private String notifyUrl;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${pay.center.req.way:1}")
    private String reqWay;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private PayProOrderAbilityService payProOrderAbilityService;
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    @Override
    public FscPayBillAtomRspBO dealPayBill(FscPayBillAtomReqBO atomReqBO) {
        FscPayBillAtomRspBO atomRspBO = new FscPayBillAtomRspBO();
        this.validStatsAndAmount(atomReqBO);
        FscOrderPO set = new FscOrderPO();
        if ("3".equals(atomReqBO.getPayChannel())) {
            this.invokeFscOrderStatusFlow(atomReqBO);
            set.setPayTime(new Date());
            if (!atomReqBO.getPayConfirmFlag().booleanValue()) {
                FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
                fscDealPaySuccessAtomReqBO.setPayFscOrderId(atomReqBO.getFscOrderIds());
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
                fscDealPaySuccessAtomReqBO.setParamMap(paramMap);
                FscDealPaySuccessAtomRspBO atomRspBO1 = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
                if (!"0000".equals(atomRspBO1.getRespCode())) {
                    throw new FscBusinessException("194202", atomRspBO1.getRespDesc());
                }
                atomRspBO.setResultFscOrderIds(atomRspBO1.getResultFscOrderIds());
            }
        } else {
            Long payOrderId = this.createPayOrder(atomReqBO);
            String url = this.invokePayProOrder(atomReqBO, payOrderId);
            atomRspBO.setUrl(url);
        }
        set.setPayOperName(atomReqBO.getName());
        set.setPayOperId(atomReqBO.getUserName());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(atomReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        if (!CollectionUtils.isEmpty(atomReqBO.getFscAttachmentBOS())) {
            this.insertFscAttachment(atomReqBO);
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u652f\u4ed8\u8c03\u7528\u6210\u529f");
        return atomRspBO;
    }

    private void insertFscAttachment(FscPayBillAtomReqBO busiReqBO) {
        ArrayList<Long> fscOrderIds = this.fscOrderMapper.getPayOrderRelationFscOrder(busiReqBO.getFscOrderIds());
        if (CollectionUtils.isEmpty((Collection)fscOrderIds)) {
            fscOrderIds = new ArrayList<Long>();
        }
        fscOrderIds.addAll(busiReqBO.getFscOrderIds());
        ArrayList fscAttachmentPOS = new ArrayList();
        fscOrderIds.forEach(fscOrderId -> busiReqBO.getFscAttachmentBOS().forEach(fscAttachmentBO -> {
            FscAttachmentPO po = new FscAttachmentPO();
            po.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setAttachmentName(fscAttachmentBO.getAttachmentName());
            po.setAttachmentType(fscAttachmentBO.getAttachmentType());
            po.setAttachmentUrl(fscAttachmentBO.getAttachmentUrl());
            po.setObjType(FscConstants.FscAttachmentObjType.ORDER);
            po.setObjId(fscOrderId);
            po.setFscOrderId(fscOrderId);
            fscAttachmentPOS.add(po);
        }));
        this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
    }

    private Long createPayOrder(FscPayBillAtomReqBO busiReqBO) {
        Long payOrderId = Sequence.getInstance().nextId();
        FscPayOrderPO po = new FscPayOrderPO();
        po.setPayOrderId(payOrderId);
        po.setPayChannel(busiReqBO.getPayChannel());
        po.setPayAmount(busiReqBO.getTotalAmount());
        po.setCreateTime(new Date());
        po.setPayMethod(busiReqBO.getPayMethod());
        po.setPayStatus(FscConstants.PayOrderPayStatus.TO_PAY);
        this.fscPayOrderMapper.insert(po);
        ArrayList fscPayRelationPOS = new ArrayList();
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            FscPayRelationPO po1 = new FscPayRelationPO();
            po1.setId(Long.valueOf(Sequence.getInstance().nextId()));
            po1.setFscOrderId(fscOrderId);
            po1.setPayOrderId(payOrderId);
            fscPayRelationPOS.add(po1);
        });
        this.fscPayRelationMapper.insertBatch(fscPayRelationPOS);
        return payOrderId;
    }

    private void invokeFscOrderStatusFlow(FscPayBillAtomReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (busiReqBO.getPayConfirmFlag().booleanValue()) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
        } else {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("194202", atomRspBO.getRespDesc());
            }
        });
    }

    private void invokeFscOrderStatusFlow(Long fscOrderId, Map<String, Object> paramMap, Integer curStatus) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        fscOrderStatusFlowAtomReqBO.setCurStatus(curStatus);
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private String invokePayProOrder(FscPayBillAtomReqBO busiReqBO, Long payOrderId) {
        FscMerchantPO reqPO = new FscMerchantPO();
        reqPO.setOrgId(busiReqBO.getPayeeId());
        reqPO.setExceptionFlag(Integer.valueOf(0));
        reqPO.setDelFlag(Integer.valueOf(0));
        FscMerchantPO rspPO = this.fscMerchantMapper.getModelBy(reqPO);
        if (null == rspPO) {
            throw new FscBusinessException("194202", "\u6536\u6b3e\u65b9\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo = new PayProOrderAbilityServiceReqBo();
        payProOrderAbilityServiceReqBo.setBusiCode(this.payBusiCode);
        payProOrderAbilityServiceReqBo.setReqWay(this.reqWay);
        payProOrderAbilityServiceReqBo.setOutOrderId(payOrderId.toString());
        payProOrderAbilityServiceReqBo.setMerchantId(rspPO.getPayMerchantId());
        payProOrderAbilityServiceReqBo.setTotalFee(MoneyUtils.yuanToFenToLong((BigDecimal)busiReqBO.getTotalAmount()) + "");
        payProOrderAbilityServiceReqBo.setDetailName(busiReqBO.getDetailName());
        payProOrderAbilityServiceReqBo.setRedirectUrl(busiReqBO.getRedirectUrl());
        payProOrderAbilityServiceReqBo.setNotifyUrl(this.notifyUrl);
        payProOrderAbilityServiceReqBo.setCreateIpAddress(busiReqBO.getIp());
        payProOrderAbilityServiceReqBo.setCreateOperId(busiReqBO.getUserId().toString());
        payProOrderAbilityServiceReqBo.setCreateOperIdName(busiReqBO.getName());
        JSONObject busiReqData = new JSONObject();
        busiReqData.put("payMethods", (Object)busiReqBO.getPayMethod());
        payProOrderAbilityServiceReqBo.setBusiReqData(busiReqData.toJSONString());
        PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo = this.payProOrderAbilityService.dealOrder(payProOrderAbilityServiceReqBo);
        if (!"0000".equals(payProOrderAbilityServiceRspBo.getRspCode())) {
            throw new FscBusinessException("194202", payProOrderAbilityServiceRspBo.getRespDesc());
        }
        return payProOrderAbilityServiceRspBo.getUrl();
    }

    private void validStatsAndAmount(FscPayBillAtomReqBO busiReqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(busiReqBO.getFscOrderIds());
        List pos = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isEmpty((Collection)pos)) {
            throw new FscBusinessException("194202", "\u5f85\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        ArrayList<Long> fscStatusError = new ArrayList<Long>();
        ArrayList<Long> existFscOrderIds = new ArrayList<Long>();
        BigDecimal totalAmount = new BigDecimal(0);
        HashSet<String> payChannel = new HashSet<String>();
        HashSet<String> payMethod = new HashSet<String>();
        HashSet<Long> payerIds = new HashSet<Long>();
        HashSet<Long> payeeIds = new HashSet<Long>();
        for (FscOrderPO fscOrderPO1 : pos) {
            existFscOrderIds.add(fscOrderPO1.getFscOrderId());
            payChannel.add(fscOrderPO1.getPayChannel());
            payMethod.add(fscOrderPO1.getPayMethod());
            payerIds.add(fscOrderPO1.getPayerId());
            payeeIds.add(fscOrderPO1.getPayeeId());
            if (!fscOrderPO1.getOrderState().equals(FscConstants.FscPayOrderState.TO_PAY)) {
                fscStatusError.add(fscOrderPO1.getFscOrderId());
            }
            totalAmount = totalAmount.add(fscOrderPO1.getTotalCharge());
        }
        if (payChannel.size() > 1) {
            throw new FscBusinessException("194202", "\u591a\u4e2a\u4ed8\u6b3e\u5355\u652f\u4ed8\u6e20\u9053\u4e0d\u4e00\u81f4\uff01");
        }
        if (!payChannel.contains(busiReqBO.getPayChannel())) {
            throw new FscBusinessException("194202", "\u5165\u53c2\u652f\u4ed8\u6e20\u9053\u548c\u6570\u636e\u5e93\u4e0d\u4e00\u81f4\uff01");
        }
        if (payMethod.size() > 1) {
            throw new FscBusinessException("194202", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194202", "\u4ed8\u6b3e\u65b9\u4e0d\u4e00\u81f4\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194202", "\u6536\u6b3e\u65b9\u4e0d\u4e00\u81f4\uff01");
        }
        if (fscStatusError.size() > 0) {
            throw new FscBusinessException("194202", ((Object)fscStatusError).toString() + "\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\uff01");
        }
        if (existFscOrderIds.size() < busiReqBO.getFscOrderIds().size()) {
            busiReqBO.getFscOrderIds().removeAll(existFscOrderIds);
            throw new FscBusinessException("194202", busiReqBO.getFscOrderIds() + "\u4e0d\u5b58\u5728\uff01");
        }
        busiReqBO.setPayChannel(((FscOrderPO)pos.get(0)).getPayChannel());
        busiReqBO.setPayMethod(((FscOrderPO)pos.get(0)).getPayMethod());
        busiReqBO.setPayerId(((FscOrderPO)pos.get(0)).getPayerId());
        busiReqBO.setPayeeId(((FscOrderPO)pos.get(0)).getPayeeId());
        busiReqBO.setTotalAmount(totalAmount);
    }
}

