/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.util;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LdHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(LdHttpUtils.class);

    public String doPost(String url, String body, Map<String, String> queryMap) {
        log.debug("\u8fdb\u5165http_post---------------------------------------------------");
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = httpClientBuilder.build();
        log.debug("httpClientBuilder.build()--------------------------------------------------");
        HttpPost request = new HttpPost(url);
        if (StringUtils.hasText((String)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
            request.addHeader("Content-Type", "application/json");
            request.addHeader("appCode", "liandong");
            log.debug("http_post_body---------------------------------------------------" + body);
        }
        try {
            return LdHttpUtils.parseHttpResponseString(httpClient.execute((HttpUriRequest)request));
        }
        catch (Exception e) {
            throw new ZTBusinessException("HTTP\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private static String parseHttpResponseString(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        String httpResponseString = null;
        if (null != entity) {
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                throw new ZTBusinessException("HTTP\u8bf7\u6c42\u72b6\u6001\u5f02\u5e38\u72b6\u6001\u7801\uff1a" + httpResponse.getStatusLine().getStatusCode() + "\uff0c\u539f\u56e0\uff1a" + EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8));
            }
            httpResponseString = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            EntityUtils.consume((HttpEntity)entity);
        }
        EntityUtils.consume((HttpEntity)entity);
        return httpResponseString;
    }
}

