/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.util;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.constants.FscConstants;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoneyUtil {
    private static final Logger log = LoggerFactory.getLogger(MoneyUtil.class);

    public static Map<String, PayMoney> distribute(BigDecimal amount, Map<String, PayMoney> moneyMap, Boolean isContract) {
        log.info("\u5b9e\u4ed8\u8ba1\u7b97----\u5f00\u59cb\u8ba1\u7b97\u5b9e\u4ed8\u5206\u644a\u91d1\u989d\u5165\u53c2-----\u5b9e\u4ed8\u91d1\u989d-----{},{}", (Object)amount, (Object)JSONObject.toJSONString(moneyMap));
        HashMap<String, PayMoney> result = new HashMap<String, PayMoney>();
        BigDecimal zero = isContract == false ? BigDecimal.ZERO : new BigDecimal(amount.toString());
        int i = 1;
        while (i == 1 || zero.compareTo(BigDecimal.ZERO) > 0) {
            for (String s : moneyMap.keySet()) {
                PayMoney money = moneyMap.get(s);
                if (!money.getCostPayState().equals(FscConstants.CostPayState.PAYED)) {
                    BigDecimal payMoney;
                    if (isContract.booleanValue() && zero.compareTo(BigDecimal.ZERO) <= 0) {
                        money.setPayMoney(money.getPayMoney() != null ? money.getPayMoney() : BigDecimal.ZERO);
                        result.put(s, money);
                        break;
                    }
                    if (isContract.booleanValue()) {
                        payMoney = zero.multiply(money.getRatio()).setScale(2, RoundingMode.HALF_UP);
                    } else {
                        payMoney = amount.multiply(money.getRatio()).setScale(2, RoundingMode.HALF_UP);
                        if (i > 1) {
                            payMoney = BigDecimal.ZERO;
                        }
                        if (zero.compareTo(BigDecimal.ZERO) > 0) {
                            payMoney = payMoney.add(zero);
                            zero = BigDecimal.ZERO;
                        }
                    }
                    BigDecimal actualPayment = payMoney.add(money.getPaidMoney());
                    if (actualPayment.compareTo(money.getTotalMoney()) >= 0) {
                        money.setCostPayState(FscConstants.CostPayState.PAYED);
                        BigDecimal subtract = money.getTotalMoney().subtract(money.getPaidMoney());
                        if (i > 1) {
                            subtract = money.getPayMoney().add(payMoney);
                        }
                        money.setPayMoney(subtract);
                        money.setPaidMoney(money.getTotalMoney());
                        zero = isContract.booleanValue() ? payMoney.subtract(subtract) : actualPayment.subtract(money.getTotalMoney());
                    } else {
                        money.setCostPayState(FscConstants.CostPayState.PART_PAY);
                        if (i > 1) {
                            payMoney = money.getPayMoney().add(payMoney);
                        }
                        money.setPayMoney(payMoney);
                        money.setPaidMoney(actualPayment);
                        if (isContract.booleanValue()) {
                            zero = BigDecimal.ZERO;
                        }
                    }
                }
                result.put(s, money);
            }
            if (++i <= moneyMap.size()) continue;
        }
        log.info("\u5b9e\u4ed8\u8ba1\u7b97----\u7ed3\u675f\u8ba1\u7b97\u5b9e\u4ed8\u5206\u644a\u91d1\u989d\u8fd4\u53c2----------{}", (Object)JSONObject.toJSONString(result));
        return result;
    }

    public static void main(String[] args) {
        BigDecimal bigDecimal = new BigDecimal("5000");
        BigDecimal bigDecimal2 = new BigDecimal("220");
        BigDecimal bigDecimal3 = new BigDecimal("80");
        BigDecimal bigDecimal4 = new BigDecimal("100");
        PayMoney money = new PayMoney();
        money.setPaidMoney(new BigDecimal("146"));
        money.setRatio(new BigDecimal("0.73"));
        money.setTotalMoney(bigDecimal2);
        money.setCostPayState(FscConstants.CostPayState.PART_PAY);
        PayMoney money1 = new PayMoney();
        money1.setPaidMoney(new BigDecimal("54"));
        money1.setRatio(new BigDecimal("0.27"));
        money1.setTotalMoney(bigDecimal3);
        money1.setCostPayState(FscConstants.CostPayState.PART_PAY);
        PayMoney money2 = new PayMoney();
        money2.setPaidMoney(BigDecimal.ZERO);
        money2.setRatio(new BigDecimal("1"));
        money2.setTotalMoney(bigDecimal4);
        money2.setCostPayState(FscConstants.CostPayState.TO_PAY);
        HashMap<String, PayMoney> map = new HashMap<String, PayMoney>();
        map.put("1", money);
        map.put("2", money1);
        Map<String, PayMoney> distribute = MoneyUtil.distribute(new BigDecimal("100"), map, false);
        String e = "";
    }

    public static class PayMoney {
        private BigDecimal totalMoney;
        private BigDecimal paidMoney;
        private BigDecimal ratio;
        private BigDecimal payMoney;
        private Integer costPayState;

        public BigDecimal getTotalMoney() {
            return this.totalMoney;
        }

        public BigDecimal getPaidMoney() {
            return this.paidMoney;
        }

        public BigDecimal getRatio() {
            return this.ratio;
        }

        public BigDecimal getPayMoney() {
            return this.payMoney;
        }

        public Integer getCostPayState() {
            return this.costPayState;
        }

        public void setTotalMoney(BigDecimal totalMoney) {
            this.totalMoney = totalMoney;
        }

        public void setPaidMoney(BigDecimal paidMoney) {
            this.paidMoney = paidMoney;
        }

        public void setRatio(BigDecimal ratio) {
            this.ratio = ratio;
        }

        public void setPayMoney(BigDecimal payMoney) {
            this.payMoney = payMoney;
        }

        public void setCostPayState(Integer costPayState) {
            this.costPayState = costPayState;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PayMoney)) {
                return false;
            }
            PayMoney other = (PayMoney)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$totalMoney = this.getTotalMoney();
            BigDecimal other$totalMoney = other.getTotalMoney();
            if (this$totalMoney == null ? other$totalMoney != null : !((Object)this$totalMoney).equals(other$totalMoney)) {
                return false;
            }
            BigDecimal this$paidMoney = this.getPaidMoney();
            BigDecimal other$paidMoney = other.getPaidMoney();
            if (this$paidMoney == null ? other$paidMoney != null : !((Object)this$paidMoney).equals(other$paidMoney)) {
                return false;
            }
            BigDecimal this$ratio = this.getRatio();
            BigDecimal other$ratio = other.getRatio();
            if (this$ratio == null ? other$ratio != null : !((Object)this$ratio).equals(other$ratio)) {
                return false;
            }
            BigDecimal this$payMoney = this.getPayMoney();
            BigDecimal other$payMoney = other.getPayMoney();
            if (this$payMoney == null ? other$payMoney != null : !((Object)this$payMoney).equals(other$payMoney)) {
                return false;
            }
            Integer this$costPayState = this.getCostPayState();
            Integer other$costPayState = other.getCostPayState();
            return !(this$costPayState == null ? other$costPayState != null : !((Object)this$costPayState).equals(other$costPayState));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PayMoney;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $totalMoney = this.getTotalMoney();
            result = result * 59 + ($totalMoney == null ? 43 : ((Object)$totalMoney).hashCode());
            BigDecimal $paidMoney = this.getPaidMoney();
            result = result * 59 + ($paidMoney == null ? 43 : ((Object)$paidMoney).hashCode());
            BigDecimal $ratio = this.getRatio();
            result = result * 59 + ($ratio == null ? 43 : ((Object)$ratio).hashCode());
            BigDecimal $payMoney = this.getPayMoney();
            result = result * 59 + ($payMoney == null ? 43 : ((Object)$payMoney).hashCode());
            Integer $costPayState = this.getCostPayState();
            result = result * 59 + ($costPayState == null ? 43 : ((Object)$costPayState).hashCode());
            return result;
        }

        public String toString() {
            return "MoneyUtil.PayMoney(totalMoney=" + this.getTotalMoney() + ", paidMoney=" + this.getPaidMoney() + ", ratio=" + this.getRatio() + ", payMoney=" + this.getPayMoney() + ", costPayState=" + this.getCostPayState() + ")";
        }
    }
}

