/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.util;

import com.tydic.fsc.constants.FscConstants;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class MoneyUtil {
    public static Map<String, PayMoney> distribute(BigDecimal amount, Map<String, PayMoney> moneyMap) {
        HashMap<String, PayMoney> result = new HashMap<String, PayMoney>();
        BigDecimal zero = BigDecimal.ZERO;
        BigDecimal totalMoney = new BigDecimal(amount.toString());
        for (int i = 0; i < 2; ++i) {
            for (String s : moneyMap.keySet()) {
                if ("0".equals(s)) break;
                PayMoney money = moneyMap.get(s);
                if (!money.getCostPayState().equals(FscConstants.CostPayState.PAYED)) {
                    BigDecimal actualPayment;
                    BigDecimal payMoney = amount.multiply(money.getRatio()).setScale(2, RoundingMode.HALF_UP);
                    if (i > 0) {
                        payMoney = BigDecimal.ZERO;
                    }
                    if (zero.compareTo(BigDecimal.ZERO) > 0) {
                        payMoney = payMoney.add(zero);
                        zero = BigDecimal.ZERO;
                    }
                    if ((actualPayment = payMoney.add(money.getPaidMoney())).compareTo(money.getTotalMoney()) >= 0) {
                        money.setCostPayState(FscConstants.CostPayState.PAYED);
                        BigDecimal subtract = money.getTotalMoney().subtract(money.getPaidMoney());
                        if (i > 0) {
                            subtract = money.getPayMoney().add(payMoney);
                        }
                        money.setPayMoney(subtract);
                        money.setPaidMoney(money.getTotalMoney());
                        zero = actualPayment.subtract(money.getTotalMoney());
                    } else {
                        money.setCostPayState(FscConstants.CostPayState.PART_PAY);
                        money.setPayMoney(payMoney);
                        money.setPaidMoney(actualPayment);
                    }
                    totalMoney = totalMoney.subtract(money.getPayMoney());
                }
                result.put(s, money);
            }
        }
        PayMoney p = new PayMoney();
        p.setTotalMoney(totalMoney);
        result.put("0", p);
        return result;
    }

    public static class PayMoney {
        private BigDecimal totalMoney;
        private BigDecimal paidMoney;
        private BigDecimal ratio;
        private BigDecimal payMoney;
        private Integer costPayState;

        public BigDecimal getTotalMoney() {
            return this.totalMoney;
        }

        public BigDecimal getPaidMoney() {
            return this.paidMoney;
        }

        public BigDecimal getRatio() {
            return this.ratio;
        }

        public BigDecimal getPayMoney() {
            return this.payMoney;
        }

        public Integer getCostPayState() {
            return this.costPayState;
        }

        public void setTotalMoney(BigDecimal totalMoney) {
            this.totalMoney = totalMoney;
        }

        public void setPaidMoney(BigDecimal paidMoney) {
            this.paidMoney = paidMoney;
        }

        public void setRatio(BigDecimal ratio) {
            this.ratio = ratio;
        }

        public void setPayMoney(BigDecimal payMoney) {
            this.payMoney = payMoney;
        }

        public void setCostPayState(Integer costPayState) {
            this.costPayState = costPayState;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PayMoney)) {
                return false;
            }
            PayMoney other = (PayMoney)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$totalMoney = this.getTotalMoney();
            BigDecimal other$totalMoney = other.getTotalMoney();
            if (this$totalMoney == null ? other$totalMoney != null : !((Object)this$totalMoney).equals(other$totalMoney)) {
                return false;
            }
            BigDecimal this$paidMoney = this.getPaidMoney();
            BigDecimal other$paidMoney = other.getPaidMoney();
            if (this$paidMoney == null ? other$paidMoney != null : !((Object)this$paidMoney).equals(other$paidMoney)) {
                return false;
            }
            BigDecimal this$ratio = this.getRatio();
            BigDecimal other$ratio = other.getRatio();
            if (this$ratio == null ? other$ratio != null : !((Object)this$ratio).equals(other$ratio)) {
                return false;
            }
            BigDecimal this$payMoney = this.getPayMoney();
            BigDecimal other$payMoney = other.getPayMoney();
            if (this$payMoney == null ? other$payMoney != null : !((Object)this$payMoney).equals(other$payMoney)) {
                return false;
            }
            Integer this$costPayState = this.getCostPayState();
            Integer other$costPayState = other.getCostPayState();
            return !(this$costPayState == null ? other$costPayState != null : !((Object)this$costPayState).equals(other$costPayState));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PayMoney;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $totalMoney = this.getTotalMoney();
            result = result * 59 + ($totalMoney == null ? 43 : ((Object)$totalMoney).hashCode());
            BigDecimal $paidMoney = this.getPaidMoney();
            result = result * 59 + ($paidMoney == null ? 43 : ((Object)$paidMoney).hashCode());
            BigDecimal $ratio = this.getRatio();
            result = result * 59 + ($ratio == null ? 43 : ((Object)$ratio).hashCode());
            BigDecimal $payMoney = this.getPayMoney();
            result = result * 59 + ($payMoney == null ? 43 : ((Object)$payMoney).hashCode());
            Integer $costPayState = this.getCostPayState();
            result = result * 59 + ($costPayState == null ? 43 : ((Object)$costPayState).hashCode());
            return result;
        }

        public String toString() {
            return "MoneyUtil.PayMoney(totalMoney=" + this.getTotalMoney() + ", paidMoney=" + this.getPaidMoney() + ", ratio=" + this.getRatio() + ", payMoney=" + this.getPayMoney() + ", costPayState=" + this.getCostPayState() + ")";
        }
    }
}

