/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bill.ability.api.FscBillOrderSplitComputeAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSplitComputeAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSplitComputeAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderSplitComputeBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderSplitComputeAbilityService"})
public class FscBillOrderSplitComputeAbilityServiceImpl
implements FscBillOrderSplitComputeAbilityService {
    @Autowired
    private FscBillOrderSplitComputeBusiService fscBillOrderSplitComputeBusiService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;

    @BigDecimalConvert
    @PostMapping(value={"getSplitCompute"})
    public FscBillOrderSplitComputeAbilityRspBO getSplitCompute(@RequestBody FscBillOrderSplitComputeAbilityReqBO reqBO) {
        this.verification(reqBO);
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscBillOrderSplitComputeBusiReqBO busiReqBO = (FscBillOrderSplitComputeBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscBillOrderSplitComputeBusiReqBO.class));
        FscBillOrderSplitComputeBusiRspBO busiRspBO = this.fscBillOrderSplitComputeBusiService.getSplitCompute(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191020", busiRspBO.getRespDesc());
        }
        String rspString = JSON.toJSONString((Object)((Object)busiRspBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        return (FscBillOrderSplitComputeAbilityRspBO)JSON.parseObject((String)rspString, FscBillOrderSplitComputeAbilityRspBO.class);
    }

    private void verification(FscBillOrderSplitComputeAbilityReqBO reqBO) {
        if (null == reqBO.getRuleType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[ruleType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMaxCharge()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[maxCharge]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMaxOrderCount()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[maxOrderCount]\u4e3a\u7a7a");
        }
        if (null == reqBO.getRelOrderList() || reqBO.getRelOrderList().size() == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
    }

    private void paramCheck(BigDecimal maxCharge, Integer maxOrderCount) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("order_split_conditon");
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191020", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (!StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getSettleMoneyMax())) {
            if (maxCharge.compareTo(new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getSettleMoneyMax())) > 0) {
                throw new FscBusinessException("191020", "\u62c6\u5206\u6700\u5927\u91d1\u989d\u9650\u5236\u4e0d\u80fd\u8d85\u8fc7[" + fscCfcUniteParamQryListDetailExternalRspBO.getSettleMoneyMax() + "]");
            }
        } else {
            throw new FscBusinessException("191020", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[settleMoneyMax]\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getOrderNumMax())) {
            if (maxOrderCount.compareTo(Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getOrderNumMax())) > 0) {
                throw new FscBusinessException("191020", "\u62c6\u5206\u6700\u5927\u8ba2\u5355\u6570\u4e0d\u80fd\u8d85\u8fc7[" + fscCfcUniteParamQryListDetailExternalRspBO.getOrderNumMax() + "]");
            }
        } else {
            throw new FscBusinessException("191020", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[orderNumMax]\u8fd4\u56de\u4e3a\u7a7a");
        }
    }
}

